/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import phic.Current;
import phic.Person;
import phic.gui.BuildABod;
import phic.gui.ModalDialog;
import phic.gui.exam.SkinColour;
import phic.modifiable.Range;

public class PersonSetupDialog
extends ModalDialog {
    JPanel jPanel1 = new JPanel();
    Box box1;
    JPanel jPanel2 = new JPanel();
    JButton jButton1 = new JButton();
    JButton jButton2 = new JButton();
    Person person;
    JButton buildabodb = new JButton();
    JPanel jPanel3 = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPanel4 = new JPanel();
    JPanel jPanel5 = new JPanel();
    JPanel jPanel6 = new JPanel();
    JLabel jLabel3 = new JLabel();
    JTextField agetxt = new JTextField();
    JRadioButton ismale = new JRadioButton();
    JRadioButton isfemale = new JRadioButton();
    GridLayout gridLayout2 = new GridLayout();
    JLabel jLabel4 = new JLabel();
    JTextField httxt = new JTextField();
    JLabel jLabel5 = new JLabel();
    JLabel jLabel6 = new JLabel();
    JPanel jPanel7 = new JPanel();
    JLabel jLabel1 = new JLabel();
    JComboBox namefield = new JComboBox();
    FlowLayout flowLayout1 = new FlowLayout();
    ButtonGroup buttonGroup1 = new ButtonGroup();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel8 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JLabel jLabel2 = new JLabel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextArea descfield = new JTextArea();
    Border border1;
    BorderLayout borderLayout3 = new BorderLayout();
    Border border2;
    JPanel jPanel9 = new JPanel();
    JLabel jLabel7 = new JLabel();
    JTextField bmitxt = new JTextField();
    JLabel jLabel8 = new JLabel();
    DefaultComboBoxModel nameModel = new DefaultComboBoxModel();
    public static boolean allowBuildABod = true;
    public boolean okPressed = false;
    Range ageRange = new Range(15.0, 90.0);
    Range heightRange = new Range(1.0, 2.5);
    Range BMIrange = new Range(10.0, 40.0);
    boolean edited;
    JPanel jPanel10 = new JPanel();
    JLabel jLabel9 = new JLabel();
    SkinColour skinColorLabel = new SkinColour();
    JButton jButton3 = new JButton();
    int colorIndex = 0;
    Color[] skinColors = new Color[]{new Color(255, 255, 235), new Color(235, 245, 140), new Color(160, 150, 90), new Color(90, 70, 60)};
    Border border3;
    String[] people;

    public PersonSetupDialog(Person person) {
        this();
        this.person = person;
        this.namefield.setSelectedItem(person.name);
        this.setupDialogFieldsFromPerson(person);
        this.people = Person.getResourceNames();
        int i = 0;
        while (i < this.people.length) {
            this.nameModel.addElement(this.people[i]);
            ++i;
        }
        this.getRootPane().setDefaultButton(this.jButton1);
    }

    void setupDialogFieldsFromPerson(Person person) {
        this.descfield.setText(person.description);
        this.agetxt.setText(String.valueOf(person.age));
        this.httxt.setText(String.valueOf(person.height));
        this.bmitxt.setText(String.valueOf(person.BMI));
        if (person.sex) {
            this.ismale.setSelected(true);
        } else {
            this.isfemale.setSelected(true);
        }
        this.skinColorLabel.basePigment = person.skinBasePigment;
        int i = 0;
        while (i < this.skinColors.length) {
            if (this.skinColorLabel.basePigment.equals(this.skinColors[i])) {
                this.colorIndex = i;
            }
            ++i;
        }
    }

    PersonSetupDialog() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pack();
        this.edited = false;
        this.buildabodb.setEnabled(allowBuildABod);
    }

    private void jbInit() throws Exception {
        this.box1 = Box.createHorizontalBox();
        this.border1 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.border2 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.border3 = BorderFactory.createEtchedBorder();
        this.setTitle("Edit patient details");
        this.jButton1.setText("OK");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PersonSetupDialog.this.jButton1_actionPerformed(e);
            }
        });
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PersonSetupDialog.this.jButton2_actionPerformed(e);
            }
        });
        this.buildabodb.setToolTipText("Edit the person's properties");
        this.buildabodb.setText("Edit...");
        this.buildabodb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PersonSetupDialog.this.buildabodb_actionPerformed(e);
            }
        });
        this.jPanel3.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setHgap(0);
        this.gridLayout1.setRows(5);
        this.jLabel3.setText("Age:");
        this.agetxt.setCaretPosition(0);
        this.agetxt.setText("");
        this.agetxt.setColumns(4);
        this.jPanel6.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel6.setLayout(this.gridLayout2);
        this.ismale.setSelected(false);
        this.ismale.setText("Male");
        this.isfemale.setSelected(false);
        this.isfemale.setText("Female");
        this.gridLayout2.setColumns(1);
        this.gridLayout2.setRows(2);
        this.jLabel4.setText("Height:");
        this.httxt.setText("");
        this.httxt.setColumns(4);
        this.jLabel5.setText("m");
        this.jLabel6.setText("yrs");
        this.jLabel1.setText("Name:");
        this.namefield.setFont(new Font("SansSerif", 1, 12));
        this.namefield.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PersonSetupDialog.this.namefield_itemStateChanged(e);
            }
        });
        this.jPanel4.setLayout(this.flowLayout1);
        this.jPanel1.setLayout(this.borderLayout1);
        this.jPanel8.setLayout(this.borderLayout2);
        this.jLabel2.setText("Description");
        this.descfield.setFont(new Font("SansSerif", 0, 12));
        this.descfield.setLineWrap(true);
        this.descfield.setWrapStyleWord(true);
        this.jPanel8.setBorder(this.border1);
        this.jPanel7.setLayout(this.borderLayout3);
        this.jPanel7.setBorder(this.border2);
        this.jLabel7.setVerifyInputWhenFocusTarget(true);
        this.jLabel7.setText("BMI:");
        this.bmitxt.setSelectedTextColor(Color.white);
        this.bmitxt.setText("");
        this.bmitxt.setColumns(4);
        this.jLabel8.setText("kg/sq m");
        this.jLabel9.setText("Skin:");
        this.jButton3.setMargin(new Insets(2, 2, 2, 2));
        this.jButton3.setText("Change");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PersonSetupDialog.this.skinChangeAction(e);
            }
        });
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.box1, "East");
        this.jPanel1.add((Component)this.jPanel7, "North");
        this.jPanel7.add((Component)this.jLabel1, "West");
        this.jPanel7.add((Component)this.namefield, "Center");
        this.jPanel1.add((Component)this.jPanel8, "Center");
        this.jPanel8.add((Component)this.jLabel2, "North");
        this.jPanel8.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.descfield, null);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.jButton1, null);
        this.jPanel2.add((Component)this.jButton2, null);
        this.jPanel2.add((Component)this.buildabodb, null);
        this.getContentPane().add((Component)this.jPanel3, "East");
        this.jPanel3.add((Component)this.jPanel4, null);
        this.jPanel4.add((Component)this.jLabel3, null);
        this.jPanel4.add((Component)this.agetxt, null);
        this.jPanel4.add((Component)this.jLabel6, null);
        this.jPanel3.add((Component)this.jPanel9, null);
        this.jPanel9.add((Component)this.jLabel7, null);
        this.jPanel9.add((Component)this.bmitxt, null);
        this.jPanel9.add((Component)this.jLabel8, null);
        this.jPanel3.add((Component)this.jPanel6, null);
        this.jPanel6.add((Component)this.ismale, null);
        this.jPanel6.add((Component)this.isfemale, null);
        this.jPanel3.add((Component)this.jPanel5, null);
        this.jPanel5.add((Component)this.jLabel4, null);
        this.jPanel5.add((Component)this.httxt, null);
        this.jPanel5.add((Component)this.jLabel5, null);
        this.jPanel3.add((Component)this.jPanel10, null);
        this.jPanel10.add((Component)this.jLabel9, null);
        this.jPanel10.add((Component)this.skinColorLabel.jPanel1, null);
        this.skinColorLabel.jPanel1.setPreferredSize(new Dimension(20, 15));
        this.jPanel10.add((Component)this.jButton3, null);
        this.buttonGroup1.add(this.ismale);
        this.buttonGroup1.add(this.isfemale);
        this.namefield.setEditable(true);
        this.namefield.setModel(this.nameModel);
        this.skinColorLabel.initialise(Current.body);
    }

    void jButton1_actionPerformed(ActionEvent e) {
        if (this.person.name != this.namefield.getSelectedItem().toString()) {
            this.person.name = this.namefield.getSelectedItem().toString();
            try {
                this.person.setupParametersFromResource(this.person.name);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        this.person.description = this.descfield.getText();
        if (!this.edited && !this.updatePatientParameters()) {
            return;
        }
        this.okPressed = true;
        this.hide();
    }

    void jButton2_actionPerformed(ActionEvent e) {
        this.hide();
    }

    boolean updatePatientParameters() {
        try {
            this.person.age = Double.parseDouble(this.agetxt.getText());
            this.person.height = Double.parseDouble(this.httxt.getText());
            this.person.sex = this.ismale.isSelected();
            this.person.BMI = Double.parseDouble(this.bmitxt.getText());
            if (!this.ageRange.contains(this.person.age)) {
                throw new IllegalArgumentException("Age must be in the range " + this.ageRange + " yrs");
            }
            if (!this.heightRange.contains(this.person.height)) {
                throw new IllegalArgumentException("Height must be in the range " + this.heightRange + " metres");
            }
            if (!this.BMIrange.contains(this.person.BMI)) {
                throw new IllegalArgumentException("BMI must be in the range " + this.BMIrange);
            }
            this.person.calculateEstimates();
            this.person.skinBasePigment = this.skinColors[this.colorIndex];
            return true;
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "Please enter a value for age and height.");
            e.printStackTrace();
            return false;
        }
        catch (IllegalArgumentException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Value out of range.", 2);
            return false;
        }
    }

    void buildabodb_actionPerformed(ActionEvent e) {
        if (!this.updatePatientParameters()) {
            return;
        }
        BuildABod b = new BuildABod();
        b.show();
        if (b.OKpressed) {
            this.edited = true;
        }
    }

    void skinChangeAction(ActionEvent e) {
        this.colorIndex = (this.colorIndex + 1) % this.skinColors.length;
        this.skinColorLabel.basePigment = this.skinColors[this.colorIndex];
        this.skinColorLabel.update();
    }

    void namefield_itemStateChanged(ItemEvent e) {
        String s = this.namefield.getSelectedItem().toString();
        if (this.people != null) {
            int i = 0;
            while (i < this.people.length) {
                if (this.people[i].equals(s)) {
                    Person p = Person.newPersonDetailsFromResource(s);
                    this.setupDialogFieldsFromPerson(p);
                }
                ++i;
            }
        }
    }
}

