/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import phic.Person;
import phic.common.ConsciousLevelOptions;

public class PermissionMenu
extends JPopupMenu {
    JRadioButtonMenuItem restrictall = new JRadioButtonMenuItem();
    JRadioButtonMenuItem allowall = new JRadioButtonMenuItem();
    JCheckBoxMenuItem eatdrink = new JCheckBoxMenuItem();
    JCheckBoxMenuItem sleep = new JCheckBoxMenuItem();
    JCheckBoxMenuItem exercise = new JCheckBoxMenuItem();
    Person person;
    ConsciousLevelOptions uo;
    public Action allowAllAction = new AbstractAction("Allow all"){

        public void actionPerformed(ActionEvent e) {
            PermissionMenu.this.person.environment.NBM = false;
            PermissionMenu.this.person.environment.starve = false;
            PermissionMenu.this.uo.mobile = true;
            PermissionMenu.this.uo.allowSleep = true;
            PermissionMenu.this.updateTicks();
        }
    };
    public Action restrictAllAction = new AbstractAction("Restrict all"){

        public void actionPerformed(ActionEvent e) {
            PermissionMenu.this.person.environment.NBM = true;
            PermissionMenu.this.uo.mobile = false;
            PermissionMenu.this.uo.allowSleep = false;
            PermissionMenu.this.person.body.brain.wakeUp();
            PermissionMenu.this.updateTicks();
        }
    };
    public Action eatDrinkAction = new AbstractAction("Auto eat and drink"){

        public void actionPerformed(ActionEvent e) {
            if (PermissionMenu.this.eatdrink.isSelected()) {
                PermissionMenu.this.person.environment.NBM = false;
                PermissionMenu.this.person.environment.starve = false;
            } else {
                PermissionMenu.this.person.environment.NBM = true;
            }
            PermissionMenu.this.updateRestrictAll();
        }
    };
    public Action exerciseAction = new AbstractAction("Auto exercise"){

        public void actionPerformed(ActionEvent e) {
            PermissionMenu.this.uo.mobile = PermissionMenu.this.exercise.isSelected();
            PermissionMenu.this.updateRestrictAll();
        }
    };
    public Action sleepAction = new AbstractAction("Fall asleep and wake"){

        public void actionPerformed(ActionEvent e) {
            PermissionMenu.this.uo.allowSleep = PermissionMenu.this.sleep.isSelected();
            if (!PermissionMenu.this.uo.allowSleep) {
                PermissionMenu.this.person.body.brain.wakeUp();
            }
            PermissionMenu.this.updateRestrictAll();
        }
    };

    public PermissionMenu(Person person) {
        this.person = person;
        this.uo = person.body.brain.getUnconscious();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addNotify() {
        this.updateTicks();
        this.updateRestrictAll();
        super.addNotify();
    }

    public void setPerson(Person p) {
        this.person = p;
        this.uo = this.person.body.brain.getUnconscious();
        this.updateTicks();
        this.updateRestrictAll();
    }

    private void jbInit() throws Exception {
        this.restrictall.setAction(this.restrictAllAction);
        this.restrictall.setToolTipText("Prevents all spontaneous activity");
        this.restrictall.setVerifyInputWhenFocusTarget(true);
        this.allowall.setSelected(true);
        this.allowall.setToolTipText("Allow all spontaneous activity");
        this.allowall.setAction(this.allowAllAction);
        this.sleep.setToolTipText("Allow spontaneous falling asleep at night and waking in the morning");
        this.sleep.setAction(this.sleepAction);
        this.sleep.setState(false);
        this.exercise.setToolTipText("Allow spontaneous exercising while awake");
        this.exercise.setAction(this.exerciseAction);
        this.eatdrink.setAction(this.eatDrinkAction);
        this.eatdrink.setToolTipText("Allow spontaneous eating and drinking");
        this.add(this.eatdrink);
        this.add(this.sleep);
        this.add(this.exercise);
        this.addSeparator();
        this.add(this.restrictall);
        this.add(this.allowall);
    }

    void updateTicks() {
        this.eatdrink.setSelected(!this.person.environment.NBM && !this.person.environment.starve);
        this.exercise.setSelected(this.uo.mobile);
        this.sleep.setSelected(this.uo.allowSleep);
    }

    void updateRestrictAll() {
        if (!this.person.environment.NBM && !this.person.environment.starve && this.uo.allowSleep && this.uo.mobile) {
            this.allowall.setSelected(true);
            this.restrictall.setSelected(false);
        } else if (this.person.environment.NBM && !this.uo.allowSleep && !this.uo.mobile) {
            this.allowall.setSelected(false);
            this.restrictall.setSelected(true);
        } else {
            this.allowall.setSelected(false);
            this.restrictall.setSelected(false);
        }
    }
}

