/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipInputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import medicine.Entities;
import medicine.Entity;
import medicine.EntityData;
import medicine.EntitySearcher;
import medicine.gui.DiagnosisDialog;
import medicine.gui.EntityEditorPanel;
import medicine.gui.MainFrame;
import phic.Current;
import phic.Resource;
import phic.common.IniReader;
import phic.gui.ModalDialog;
import phic.gui.Node;
import phic.gui.NodeView;
import phic.gui.VDoubleNode;
import phic.gui.Variables;
import phic.gui.VisibleVariable;

public class PathologyAnalysisDialog
extends ModalDialog {
    String predicate = " is suffering from the following pathological problems:";
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JButton jButton2 = new JButton();
    BorderLayout borderLayout1 = new BorderLayout();
    Border border1;
    JPanel jPanel3 = new JPanel();
    Box box1;
    JLabel jLabel1 = new JLabel();
    JLabel varname = new JLabel();
    FlowLayout flowLayout1 = new FlowLayout();
    Box box2;
    JLabel jLabel3 = new JLabel();
    JLabel varval = new JLabel();
    JButton pathologybutton = new JButton();
    public static boolean diagnose = true;
    public boolean readingPathologies = false;
    private Object readPathNotify = new Object();
    boolean diagnosing = false;
    Vector diagnosisSigns = new Vector();
    static MainFrame mf;
    int searchCount = 0;
    JPanel bottompanel = new JPanel();
    JPanel jPanel4 = new JPanel();
    JList problemlist = new JList();
    JScrollPane jScrollPane1 = new JScrollPane();
    BorderLayout borderLayout2 = new BorderLayout();
    JTextArea topcomment = new JTextArea();
    Border border2;
    JButton diagnosebutton = new JButton();
    BorderLayout borderLayout3 = new BorderLayout();
    PathologyData pd;

    public PathologyAnalysisDialog() {
        this.setModal(true);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setPreferredSize(new Dimension(480, 300));
        this.createProblems();
        if (!diagnose) {
            this.diagnosebutton.setVisible(false);
            this.pathologybutton.setVisible(false);
        }
        this.getRootPane().setDefaultButton(this.jButton2);
        PathologyAnalysisDialog.createMainFrame();
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        this.box1 = Box.createVerticalBox();
        this.box2 = Box.createVerticalBox();
        this.border2 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setTitle("Pathology Analysis");
        this.jButton2.setText("OK");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PathologyAnalysisDialog.this.jButton2_actionPerformed(e);
                PathologyAnalysisDialog.this.jPanel2.setBorder(PathologyAnalysisDialog.this.border1);
                PathologyAnalysisDialog.this.jLabel1.setText("Variable:");
                PathologyAnalysisDialog.this.varname.setFont(new Font("Dialog", 1, 12));
                PathologyAnalysisDialog.this.varname.setToolTipText("The name of the selected variable");
                PathologyAnalysisDialog.this.jPanel3.setBorder(BorderFactory.createEtchedBorder());
                PathologyAnalysisDialog.this.jPanel3.setPreferredSize(new Dimension(140, 44));
                PathologyAnalysisDialog.this.jPanel3.setLayout(PathologyAnalysisDialog.this.flowLayout1);
            }
        });
        this.jPanel2.setLayout(this.borderLayout1);
        this.flowLayout1.setAlignment(0);
        this.jLabel3.setToolTipText("");
        this.jLabel3.setText("Value:");
        this.varval.setFont(new Font("Dialog", 1, 12));
        this.varval.setToolTipText("The value of the selected variable");
        this.pathologybutton.setToolTipText("Display the pathology of the selected variable");
        this.pathologybutton.setText("Pathology");
        this.pathologybutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PathologyAnalysisDialog.this.pathologybutton_actionPerformed(e);
            }
        });
        this.problemlist.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                PathologyAnalysisDialog.this.problemlist_valueChanged(e);
            }
        });
        this.jPanel4.setLayout(this.borderLayout2);
        this.topcomment.setLineWrap(true);
        this.topcomment.setPreferredSize(new Dimension(252, 50));
        this.topcomment.setWrapStyleWord(true);
        this.topcomment.setBackground(SystemColor.control);
        this.topcomment.setBorder(this.border2);
        this.topcomment.setEditable(false);
        this.topcomment.setFont(new Font("SansSerif", 0, 14));
        this.diagnosebutton.setToolTipText("Try and come up with a diagnosis that fits the current problems");
        this.diagnosebutton.setText("Diagnose [experimental]");
        this.diagnosebutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PathologyAnalysisDialog.this.diagnosebutton_actionPerformed(e);
            }
        });
        this.jScrollPane1.setToolTipText("List of current problems");
        this.jLabel1.setText("Variable:");
        this.jPanel3.setLayout(this.borderLayout3);
        this.jPanel3.setPreferredSize(new Dimension(150, 53));
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.diagnosebutton, null);
        this.jPanel1.add((Component)this.jButton2, null);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.jPanel3, "East");
        this.jPanel3.add((Component)this.box1, "North");
        this.box1.add((Component)this.jLabel1, null);
        this.box1.add((Component)this.varname, null);
        this.jPanel3.add((Component)this.box2, "Center");
        this.box2.add((Component)this.jLabel3, null);
        this.box2.add((Component)this.varval, null);
        this.jPanel3.add((Component)this.pathologybutton, "South");
        this.jPanel2.add((Component)this.bottompanel, "South");
        this.jPanel2.add((Component)this.jPanel4, "Center");
        this.jPanel4.add((Component)this.jScrollPane1, "Center");
        this.jPanel4.add((Component)this.topcomment, "North");
        this.jScrollPane1.getViewport().setView(this.problemlist);
    }

    void jButton2_actionPerformed(ActionEvent e) {
        mf.hide();
        mf.dispose();
        this.hide();
    }

    void pathologybutton_actionPerformed(ActionEvent e) {
        if (this.problemlist.getSelectedValue() == null) {
            return;
        }
        PathologyAnalysisDialog.createMainFrame();
        String searchString = this.problemlist.getSelectedValue().toString();
        Entity startNode = PathologyAnalysisDialog.mf.editor.navigator.getEntity();
        EntitySearcher es = new EntitySearcher(searchString, startNode, new SearchListener(PathologyAnalysisDialog.mf.editor, searchString));
        es.start();
        mf.show();
    }

    static void createMainFrame() {
        if (mf == null) {
            mf = new MainFrame();
            mf.setDefaultCloseOperation(2);
            Cursor previousCursor = mf.getCursor();
            mf.setCursor(Cursor.getPredefinedCursor(3));
            try {
                try {
                    mf.readTextFromZip(Resource.loader.getResource("Pathology.zip"), "Pathology.zip");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Could not load pathology data file");
                    mf.setCursor(previousCursor);
                }
                catch (Error e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, "For this feature, the program needs to be run using the -ss500k option");
                    mf.setCursor(previousCursor);
                }
            }
            finally {
                mf.setCursor(previousCursor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector readPathologies() {
        this.readingPathologies = true;
        this.diagnosisSigns = new Vector();
        Entity startNode = PathologyAnalysisDialog.mf.editor.navigator.getEntity();
        Object object = this.readPathNotify;
        synchronized (object) {
            block11: {
                Enumeration i = this.pd.getCurrentProblems().elements();
                while (i.hasMoreElements()) {
                    String searchString = i.nextElement().toString();
                    EntitySearcher es = new EntitySearcher(searchString, startNode, new SearchListener(PathologyAnalysisDialog.mf.editor, searchString));
                    ++this.searchCount;
                    es.start();
                }
                try {
                    try {
                        if (this.searchCount > 0) {
                            this.readPathNotify.wait(2500L);
                            if (this.searchCount > 0) {
                                throw new IllegalStateException("Could not find the pathology entities");
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        this.readingPathologies = false;
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    this.readingPathologies = false;
                    throw throwable;
                }
                this.readingPathologies = false;
            }
        }
        return this.diagnosisSigns;
    }

    void foundEntity(EntityEditorPanel editor, Entity e) {
        if (!this.diagnosing && !this.readingPathologies) {
            editor.navigator.setEntity(e);
        } else {
            this.diagnosisSigns.add(e);
        }
    }

    public static MainFrame getMainFrame() {
        PathologyAnalysisDialog.createMainFrame();
        return mf;
    }

    void startDiagnosis() {
        this.diagnosisSigns.removeAllElements();
        this.diagnosing = true;
        PathologyAnalysisDialog.createMainFrame();
        Entity startNode = PathologyAnalysisDialog.mf.editor.navigator.getEntity();
        Enumeration i = this.pd.getCurrentProblems().elements();
        while (i.hasMoreElements()) {
            String searchString = i.nextElement().toString();
            EntitySearcher es = new EntitySearcher(searchString, startNode, new SearchListener(PathologyAnalysisDialog.mf.editor, searchString));
            ++this.searchCount;
            es.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void foundAllEntities() {
        if (this.diagnosing) {
            --this.searchCount;
            if (this.searchCount == 0) {
                this.diagnosing = false;
                this.displayDiagnosis();
            }
        } else if (this.readingPathologies) {
            --this.searchCount;
            if (this.searchCount == 0) {
                Object object = this.readPathNotify;
                synchronized (object) {
                    this.readPathNotify.notifyAll();
                }
            }
        }
    }

    void displayDiagnosis() {
        DiagnosisDialog dd = new DiagnosisDialog(PathologyAnalysisDialog.mf.editor.navigator);
        dd.setModal(true);
        DefaultListModel lm = (DefaultListModel)dd.getObsList().getModel();
        Iterator i = this.diagnosisSigns.iterator();
        while (i.hasNext()) {
            lm.addElement(i.next());
        }
        dd.doDiagnosis();
        dd.show();
    }

    void problemlist_valueChanged(ListSelectionEvent e) {
        String path = this.problemlist.getSelectedValue().toString();
        String problem = this.pd.pathlist.get(path).toString();
        boolean hilo = problem.startsWith("High");
        String variableName = hilo ? problem.substring(5) : problem.substring(4);
        this.varname.setText(variableName);
        VisibleVariable v = Variables.forName(variableName);
        double value = v.node.doubleGetVal();
        this.varval.setText(v.formatValue(value, true, false));
        NodeView nodeView = new NodeView((Node)v.node, 7, null);
        this.bottompanel.removeAll();
        this.bottompanel.add(nodeView);
    }

    void diagnosebutton_actionPerformed(ActionEvent e) {
        this.startDiagnosis();
    }

    public void createProblems() {
        if (this.pd == null) {
            this.pd = new PathologyData();
        }
        this.pd.createProblems();
        this.problemlist.setListData(this.pd.getCurrentProblems());
        this.topcomment.setText(String.valueOf(Current.person.name) + this.predicate);
    }

    public static class PathologyData {
        public static final String PATHOLOGY_FILE = "Pathology.zip";
        EntityData ed;
        Vector currentProblems = new Vector();
        IniReader pathlistreader = new IniReader("Pathology.txt");
        Map pathlist;
        Hashtable conditions = new Hashtable();

        public PathologyData() {
            ZipInputStream s = new ZipInputStream(Resource.loader.getResource(PATHOLOGY_FILE));
            try {
                try {
                    s.getNextEntry();
                    this.ed = Entities.readDataTextForm(s);
                    this.initialiseList();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        s.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                try {
                    s.close();
                }
                catch (IOException iOException) {}
            }
        }

        public void createProblems() {
            this.currentProblems = new Vector();
            int i = 0;
            while (i < Variables.variable.length) {
                VisibleVariable v = Variables.variable[i];
                VDoubleNode node = v.node;
                if (node.getType() == 2) {
                    double value = node.doubleGetVal();
                    if (value > v.maximum) {
                        this.error(true, v);
                    }
                    if (value < v.minimum) {
                        this.error(false, v);
                    }
                }
                ++i;
            }
        }

        void error(boolean hilo, VisibleVariable v) {
            String probname = String.valueOf(hilo ? "High" : "Low") + " " + v.canonicalName;
            Object o = this.conditions.get(probname);
            if (o != null) {
                String path = o.toString();
                this.currentProblems.add(path);
            }
        }

        public Vector getCurrentProblems() {
            return this.currentProblems;
        }

        public void initialiseList() {
            this.pathlist = this.pathlistreader.getSectionMap("Pathology");
            for (Object key : this.pathlist.keySet()) {
                this.conditions.put(this.pathlist.get(key), key);
            }
        }

        public Entity getEntityFromPathology(String pathology) {
            try {
                return this.ed.findEntityExact(this.conditions.get(pathology.intern()).toString());
            }
            catch (Exception e) {
                return null;
            }
        }

        public String getPathologyFromEntity(Entity entity) {
            try {
                return this.pathlist.get(entity.toString().intern()).toString();
            }
            catch (Exception e) {
                return null;
            }
        }

        public Vector getPathologies() {
            Vector<Entity> v = new Vector<Entity>();
            int i = 0;
            while (i < this.currentProblems.size()) {
                String s = (String)this.currentProblems.get(i);
                Entity e = this.ed.findEntityExact(s);
                if (e != null) {
                    v.add(e);
                } else {
                    System.out.println("Unable to find entity " + s);
                }
                ++i;
            }
            return v;
        }

        public EntityData getData() {
            return this.ed;
        }
    }

    class SearchListener
    implements ActionListener {
        EntityEditorPanel editor;
        String name;

        SearchListener(EntityEditorPanel e, String n) {
            this.editor = e;
            this.name = n;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof Entity) {
                Entity entity = (Entity)e.getSource();
                if (entity.equals(this.name)) {
                    PathologyAnalysisDialog.this.foundEntity(this.editor, entity);
                }
            } else {
                PathologyAnalysisDialog.this.foundAllEntities();
            }
        }
    }
}

