/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import phic.Current;
import phic.common.Organ;
import phic.common.Ticker;
import phic.gui.CreateGraphTarget;
import phic.gui.GraphPaper;
import phic.gui.HorizontalBar;
import phic.gui.Node;
import phic.gui.NodeView;
import phic.gui.VariableChooser;
import phic.gui.VisibleVariable;
import phic.modifiable.Range;

public class OrbitPanel
extends NodeView
implements Ticker {
    private static final int MAX_POINTS = 500;
    BorderLayout borderLayout1 = new BorderLayout();
    GraphPaper graph = new GraphPaper(){

        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            super.paint(g);
            g.setColor(OrbitPanel.this.getForeground());
            g.drawString(OrbitPanel.this.yvar.longName, this.getWidth() / 2, 15);
            g.drawString(OrbitPanel.this.xvar.longName, this.getWidth() - 9 * OrbitPanel.this.xvar.longName.length(), this.getHeight() / 2);
            g.setColor(this.getForeground());
            this.drawLine(g, this.minx, 0.0, this.maxx, 0.0);
            this.drawLine(g, 0.0, this.miny, 0.0, this.maxy);
            if (OrbitPanel.this.points.size() > 1) {
                g.setColor(OrbitPanel.this.getForeground());
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Point last = null;
                int i = 0;
                while (i < OrbitPanel.this.points.size()) {
                    Point p1 = OrbitPanel.this.graph.toScreen((Point2D)OrbitPanel.this.points.get(i));
                    if (last != null && p1 != null) {
                        g.drawLine(last.x, last.y, p1.x, p1.y);
                    }
                    last = p1;
                    ++i;
                }
            }
        }
    };
    VisibleVariable xvar;
    VisibleVariable yvar;
    protected double xRadius;
    protected double yRadius;
    Point lastPoint;
    boolean plotting = false;
    Vector points = new Vector();
    ActionListener menuAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            OrbitPanel.this.menuaction(e);
        }
    };
    MouseListener mouse = new MouseAdapter(){

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                OrbitPanel.this.jPopupMenu1.show(OrbitPanel.this, e.getX(), e.getY());
            } else if (!OrbitPanel.this.dragging) {
                OrbitPanel.this.scaleMode = Range.ZOOM_RANGES[OrbitPanel.this.scaleIndex++];
                OrbitPanel.this.scaleIndex %= Range.ZOOM_RANGES.length;
                OrbitPanel.this.setXVariable(OrbitPanel.this.xvar);
                OrbitPanel.this.setYVariable(OrbitPanel.this.yvar);
            }
            OrbitPanel.this.dragging = false;
        }

        public void mousePressed(MouseEvent e) {
            OrbitPanel.this.mousepos = e.getPoint();
        }
    };
    Point mousepos = null;
    boolean dragging;
    MouseMotionListener mouseml = new MouseMotionAdapter(){

        public void mouseDragged(MouseEvent e) {
            if (OrbitPanel.this.mousepos != null) {
                double dx = e.getX() - OrbitPanel.this.mousepos.x;
                double dy = e.getY() - OrbitPanel.this.mousepos.y;
                OrbitPanel.this.xRadius *= 1.0 + -dx * 0.05;
                OrbitPanel.this.yRadius *= 1.0 + dy * 0.05;
                if (dx != 0.0 || dy != 0.0) {
                    OrbitPanel.this.graph.setYRange(-OrbitPanel.this.yRadius, OrbitPanel.this.yRadius);
                    OrbitPanel.this.graph.setXRange(-OrbitPanel.this.xRadius, OrbitPanel.this.xRadius);
                    OrbitPanel.this.repaint();
                }
                OrbitPanel.this.mousepos = e.getPoint();
                OrbitPanel.this.dragging = true;
            }
        }
    };
    int scaleIndex = 2;
    int scaleMode = 2;
    private JPopupMenu jPopupMenu1 = new JPopupMenu();
    private JMenu jMenu1 = new JMenu();
    private JMenuItem jMenuItem1 = new JMenuItem();
    private JMenuItem jMenuItem3 = new JMenuItem();
    private JMenuItem jMenuItem4 = new JMenuItem();
    private JMenu jMenu2 = new JMenu();
    private JMenuItem jMenuItem2 = new JMenuItem();
    private JMenuItem jMenuItem5 = new JMenuItem();
    private JMenuItem jMenuItem6 = new JMenuItem();
    JMenuItem jMenuItem7 = new JMenuItem();
    JMenuItem clearmenu = new JMenuItem();

    public void setXVariable(VisibleVariable v) {
        this.xvar = v;
        Range r = Range.findRange(v.node.doubleGetVal(), this.scaleMode);
        this.xRadius = Math.max(v.initial - r.minimum, r.maximum - v.initial);
        if (this.scaleMode == 2) {
            this.xRadius = Math.max(Math.max(this.xRadius, v.initial - v.minimum), v.maximum - v.initial);
        }
        this.graph.setXRange(-this.xRadius, this.xRadius);
        this.repaint();
        this.lastPoint = null;
    }

    public VisibleVariable getXVariable() {
        return this.xvar;
    }

    public void setYVariable(VisibleVariable v) {
        this.yvar = v;
        Range r = Range.findRange(v.node.doubleGetVal(), this.scaleMode);
        this.yRadius = Math.max(v.initial - r.minimum, r.maximum - v.initial);
        if (this.scaleMode == 2) {
            this.yRadius = Math.max(Math.max(this.yRadius, v.initial - v.minimum), v.maximum - v.initial);
        }
        this.graph.setYRange(-this.yRadius, this.yRadius);
        this.repaint();
        this.lastPoint = null;
    }

    public VisibleVariable getYVariable() {
        return this.yvar;
    }

    public OrbitPanel(CreateGraphTarget cgt) {
        super(null, -1, cgt);
        this.init();
    }

    void scaleToPoints() {
        double maxx = 0.0;
        double maxy = 0.0;
        int i = 0;
        while (i < this.points.size()) {
            Point2D p = (Point2D)this.points.get(i);
            maxx = Math.max(Math.abs(p.getX()), maxx);
            maxy = Math.max(Math.abs(p.getY()), maxy);
            ++i;
        }
        if (maxx > 0.0) {
            this.xRadius = maxx * 1.1;
            this.graph.setXRange(-this.xRadius, this.xRadius);
        }
        if (maxy > 0.0) {
            this.yRadius = maxy * 1.1 * (double)this.getWidth() / (double)this.getHeight();
            this.graph.setYRange(-this.yRadius, this.yRadius);
        }
        this.repaint();
    }

    public OrbitPanel(VisibleVariable xVariable, VisibleVariable yVariable, CreateGraphTarget cgt) {
        super((Node)yVariable.node, -1, cgt);
        this.init();
        this.setXVariable(xVariable);
        this.setYVariable(yVariable);
        HorizontalBar.addBar(this);
    }

    void init() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addMouseListener(this.mouse);
        this.addMouseMotionListener(this.mouseml);
    }

    public void tick(double time) {
        if (Current.body.getClock().running) {
            this.plotPoint();
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void plotPoint() {
        Point2D.Double gpoint = null;
        Organ.DataLock dataLock = Organ.cycleLock;
        synchronized (dataLock) {
            gpoint = new Point2D.Double(this.xvar.node.doubleGetVal() - this.xvar.initial, this.yvar.node.doubleGetVal() - this.yvar.initial);
        }
        if (this.points.size() > 500) {
            Vector np = new Vector();
            int i = 250;
            while (i < this.points.size()) {
                np.add(this.points.get(i));
                ++i;
            }
            this.points = np;
        }
        this.points.add(gpoint);
    }

    private void jbInit() throws Exception {
        this.setForeground(Color.yellow);
        this.graph.setBorder(BorderFactory.createLoweredBevelBorder());
        this.graph.setBackground(Color.black);
        this.graph.setForeground(new Color(0, 128, 92));
        this.graph.setPreferredSize(new Dimension(150, 150));
        this.jMenu1.setText("X");
        this.jMenuItem1.setText("Zoom In");
        this.jMenuItem1.setToolTipText("");
        this.jMenuItem1.setActionCommand("Zoom in X");
        this.jMenuItem1.setText("Zoom in");
        this.jMenuItem1.addActionListener(this.menuAction);
        this.jMenuItem3.setActionCommand("Zoom out X");
        this.jMenuItem3.setText("Zoom out");
        this.jMenuItem3.addActionListener(this.menuAction);
        this.jMenuItem4.setActionCommand("Variable...X");
        this.jMenuItem4.setText("Variable...");
        this.jMenuItem4.addActionListener(this.menuAction);
        this.jMenu2.setText("Y");
        this.jMenuItem2.setActionCommand("Zoom in Y");
        this.jMenuItem2.setText("Zoom in");
        this.jMenuItem2.addActionListener(this.menuAction);
        this.jMenuItem5.setActionCommand("Zoom out Y");
        this.jMenuItem5.setText("Zoom out");
        this.jMenuItem5.addActionListener(this.menuAction);
        this.jMenuItem6.setActionCommand("Variable... Y");
        this.jMenuItem6.setText("Variable...");
        this.jMenuItem6.addActionListener(this.menuAction);
        this.jMenuItem7.setText("Rescale");
        this.jMenuItem7.setActionCommand("Rescale");
        this.jMenuItem7.addActionListener(this.menuAction);
        this.clearmenu.setText("Clear");
        this.content.add(this.graph);
        this.jPopupMenu1.add(this.jMenu1);
        this.jPopupMenu1.add(this.jMenu2);
        this.jPopupMenu1.add(this.clearmenu);
        this.clearmenu.addActionListener(this.menuAction);
        this.jMenu1.add(this.jMenuItem1);
        this.jMenu1.add(this.jMenuItem3);
        this.jMenu1.add(this.jMenuItem4);
        this.jMenu2.add(this.jMenuItem2);
        this.jMenu2.add(this.jMenuItem5);
        this.jMenu2.add(this.jMenuItem6);
        this.jPopupMenu1.add(this.jMenuItem7);
    }

    void menuaction(ActionEvent e) {
        VisibleVariable vcc;
        String s = e.getActionCommand();
        boolean isX = s.endsWith("X");
        if (s.startsWith("Zoom out")) {
            if (isX) {
                this.xRadius *= 2.0;
            } else {
                this.yRadius *= 2.0;
            }
        } else if (s.startsWith("Zoom in")) {
            if (isX) {
                this.xRadius /= 2.0;
            } else {
                this.yRadius /= 2.0;
            }
        } else if (s.startsWith("Rescale")) {
            this.scaleToPoints();
        } else if (s.startsWith("Var") && (vcc = VariableChooser.selectVariable(null)) != null) {
            if (isX) {
                this.setXVariable(vcc);
            } else {
                this.setYVariable(vcc);
            }
        }
        if (s.startsWith("Zoom")) {
            this.graph.setYRange(-this.yRadius, this.yRadius);
            this.graph.setXRange(-this.xRadius, this.xRadius);
            this.repaint();
        } else if (s.startsWith("Clear")) {
            this.points.removeAllElements();
            this.repaint();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        HorizontalBar.removeBar(this);
    }
}

