/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import phic.Current;
import phic.common.CommonThread;
import phic.common.ConsciousLevelOptions;
import phic.common.Organ;
import phic.common.UnitConstants;
import phic.gui.HorizontalBar;
import phic.gui.InterfaceOptionsDialog_allowRewindChk_actionAdapter;
import phic.gui.InterfaceOptionsDialog_cancelbutton_actionAdapter;
import phic.gui.InterfaceOptionsDialog_okbutton_actionAdapter;
import phic.gui.LimitChecker;
import phic.gui.ModalDialog;
import phic.gui.PhicApplication;
import phic.gui.SimplePhicFrame;

public class OptionsDialog
extends ModalDialog {
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JButton okbutton = new JButton();
    JButton cancelbutton = new JButton();
    BorderLayout borderLayout1 = new BorderLayout();
    JTabbedPane jTabbedPane1 = new JTabbedPane();
    JPanel jPanel3 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JCheckBox flashcheck = new JCheckBox();
    JCheckBox outOfRangeCheck = new JCheckBox();
    JCheckBox suppressMessages = new JCheckBox();
    JPanel jPanel4 = new JPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JCheckBox eating = new JCheckBox();
    JCheckBox drinking = new JCheckBox();
    JCheckBox warnunc = new JCheckBox();
    JTextField uncWarnTime = new JTextField();
    JLabel jLabel6 = new JLabel();
    JCheckBox jCheckBox6 = new JCheckBox();
    JCheckBox warnarrest = new JCheckBox();
    JCheckBox disabledeath = new JCheckBox();
    JCheckBox jCheckBox9 = new JCheckBox();
    JCheckBox unitOverride = new JCheckBox();
    JCheckBox shortnamescheck = new JCheckBox();
    JCheckBox horizontal = new JCheckBox();
    JCheckBox breathingnorm = new JCheckBox();
    JPanel jPanel5 = new JPanel();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JCheckBox antiAlias = new JCheckBox();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    JTextField rewindtimefield = new JTextField(4);
    JCheckBox scrollhistorychk = new JCheckBox();
    JCheckBox extendhistorychk = new JCheckBox();
    JCheckBox allowRewindChk = new JCheckBox();
    JLabel jLabel1 = new JLabel();
    JSlider thickslider = new JSlider();
    JLabel thicktxt = new JLabel();
    JCheckBox overlaygraphcheck = new JCheckBox();
    JLabel jLabel2 = new JLabel();
    JTextField delaytxt = new JTextField();
    JLabel jLabel5 = new JLabel();
    JLabel jLabel7 = new JLabel();
    JTextField maxtimetxt = new JTextField();
    JLabel jLabel8 = new JLabel();
    JLabel jLabel9 = new JLabel();
    JTextField tsmoothtxt = new JTextField();
    JLabel jLabel10 = new JLabel();
    JLabel jLabel11 = new JLabel();
    JTextField graphtimetxt = new JTextField();
    JLabel jLabel12 = new JLabel();
    JLabel jLabel13 = new JLabel();
    JTextField slidertimetxt = new JTextField();
    JLabel jLabel14 = new JLabel();
    JCheckBox mousedrawcheck = new JCheckBox();
    JCheckBox randseedchk = new JCheckBox();
    JTextField randseedtxt = new JTextField();
    JSlider prioritySlider = new JSlider();
    JLabel priorityLabel = new JLabel();
    JLabel priorityTxt = new JLabel();

    public OptionsDialog() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getRootPane().setDefaultButton(this.okbutton);
        this.getOptions();
        this.setPreferredSize(new Dimension(350, 370));
    }

    private void jbInit() throws Exception {
        this.setTitle("Interface Options");
        this.okbutton.setText("OK");
        this.okbutton.addActionListener(new InterfaceOptionsDialog_okbutton_actionAdapter(this));
        this.cancelbutton.setText("Cancel");
        this.cancelbutton.addActionListener(new InterfaceOptionsDialog_cancelbutton_actionAdapter(this));
        this.jPanel2.setLayout(this.borderLayout1);
        this.jPanel3.setLayout(this.gridBagLayout1);
        this.flashcheck.setAlignmentX(1.0f);
        this.flashcheck.setAlignmentY(0.5f);
        this.flashcheck.setToolTipText("Indicates whether the value of variables in the scrolling graph will flash when they go out of range");
        this.flashcheck.setText("Enable flashing when out of range");
        this.outOfRangeCheck.setAlignmentX(1.0f);
        this.outOfRangeCheck.setToolTipText("Does the list of out-of-range values at the bottom show only the most important variables");
        this.outOfRangeCheck.setText("Only relevant out-of-range values shown");
        this.suppressMessages.setToolTipText("When the time compression is high, do not display eating, drinking, urine and defaecation messages in the console");
        this.suppressMessages.setText("Suppress messages at faster clock speeds");
        this.jPanel4.setLayout(this.gridBagLayout2);
        this.eating.setText("Stop eating when unconscious");
        this.drinking.setText("Stop drinking when unconscious");
        this.warnunc.setText("Warn if unconscious for more than");
        this.uncWarnTime.setText("8");
        this.uncWarnTime.setColumns(5);
        this.uncWarnTime.setHorizontalAlignment(4);
        this.jLabel6.setText("hours");
        this.jCheckBox6.setText("Assume previous posture when regaining consciousness");
        this.warnarrest.setToolTipText("");
        this.warnarrest.setSelected(false);
        this.warnarrest.setText("Warn before cardiac arrest");
        this.disabledeath.setText("Disable death");
        this.jCheckBox9.setToolTipText("If this is selected, then display the variable editor for the selected item at the bottom of the tree");
        this.jCheckBox9.setText("Show editor for selected variable");
        this.unitOverride.setText("Override internal units");
        this.shortnamescheck.setText("Short names for out-of-range variables");
        this.horizontal.setText("Make horizontal when unconscious");
        this.breathingnorm.setText("Resume normal breathing when unconscious");
        this.jPanel5.setLayout(this.gridBagLayout3);
        this.antiAlias.setText("Anti-alias graph lines");
        this.jLabel3.setText("seconds");
        this.jLabel4.setText("Store rewind data every");
        this.jLabel4.setHorizontalAlignment(2);
        this.rewindtimefield.setHorizontalAlignment(11);
        this.rewindtimefield.setColumns(5);
        this.rewindtimefield.setText("3");
        this.rewindtimefield.setToolTipText("Enter the number of seconds between successive stores for rewinding");
        this.scrollhistorychk.setText("Store scrolling graph history");
        this.extendhistorychk.setText("Keep scrolling history after resetting");
        this.allowRewindChk.setText("Allow Rewind to previous time");
        this.allowRewindChk.addActionListener(new InterfaceOptionsDialog_allowRewindChk_actionAdapter(this));
        this.jLabel1.setText("Graph line thickness");
        this.thicktxt.setText("0");
        this.thickslider.setMaximum(6);
        this.thickslider.setMinimumSize(new Dimension(45, 24));
        this.thickslider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                OptionsDialog.this.thicktxt.setText(String.valueOf(OptionsDialog.this.thickslider.getValue()));
            }
        });
        this.overlaygraphcheck.setText("Variable names and values drawn on top of graph");
        this.jLabel2.setText("Simulation frame delay");
        this.delaytxt.setText("0");
        this.delaytxt.setColumns(5);
        this.delaytxt.setHorizontalAlignment(11);
        this.jLabel5.setText("ms");
        this.jLabel7.setText("Maximum simulation time step");
        this.maxtimetxt.setText("120");
        this.maxtimetxt.setColumns(5);
        this.maxtimetxt.setHorizontalAlignment(11);
        this.jLabel8.setText("seconds");
        this.jLabel9.setText("Time smoothing");
        this.tsmoothtxt.setRequestFocusEnabled(true);
        this.tsmoothtxt.setText("0.9");
        this.tsmoothtxt.setColumns(5);
        this.tsmoothtxt.setHorizontalAlignment(11);
        this.jLabel10.setText("(0 to 1)");
        this.jLabel11.setText("Graph update interval");
        this.graphtimetxt.setText("50");
        this.graphtimetxt.setColumns(5);
        this.graphtimetxt.setHorizontalAlignment(11);
        this.jLabel12.setText("ms");
        this.jLabel13.setText("Slider update interval");
        this.slidertimetxt.setText("200");
        this.slidertimetxt.setColumns(5);
        this.slidertimetxt.setHorizontalAlignment(11);
        this.jLabel14.setText("ms");
        this.mousedrawcheck.setText("Allow mouse drawing on graph");
        this.randseedchk.setText("Use fixed seed for random numbers");
        this.randseedtxt.setText("");
        this.randseedtxt.setColumns(5);
        this.randseedtxt.setHorizontalAlignment(11);
        this.prioritySlider.setMinimum(1);
        this.prioritySlider.setMaximum(10);
        this.prioritySlider.setOrientation(0);
        this.priorityLabel.setText("Thread priority");
        this.prioritySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                OptionsDialog.this.priorityTxt.setText(String.valueOf(OptionsDialog.this.prioritySlider.getValue()));
            }
        });
        this.prioritySlider.setPreferredSize(new Dimension(40, 30));
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.okbutton, null);
        this.jPanel1.add((Component)this.cancelbutton, null);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.jTabbedPane1, "Center");
        this.jTabbedPane1.add((Component)this.jPanel3, "Basic options");
        this.jPanel3.add((Component)this.unitOverride, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.shortnamescheck, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.suppressMessages, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 9), 0, 0));
        this.jPanel3.add((Component)this.jCheckBox9, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.flashcheck, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 16, 0, new Insets(0, 0, 0, 6), 0, 0));
        this.jPanel3.add((Component)this.outOfRangeCheck, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.jLabel1, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.thickslider, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.thicktxt, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.overlaygraphcheck, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.mousedrawcheck, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.randseedchk, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jTabbedPane1.add((Component)this.jPanel4, "Unconscious");
        this.jPanel4.add((Component)this.eating, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.drinking, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.warnunc, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.uncWarnTime, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.jLabel6, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.warnarrest, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.jCheckBox6, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.disabledeath, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.horizontal, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel4.add((Component)this.breathingnorm, new GridBagConstraints(0, 7, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jTabbedPane1.add((Component)this.jPanel5, "Performance");
        this.jPanel5.add((Component)this.jLabel4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.rewindtimefield, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.jLabel3, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.antiAlias, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.scrollhistorychk, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.extendhistorychk, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.allowRewindChk, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.jLabel2, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.delaytxt, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.jLabel5, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.jLabel7, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.maxtimetxt, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.jLabel8, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.jLabel9, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.tsmoothtxt, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.jLabel10, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.jLabel11, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.graphtimetxt, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.jLabel12, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.jLabel13, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.slidertimetxt, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.jLabel14, new GridBagConstraints(2, 9, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel3.add((Component)this.randseedtxt, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.priorityLabel, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.prioritySlider, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel5.add((Component)this.priorityTxt, new GridBagConstraints(2, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    void okbutton_actionPerformed(ActionEvent e) {
        boolean nfe = false;
        try {
            this.setOptions();
        }
        catch (NumberFormatException x) {
            JOptionPane.showMessageDialog(this, "A value entered was out of range. Please correct it, or press cancel to keep original value.", "Number format error", 0);
            x.printStackTrace();
            nfe = true;
        }
        if (!nfe) {
            this.hide();
        }
    }

    private void setOptions() {
        SimplePhicFrame f = (SimplePhicFrame)PhicApplication.frame.getJFrame();
        f.graph.flashIfOutOfRange = this.flashcheck.isSelected();
        f.rewindDialog.setSaveInterval((int)Math.max(1000.0 * Double.parseDouble(this.rewindtimefield.getText()), 300.0));
        f.showSelectedVariableEditor = this.jCheckBox9.isSelected();
        LimitChecker.showOnlyVisibleNodes = this.outOfRangeCheck.isSelected();
        UnitConstants.setUseUnitOverrides(this.unitOverride.isSelected());
        LimitChecker.useShortNames = this.shortnamescheck.isSelected();
        Current.body.setLogRoutineEventsIfFast(!this.suppressMessages.isSelected());
        f.graph.mainpane.antiAlias = this.antiAlias.isSelected();
        f.graph.mainpane.thickness = this.thickslider.getValue();
        f.graph.mainpane.overlayGraphVariables = this.overlaygraphcheck.isSelected();
        f.graph.mainpane.allowDrawOnGraph = this.mousedrawcheck.isSelected();
        Organ.useRandomSeed = this.randseedchk.isSelected();
        Organ.randomSeed = Long.parseLong(this.randseedtxt.getText());
        ConsciousLevelOptions u = Current.body.brain.getUnconscious();
        u.eat = !this.eating.isSelected();
        u.drink = !this.drinking.isSelected();
        u.flat = this.horizontal.isSelected();
        u.normalBreathing = this.breathingnorm.isSelected();
        u.notify = this.warnunc.isSelected();
        u.notifyHours = Double.parseDouble(this.uncWarnTime.getText());
        f.graph.setEnableHistory(this.scrollhistorychk.isSelected());
        f.graph.enableWholeSessionHistory = this.extendhistorychk.isSelected();
        f.setRewindEnabled(this.allowRewindChk.isSelected());
        u.disableDeath = this.disabledeath.isSelected();
        u.warnArrest = this.warnarrest.isSelected();
        CommonThread t = Current.thread;
        t.CYCLE_LENGTH_MILLIS = (int)Double.parseDouble(this.delaytxt.getText());
        CommonThread.MAXIMUM_ELAPSED_SECONDS = (int)Double.parseDouble(this.maxtimetxt.getText());
        t.TIME_SMOOTHING = Double.parseDouble(this.tsmoothtxt.getText());
        f.graph.setTimer(Integer.parseInt(this.graphtimetxt.getText()));
        HorizontalBar.BAR_UPDATE_INTERVAL = (int)Double.parseDouble(this.slidertimetxt.getText());
        t.setPriority(this.prioritySlider.getValue());
    }

    private void getOptions() {
        SimplePhicFrame f = (SimplePhicFrame)PhicApplication.frame.getJFrame();
        this.flashcheck.setSelected(f.graph.flashIfOutOfRange);
        this.rewindtimefield.setText(String.valueOf((double)f.rewindDialog.getSaveInterval() / 1000.0));
        this.jCheckBox9.setSelected(f.showSelectedVariableEditor);
        this.outOfRangeCheck.setSelected(LimitChecker.showOnlyVisibleNodes);
        this.unitOverride.setSelected(UnitConstants.getUseUnitOverrides());
        this.shortnamescheck.setSelected(LimitChecker.useShortNames);
        this.suppressMessages.setSelected(!Current.body.getLogRoutineEventsIfFast());
        this.antiAlias.setSelected(f.graph.mainpane.antiAlias);
        this.thickslider.setValue(f.graph.mainpane.thickness);
        this.thicktxt.setText(Integer.toString(this.thickslider.getValue()));
        this.overlaygraphcheck.setSelected(f.graph.mainpane.overlayGraphVariables);
        this.mousedrawcheck.setSelected(f.graph.mainpane.allowDrawOnGraph);
        this.randseedchk.setSelected(Organ.useRandomSeed);
        this.randseedtxt.setText(String.valueOf(Organ.randomSeed));
        ConsciousLevelOptions u = Current.body.brain.getUnconscious();
        this.eating.setSelected(!u.eat);
        this.drinking.setSelected(!u.drink);
        this.horizontal.setSelected(u.flat);
        this.breathingnorm.setSelected(u.normalBreathing);
        this.warnunc.setSelected(u.notify);
        this.uncWarnTime.setText(String.valueOf(u.notifyHours));
        this.scrollhistorychk.setSelected(f.graph.getEnableHistory());
        this.extendhistorychk.setSelected(f.graph.enableWholeSessionHistory);
        this.allowRewindChk.setSelected(f.isRewindEnabled());
        this.rewindtimefield.setEnabled(f.isRewindEnabled());
        this.disabledeath.setSelected(u.disableDeath);
        this.warnarrest.setSelected(u.warnArrest);
        CommonThread t = Current.thread;
        this.delaytxt.setText(String.valueOf(t.CYCLE_LENGTH_MILLIS));
        this.maxtimetxt.setText(String.valueOf(CommonThread.MAXIMUM_ELAPSED_SECONDS));
        this.tsmoothtxt.setText(String.valueOf(t.TIME_SMOOTHING));
        this.graphtimetxt.setText(String.valueOf(f.graph.getTimer()));
        this.slidertimetxt.setText(String.valueOf(HorizontalBar.BAR_UPDATE_INTERVAL));
        this.prioritySlider.setValue(t.getPriority());
    }

    void cancelbutton_actionPerformed(ActionEvent e) {
        this.hide();
    }

    void allowRewindChk_actionPerformed(ActionEvent e) {
        this.rewindtimefield.setEnabled(this.allowRewindChk.isSelected());
    }

    void thickslider_stateChanged(ChangeEvent e) {
    }
}

