/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import phic.Current;
import phic.Resource;
import phic.common.Container;
import phic.common.Quantity;
import phic.common.Ticker;
import phic.common.VDoubleReadOnly;
import phic.gui.ContainerDiagram;
import phic.gui.ContainerView;
import phic.gui.CreateGraphTarget;
import phic.gui.CurveNodeView;
import phic.gui.CurveViewPanel;
import phic.gui.HorizontalBar;
import phic.gui.Node;
import phic.gui.NodeView;
import phic.gui.PhicApplication;
import phic.gui.ScrollGraphPane;
import phic.gui.ThinButtonSet;
import phic.gui.ThinNodeView;
import phic.gui.ValueRangeLabel;
import phic.gui.VariablePropertiesDialog;
import phic.gui.Variables;
import phic.gui.VisibleVariable;

public class OldNodeView
extends JPanel {
    static ImageIcon methodicon = new ImageIcon(Resource.loader.getImageResource("Method.gif"));
    static final int DOUBLE_VALUE = 0;
    static final int DOUBLE_BAR = 1;
    static final int DOUBLE_SCROLLGRAPH = 2;
    static final int DOUBLE_SLIDER = 3;
    static final int BOOLEAN_CHECKBOX = 4;
    static final int METHOD_BUTTON = 5;
    static final int CONTAINER_TABLE = 6;
    static final int VALUE_RANGE = 7;
    static final int CONTAINER_DIAGRAM = 8;
    static final int THIN_VIEW = 9;
    static final int THIN_READ_ONLY = 10;
    static final int CURVE = 11;
    static final int CURVE_POINTX = 12;
    static final int CURVE_POINTY = 13;
    public static String[] string = new String[]{"Value", "Bar", "Graph", "Slider", "Checkbox", "Button", "Table", "Value+Range", "Diagram", "Strip", "StripView", "Curve", "CurvePointX", "CurvePointY"};
    public static Type[] doubleType = new Type[]{new Type(9), new Type(10), new Type(1), new Type(7)};
    public static Type[] booleanType = new Type[]{new Type(9), new Type(4)};
    public static Type[] methodType = new Type[]{new Type(9), new Type(5)};
    public static Type[] containerType = new Type[]{new Type(6), new Type(8)};
    public static Type[] curveViewType = new Type[]{new Type(11), new Type(12), new Type(13)};
    public static Type[] doubleReadOnlyType = new Type[]{new Type(1), new Type(10)};
    Node node;
    VisibleVariable v;
    java.awt.Container content;
    OldNodeView thisView = this;
    JPanel panel = new JPanel();
    HorizontalBar h;
    JCheckBox check;
    TitleBar titleBar;
    ThinNodeView t;
    int type;
    Ticker ticker;
    CreateGraphTarget cgt = null;

    public void replaceVariables() {
        if (this.v != null) {
            this.v = Variables.forName(this.v.canonicalName);
            this.node = this.v.node;
            if (this.type == 1) {
                this.h.setVariable(this.v);
            }
            if (this.type == 9 || this.type == 10) {
                this.t.replaceVariables();
            }
        } else {
            this.node = Node.findNodeByName(this.node.canonicalName());
            if (this.type == 4) {
                this.check.setSelected(this.node.booleanGetVal());
            }
        }
    }

    void gui() {
        this.setLayout(new BorderLayout());
        this.panel.setLayout(new BorderLayout());
        this.titleBar = this.v != null ? new TitleBar(this.v) : new TitleBar(this.node);
        this.add((Component)this.titleBar, "North");
        this.titleBar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Close")) {
                    OldNodeView.this.setVisible(false);
                    java.awt.Container p = OldNodeView.this.getParent();
                    p.remove(OldNodeView.this.thisView);
                }
            }
        });
        this.setBorder(BorderFactory.createEtchedBorder());
        this.content = this;
    }

    public boolean needsNewFrame() {
        return this.type == 7 || this.type == 6;
    }

    public OldNodeView(Node n, Type t, CreateGraphTarget cgt) {
        this(n, t.type, cgt);
    }

    public OldNodeView(Node n, int view, CreateGraphTarget cgt) {
        this.node = n;
        this.type = view;
        this.cgt = cgt;
        if (this.node != null) {
            this.v = Variables.forNode(this.node);
        }
        this.gui();
        if (view == -1) {
            return;
        }
        switch (view) {
            case 0: {
                final JLabel label = new JLabel();
                final Node ntmp = n;
                this.ticker = new Ticker(){
                    double oldVal = Double.NaN;

                    public void tick(double time) {
                        double newVal = ntmp.doubleGetVal();
                        if (newVal != this.oldVal) {
                            this.oldVal = newVal;
                            if (OldNodeView.this.v == null) {
                                label.setText(Quantity.toString(newVal));
                            } else {
                                label.setText(OldNodeView.this.v.formatValue(newVal, true, true));
                            }
                        }
                        if (OldNodeView.this.getParent() == null) {
                            HorizontalBar.removeBar(this);
                        }
                    }
                };
                this.ticker.tick(0.0);
                this.add(label);
                HorizontalBar.addBar(this.ticker);
                break;
            }
            case 2: {
                ScrollGraphPane s = new ScrollGraphPane();
                s.setVariable(this.v);
                this.add((Component)s, "Center");
                break;
            }
            case 1: {
                this.h = new HorizontalBar();
                if (this.v == null) {
                    this.h.setNode(this.node);
                } else {
                    this.h.setVariable(this.v);
                }
                this.h.setFont(new Font("Dialog", 1, 12));
                this.add(this.h);
                break;
            }
            case 4: {
                this.check = this.v == null ? new JCheckBox(n.canonicalName(), n.booleanGetVal()) : new JCheckBox(this.v.longName, n.booleanGetVal());
                this.check.addChangeListener(new CheckChangeListener());
                this.add(this.check);
                break;
            }
            case 6: {
                Object o = n.objectGetVal();
                if (!(o instanceof Container)) break;
                ContainerView c = new ContainerView((Container)o, true);
                this.add((Component)c, "Center");
                break;
            }
            case 7: {
                if (this.v == null) break;
                ValueRangeLabel vv = new ValueRangeLabel(this.v);
                this.add(vv);
                break;
            }
            case 5: {
                String name = n.canonicalName();
                name = name.substring(name.indexOf(47, 1) + 1);
                JButton b = new JButton(name, methodicon);
                b.addActionListener(new ButtonListener());
                this.add(b);
                break;
            }
            case 3: {
                this.add(new SliderView(this.node));
                break;
            }
            case 8: {
                ContainerDiagram d = new ContainerDiagram();
                d.setContainer((Container)this.node.objectGetVal());
                this.add((Component)d, "Center");
                break;
            }
            case 9: 
            case 10: {
                this.t = n.getType() == 8 ? new ThinButtonSet() : new ThinNodeView();
                this.t.setNode(n);
                this.add((Component)this.t, "Center");
                this.remove(this.titleBar);
                this.t.setCreateGraphTarget(cgt);
                this.t.closebutton.setVisible(TitleBar.allowClose);
                this.t.graphcheckbox.setVisible(TitleBar.allowClose);
                this.content = this.t;
                if (view != 10) break;
                this.t.setReadOnly(true);
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                CurveViewPanel cv = new CurveViewPanel();
                cv.setCurveNode(this.node);
                cv.setPreferredSize(new Dimension(100, 100));
                cv.findAndAddAllCurvePointNodes();
                this.add((Component)cv, "Center");
                break;
            }
            default: {
                throw new RuntimeException("Unknown view type " + view);
            }
        }
    }

    public void displayNodeDialog() {
        if (this.v != null) {
            VariablePropertiesDialog d = new VariablePropertiesDialog();
            d.setVariable(this.v);
            d.setModal(true);
            d.show();
        } else {
            System.out.println(String.valueOf(this.node.canonicalName()) + " is not a visible variable");
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String comment = OldNodeView.this.node.getLeafName();
            PhicApplication.markEvent(comment);
            Current.body.message(comment);
            OldNodeView.this.node.methodInvoke();
        }
    }

    class CheckChangeListener
    implements ChangeListener {
        CheckChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            boolean on = ((JCheckBox)e.getSource()).isSelected();
            boolean prev = OldNodeView.this.node.booleanGetVal();
            if (prev != on) {
                OldNodeView.this.node.booleanSetVal(on);
                String comment = String.valueOf(OldNodeView.this.node.getLeafName()) + (on ? " on" : " off");
                PhicApplication.markEvent(comment);
                Current.body.message(comment);
            }
        }
    }

    class SliderView
    extends JPanel
    implements Ticker,
    ChangeListener {
        JLabel text;
        JSlider slider;
        double startval;
        boolean automaticAdjust = false;
        double oldVal = Double.NaN;

        SliderView(Node n) {
            this.setLayout(new BorderLayout());
            OldNodeView.this.node = n;
            this.slider = new JSlider(0);
            this.text = new JLabel("");
            this.add((Component)this.slider, "Center");
            this.add((Component)this.text, "East");
            this.slider.setValue(50);
            this.slider.addChangeListener(this);
            this.tick(0.0);
            this.slider.setPreferredSize(new Dimension(100, this.slider.getPreferredSize().height));
            this.text.setPreferredSize(new Dimension(60, this.text.getPreferredSize().height));
            HorizontalBar.addBar(this);
            this.startval = n.doubleGetVal();
        }

        public void removeNotify() {
            HorizontalBar.removeBar(this);
            HorizontalBar.removeBar(OldNodeView.this.ticker);
        }

        public void tick(double t) {
            if (OldNodeView.this.v != null) {
                this.automaticAdjust = true;
                double value = OldNodeView.this.node.doubleGetVal();
                if (value != this.oldVal) {
                    this.oldVal = value;
                    this.slider.setValue((int)(100.0 * (value - OldNodeView.this.v.minimum) / (OldNodeView.this.v.maximum - OldNodeView.this.v.minimum)));
                    this.text.setText(OldNodeView.this.v.formatValue(value, true, false));
                }
                this.automaticAdjust = false;
            }
        }

        public void stateChanged(ChangeEvent e) {
            String newString;
            double newVal;
            if (this.automaticAdjust) {
                return;
            }
            if (OldNodeView.this.v != null) {
                newVal = OldNodeView.this.v.minimum + (OldNodeView.this.v.maximum - OldNodeView.this.v.minimum) * (double)this.slider.getValue() / 100.0;
                newString = OldNodeView.this.v.formatValue(newVal, true, false);
            } else {
                newVal = this.startval * (1.0 + (double)(this.slider.getValue() - 50) / 50.0);
                newString = Quantity.toString(newVal);
            }
            OldNodeView.this.node.doubleSetVal(newVal);
            this.text.setText(newString);
        }
    }

    public static class TitleBar
    extends JPanel {
        public static boolean allowClose = true;
        Node node;
        VisibleVariable variable;
        String title = "";
        JLabel label = new JLabel();
        JButton closebutton = new JButton();
        ActionListener al = null;

        public void addActionListener(ActionListener al2) {
            this.al = AWTEventMulticaster.add(this.al, al2);
        }

        public void removeActionListener(ActionListener al2) {
            this.al = AWTEventMulticaster.remove(al2, this.al);
        }

        public TitleBar(Node n) {
            this.node = n;
            if (this.node == null) {
                String name = "View";
            } else {
                this.title = this.node.canonicalName();
                if (this.title.startsWith("/Environment/")) {
                    this.title = this.title.substring(13);
                }
                if (this.title.startsWith("/Body/")) {
                    this.title = this.title.substring(6);
                }
            }
            this.init();
        }

        public TitleBar(VisibleVariable v) {
            this.variable = v;
            this.node = v.node;
            this.title = v.longName;
            this.init();
        }

        private void init() {
            this.setLayout(new BorderLayout());
            this.label.setOpaque(true);
            this.label.setText(this.title);
            this.label.setBackground(SystemColor.activeCaption);
            this.label.setForeground(SystemColor.activeCaptionText);
            this.label.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent e) {
                    TitleBar.this.displayNodeDialog();
                }
            });
            String toolTip = this.variable == null ? this.node.canonicalName() : String.valueOf(this.variable.longName) + " (" + this.node.canonicalName() + ")";
            this.label.setToolTipText(toolTip);
            this.add((Component)this.label, "Center");
            if (allowClose) {
                this.closebutton.setToolTipText("Close this graph");
                this.closebutton.setIcon(new ImageIcon(Resource.loader.getImageResource("SmallCross.gif")));
                this.closebutton.setMargin(new Insets(0, 0, 0, 0));
                this.closebutton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TitleBar.this.setVisible(false);
                        java.awt.Container p = TitleBar.this.getParent();
                        if (TitleBar.this.al != null) {
                            TitleBar.this.al.actionPerformed(new ActionEvent(this, 0, "Close"));
                        }
                        p.invalidate();
                    }
                });
                this.add((Component)this.closebutton, "East");
            }
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String s) {
            this.title = s;
            this.label.setText(s);
        }

        public void displayNodeDialog() {
            if (this.variable != null) {
                VariablePropertiesDialog d = new VariablePropertiesDialog();
                d.setVariable(this.variable);
                d.show();
            } else {
                System.out.println(String.valueOf(this.node.canonicalName()) + " is not a visible variable");
            }
        }
    }

    public static class Type {
        int type;

        public Type(int a) {
            this.type = a;
        }

        public Type(String name) {
            int i = 0;
            while (i < string.length) {
                if (string[i].equals(name)) {
                    this.type = i;
                    return;
                }
                ++i;
            }
            throw new IllegalArgumentException("No such display type " + name);
        }

        public static Type[] forNode(Node node) {
            if (node != null) {
                switch (node.getType()) {
                    case 2: {
                        if (node.member instanceof Field && VDoubleReadOnly.class.isAssignableFrom(((Field)node.member).getType())) {
                            return doubleReadOnlyType;
                        }
                        return doubleType;
                    }
                    case 3: {
                        return booleanType;
                    }
                    case 1: {
                        return methodType;
                    }
                    case 4: {
                        return containerType;
                    }
                    case 6: {
                        return curveViewType;
                    }
                    case 8: {
                        return new Type[]{new Type(9)};
                    }
                }
            }
            return new Type[0];
        }

        public NodeView instantiate(Node n, CreateGraphTarget cgt) {
            if (this.type != 11 && this.type != 12 && this.type != 13) {
                return new NodeView(n, this, cgt);
            }
            if (this.type == 12 || this.type == 13) {
                return new NodeView(n, 9, cgt);
            }
            return new CurveNodeView(n, this, cgt);
        }

        public String toString() {
            return string[this.type];
        }
    }
}

