/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import phic.BasicActions;
import phic.Resource;
import phic.common.ClassVisualiser;
import phic.common.Container;
import phic.common.Curve;
import phic.common.Gas;
import phic.common.Organ;
import phic.common.Quantity;
import phic.common.VDouble;
import phic.common.VDoubleReadOnly;
import phic.common.Variable;
import phic.gui.Variables;
import phic.gui.VisibleVariable;

public abstract class Node
extends DefaultMutableTreeNode {
    Member member;
    Object object;
    protected static Vector allNodes = new Vector();
    public static final int NON_VISUAL = 0;
    public static final int SIMPLE_METHOD = 1;
    public static final int DOUBLE = 2;
    public static final int BOOLEAN = 3;
    public static final int CONTAINER = 4;
    public static final int ORGAN = 5;
    public static final int CURVE = 6;
    public static final int GAS = 7;
    public static final int COMPLEX_ACTION = 8;
    static final Properties aliases = new Properties();

    public Node(Member staticMember) {
        super(staticMember, true);
        try {
            aliases.load(Resource.loader.getResource("NodeAlias.txt"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.member = staticMember;
        this.object = null;
        allNodes.add(this);
    }

    public Node(Member nonstaticMember, Object object) {
        super(nonstaticMember, true);
        try {
            aliases.load(Resource.loader.getResource("NodeAlias.txt"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.member = nonstaticMember;
        this.object = object;
        allNodes.add(this);
    }

    public int getType() {
        if (this.member instanceof ClassVisualiser) {
            Object t = ((ClassVisualiser)this.member).object;
            if (t instanceof Container) {
                return 4;
            }
            if (t instanceof Organ) {
                return 5;
            }
            if (t instanceof Curve) {
                return 6;
            }
            if (t instanceof Gas) {
                return 7;
            }
        }
        if (this.member instanceof Method) {
            Method m = (Method)this.member;
            if (m.getReturnType() == Void.TYPE) {
                return 1;
            }
            if (m.getReturnType() == Double.TYPE) {
                return 2;
            }
        } else if (this.member instanceof Field) {
            Field f = (Field)this.member;
            if (f.getType() == Double.TYPE) {
                return 2;
            }
            if (ClassVisualiser.is(f.getType(), Variable.class)) {
                return 2;
            }
            if (f.getType() == Boolean.TYPE) {
                return 3;
            }
            if (ClassVisualiser.is(f.getType(), BasicActions.ComplexAction.class)) {
                return 8;
            }
        }
        return 0;
    }

    public String stringGetVal() {
        int t = this.getType();
        if (t == 1) {
            return this.canonicalName();
        }
        if (t == 3) {
            return Boolean.toString(this.booleanGetVal());
        }
        if (t == 4) {
            return ((Container)this.objectGetVal()).toString();
        }
        if (t == 2) {
            if (this.member instanceof Field) {
                Field f = (Field)this.member;
                if (f.getType() == Double.TYPE) {
                    return Quantity.toString(this.doubleGetVal());
                }
                try {
                    if (ClassVisualiser.is(f.getType(), VDouble.class)) {
                        return ((VDouble)f.get(this.object)).formatValue(true, false);
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                if (ClassVisualiser.is(f.getType(), Variable.class)) {
                    return Quantity.toString(this.doubleGetVal());
                }
            } else if (this.member instanceof Method) {
                return Quantity.toString(this.doubleGetVal());
            }
        }
        return "Unknown value";
    }

    public Object objectGetVal() {
        try {
            if (this.member instanceof Field) {
                return ((Field)this.member).get(this.object);
            }
            if (this.member instanceof Method) {
                return ((Method)this.member).invoke(this.object, null);
            }
            if (this.member instanceof ClassVisualiser) {
                return ((ClassVisualiser)this.member).object;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void objectSetVal(Object value) {
        try {
            if (this.member instanceof Field) {
                ((Field)this.member).set(this.object, value);
            } else {
                System.out.println("Cannot set node " + this.canonicalName() + " to " + value.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean booleanGetVal() {
        try {
            return (Boolean)((Field)this.member).get(this.object);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void booleanSetVal(boolean b) {
        try {
            ((Field)this.member).set(this.object, new Boolean(b));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public double doubleGetVal() {
        try {
            if (this.member instanceof Field) {
                Field f = (Field)this.member;
                if (f.getType() == Double.TYPE) {
                    return f.getDouble(this.object);
                }
                if (ClassVisualiser.is(f.getType(), Variable.class)) {
                    return ((Variable)f.get(this.object)).get();
                }
            } else if (this.member instanceof Method) {
                return (Double)((Method)this.member).invoke(this.object, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Double.NaN;
    }

    public void doubleSetVal(double d) {
        try {
            if (this.member instanceof Field) {
                Field f = (Field)this.member;
                if (f.getType() == Double.TYPE) {
                    f.setDouble(this.object, d);
                }
                if (ClassVisualiser.is(f.getType(), Variable.class)) {
                    ((Variable)f.get(this.object)).set(d);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void methodInvoke() {
        try {
            ((Method)this.member).invoke(this.object, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isSettable() {
        if (this.member instanceof Field) {
            Field f = (Field)this.member;
            if (f.getType() == Double.TYPE) {
                return true;
            }
            if (f.getType() == Boolean.TYPE) {
                return true;
            }
            if (VDoubleReadOnly.class.isAssignableFrom(f.getType())) {
                return false;
            }
            if (Variable.class.isAssignableFrom(f.getType())) {
                return true;
            }
        }
        return false;
    }

    public void vdoubleSetRanges(double initialValue, double minimum, double maximum) {
        Object o = this.objectGetVal();
        if (VDouble.class.isInstance(o)) {
            ((VDouble)o).setRanges(initialValue, minimum, maximum);
        }
    }

    public String canonicalName() {
        TreeNode[] n = this.getPath();
        String s = "";
        Node a = null;
        int i = 0;
        while (i < n.length) {
            if (n[i] instanceof Node) {
                a = (Node)n[i];
                if (a.member != null) {
                    s = String.valueOf(s) + '/' + a.member.getName();
                }
            }
            ++i;
        }
        return s;
    }

    public String canonicalNameReplaced() {
        String cp = this.canonicalName();
        if ((cp = cp.replace('/', '.')).startsWith(".")) {
            cp = cp.substring(1);
        }
        if (cp.startsWith("B")) {
            cp = "b" + cp.substring(1);
        }
        if (cp.startsWith("E")) {
            cp = "e" + cp.substring(1);
        }
        return cp;
    }

    public static Node findNodeByName(String pathname) {
        if ((pathname = pathname.replace('/', '.')).startsWith(".")) {
            pathname = pathname.substring(1);
        }
        int i = 0;
        while (i < allNodes.size()) {
            Node n = (Node)allNodes.get(i);
            String name = n.canonicalName().replace('/', '.');
            if (name.startsWith(".")) {
                name = name.substring(1);
            }
            if (name.equalsIgnoreCase(pathname)) {
                return n;
            }
            if (name.startsWith("Body") && name.length() > 5) {
                if ((name = name.substring(5)).equals(pathname)) {
                    return n;
                }
                if ((name = "body." + name).equals(pathname)) {
                    return n;
                }
            } else if (name.startsWith("Environment") && name.length() > 12) {
                if ((name = name.substring(12)).equals(pathname)) {
                    return n;
                }
                if ((name = "environment." + name).equals(pathname)) {
                    return n;
                }
            }
            ++i;
        }
        throw new IllegalArgumentException("No such node, " + pathname);
    }

    public String getLeafName() {
        return this.member.getName();
    }

    public String getFriendlyName() {
        try {
            VisibleVariable v = Variables.forName(this.canonicalName());
            return Resource.identifierToText(v.longName);
        }
        catch (IllegalArgumentException e) {
            String r = aliases.getProperty(this.canonicalName());
            if (r != null && r.length() > 0) {
                return r;
            }
            return Resource.identifierToText(this.getLeafName());
        }
    }
}

