/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import javax.swing.BorderFactory;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import phic.Current;
import phic.Resource;
import phic.common.Container;
import phic.common.Quantity;
import phic.common.Ticker;
import phic.gui.ContainerDiagram;
import phic.gui.ContainerView;
import phic.gui.HorizontalBar;
import phic.gui.Node;
import phic.gui.PhicApplication;
import phic.gui.ScrollGraphPane;
import phic.gui.ValueRangeLabel;
import phic.gui.VariablePropertiesDialog;
import phic.gui.Variables;
import phic.gui.VisibleVariable;

public class NewNodeView
extends JDesktopPane {
    static ImageIcon methodicon = new ImageIcon(Resource.loader.getImageResource("Method.gif"));
    static final int DOUBLE_VALUE = 0;
    static final int DOUBLE_BAR = 1;
    static final int DOUBLE_SCROLLGRAPH = 2;
    static final int DOUBLE_SLIDER = 3;
    static final int BOOLEAN_CHECKBOX = 4;
    static final int METHOD_BUTTON = 5;
    static final int CONTAINER_TABLE = 6;
    static final int VALUE_RANGE = 7;
    static final int CONTAINER_DIAGRAM = 8;
    public static String[] string = new String[]{"Value", "Bar", "Graph", "Slider", "Checkbox", "Button", "Table", "Value+Range", "Diagram"};
    public static Type[] doubleType = new Type[]{new Type(3), new Type(1), new Type(2), new Type(0), new Type(7)};
    public static Type[] booleanType = new Type[]{new Type(4)};
    public static Type[] methodType = new Type[]{new Type(5)};
    public static Type[] containerType = new Type[]{new Type(6), new Type(8)};
    static final String[] iconResources = new String[]{"Double.gif", "Double.gif", "Double.gif", "Double.gif", "Tick.gif", "Method.gif", "Container.gif", "Double.gif", "Container.gif"};
    Node node;
    VisibleVariable v;
    JButton closebutton = new JButton();
    NewNodeView thisView = this;
    JPanel panel = new JPanel();
    HorizontalBar h;
    JCheckBox check;
    TitleBar titleBar;
    java.awt.Container content;
    JInternalFrame f;
    int type;
    Ticker ticker;
    static DesktopManager desktopManager = new DefaultDesktopManager(){

        public void dragFrame(JComponent c, int x, int y) {
        }
    };

    public void replaceVariables() {
        if (this.v != null) {
            this.v = Variables.forName(this.v.canonicalName);
            this.node = this.v.node;
            if (this.type == 1) {
                this.h.setVariable(this.v);
            }
        } else {
            this.node = Node.findNodeByName(this.node.canonicalName());
            if (this.type == 4) {
                this.check.setSelected(this.node.booleanGetVal());
            }
        }
    }

    void gui() {
        JComponent o;
        String name;
        this.setLayout(new BorderLayout());
        if (this.v == null && this.node != null) {
            name = this.node.canonicalName();
            if (name.startsWith("/Environment/")) {
                name = name.substring(13);
            }
            if (name.startsWith("/Body/")) {
                name = name.substring(6);
            }
        } else {
            name = this.v != null ? this.v.longName : "View";
        }
        this.f = new JInternalFrame(name);
        this.content = this.f.getContentPane();
        this.f.setBorder(BorderFactory.createEtchedBorder(1));
        this.f.setResizable(false);
        this.f.setClosable(true);
        if (this.type >= 0 && this.type < iconResources.length) {
            String iconResource = iconResources[this.type];
            this.f.setFrameIcon(new ImageIcon(Resource.loader.getImageResource(iconResource)));
        }
        this.add((Component)this.f, "Center");
        this.setDesktopManager(desktopManager);
        if (this.f.getUI() instanceof BasicInternalFrameUI && (o = ((BasicInternalFrameUI)this.f.getUI()).getNorthPane()) instanceof JComponent) {
            JComponent p = o;
            p.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent e) {
                    NewNodeView.this.displayNodeDialog();
                }
            });
            Font f = p.getFont();
            if (f != null) {
                p.setFont(f.deriveFont(0, 10.0f));
            }
            String toolTip = this.v == null ? this.node.canonicalName() : String.valueOf(this.v.longName) + " (" + this.node.canonicalName() + ")";
            p.setToolTipText(toolTip);
        }
        this.f.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosed(InternalFrameEvent e) {
                final java.awt.Container c = NewNodeView.this.thisView.getParent();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        c.remove((this).NewNodeView.this.thisView);
                        c.getParent().invalidate();
                        c.getParent().validate();
                    }
                });
            }
        });
        if (this.v != null) {
            this.titleBar = new TitleBar(this.v);
        } else if (this.node != null) {
            this.titleBar = new TitleBar(this.node);
        }
        this.titleBar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Close")) {
                    NewNodeView.this.setVisible(false);
                    java.awt.Container p = NewNodeView.this.getParent();
                    p.remove(NewNodeView.this.thisView);
                }
            }
        });
    }

    void finishGui() {
        this.f.pack();
        this.setPreferredSize(this.f.getPreferredSize());
    }

    public void addNotify() {
        super.addNotify();
        try {
            this.f.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.f.show();
    }

    public boolean needsNewFrame() {
        return this.type == 7 || this.type == 6;
    }

    public NewNodeView(Node n, Type t) {
        this(n, t.type);
    }

    public NewNodeView(Node n, int view) {
        this.node = n;
        this.type = view;
        if (this.node != null) {
            this.v = Variables.forNode(this.node);
        }
        this.gui();
        if (view == -1) {
            return;
        }
        switch (view) {
            case 0: {
                final JLabel label = new JLabel();
                final Node ntmp = n;
                this.ticker = new Ticker(){
                    double oldVal = Double.NaN;

                    public void tick(double time) {
                        double newVal = ntmp.doubleGetVal();
                        if (newVal != this.oldVal) {
                            this.oldVal = newVal;
                            if (NewNodeView.this.v == null) {
                                label.setText(Quantity.toString(newVal));
                            } else {
                                label.setText(NewNodeView.this.v.formatValue(newVal, true, true));
                            }
                        }
                        if (NewNodeView.this.getParent() == null) {
                            HorizontalBar.removeBar(this);
                        }
                    }
                };
                this.ticker.tick(0.0);
                this.content.add(label);
                HorizontalBar.addBar(this.ticker);
                break;
            }
            case 2: {
                ScrollGraphPane s = new ScrollGraphPane();
                s.setVariable(this.v);
                this.content.add((Component)s, "Center");
                break;
            }
            case 1: {
                this.h = new HorizontalBar();
                if (this.v == null) {
                    this.h.setNode(this.node);
                } else {
                    this.h.setVariable(this.v);
                }
                this.h.setFont(new Font("Dialog", 1, 12));
                this.content.add(this.h);
                break;
            }
            case 4: {
                this.check = this.v == null ? new JCheckBox(n.canonicalName(), n.booleanGetVal()) : new JCheckBox(this.v.longName, n.booleanGetVal());
                this.check.addChangeListener(new CheckChangeListener());
                this.content.add(this.check);
                break;
            }
            case 6: {
                Object o = n.objectGetVal();
                if (!(o instanceof Container)) break;
                ContainerView c = new ContainerView((Container)o, true);
                this.content.add((Component)c, "Center");
                break;
            }
            case 7: {
                if (this.v == null) break;
                ValueRangeLabel vv = new ValueRangeLabel(this.v);
                this.content.add(vv);
                break;
            }
            case 5: {
                String name = n.canonicalName();
                name = name.substring(name.indexOf(47, 1) + 1);
                JButton b = new JButton(name, methodicon);
                b.addActionListener(new ButtonListener());
                this.content.add(b);
                break;
            }
            case 3: {
                this.content.add(new SliderView(this.node));
                break;
            }
            case 8: {
                ContainerDiagram d = new ContainerDiagram();
                d.setContainer((Container)this.node.objectGetVal());
                this.content.add((Component)d, "Center");
                break;
            }
            default: {
                throw new RuntimeException("Unknown view type " + view);
            }
        }
        this.finishGui();
    }

    public void displayNodeDialog() {
        if (this.v != null) {
            VariablePropertiesDialog d = new VariablePropertiesDialog();
            d.setVariable(this.v);
            d.show();
        } else {
            System.out.println(String.valueOf(this.node.canonicalName()) + " is not a visible variable");
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String comment = NewNodeView.this.node.getLeafName();
            PhicApplication.markEvent(comment);
            Current.body.message(comment);
            NewNodeView.this.node.methodInvoke();
        }
    }

    class CheckChangeListener
    implements ChangeListener {
        CheckChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            boolean on = ((JCheckBox)e.getSource()).isSelected();
            boolean prev = NewNodeView.this.node.booleanGetVal();
            if (prev != on) {
                NewNodeView.this.node.booleanSetVal(on);
                String comment = String.valueOf(NewNodeView.this.node.getLeafName()) + (on ? " On" : " Off");
                PhicApplication.markEvent(comment);
                Current.body.message(comment);
            }
        }
    }

    class SliderView
    extends JPanel
    implements Ticker,
    ChangeListener {
        JLabel text;
        JSlider slider;
        double startval;
        boolean automaticAdjust = false;
        double oldVal = Double.NaN;

        SliderView(Node n) {
            this.setLayout(new BorderLayout());
            NewNodeView.this.node = n;
            this.slider = new JSlider(0);
            this.text = new JLabel("");
            this.add((Component)this.slider, "Center");
            this.add((Component)this.text, "East");
            this.slider.setValue(50);
            this.slider.addChangeListener(this);
            this.tick(0.0);
            this.slider.setPreferredSize(new Dimension(100, this.slider.getPreferredSize().height));
            this.text.setPreferredSize(new Dimension(60, this.text.getPreferredSize().height));
            HorizontalBar.addBar(this);
            this.startval = n.doubleGetVal();
        }

        public void removeNotify() {
            HorizontalBar.removeBar(this);
            HorizontalBar.removeBar(NewNodeView.this.ticker);
            super.removeNotify();
        }

        public void tick(double t) {
            if (NewNodeView.this.v != null) {
                this.automaticAdjust = true;
                double value = NewNodeView.this.node.doubleGetVal();
                if (value != this.oldVal) {
                    this.oldVal = value;
                    this.slider.setValue((int)(100.0 * (value - NewNodeView.this.v.minimum) / (NewNodeView.this.v.maximum - NewNodeView.this.v.minimum)));
                    this.text.setText(NewNodeView.this.v.formatValue(value, true, false));
                }
                this.automaticAdjust = false;
            }
        }

        public void stateChanged(ChangeEvent e) {
            String newString;
            double newVal;
            if (this.automaticAdjust) {
                return;
            }
            if (NewNodeView.this.v != null) {
                newVal = NewNodeView.this.v.minimum + (NewNodeView.this.v.maximum - NewNodeView.this.v.minimum) * (double)this.slider.getValue() / 100.0;
                newString = NewNodeView.this.v.formatValue(newVal, true, false);
            } else {
                newVal = this.startval * (1.0 + (double)(this.slider.getValue() - 50) / 50.0);
                newString = Quantity.toString(newVal);
            }
            NewNodeView.this.node.doubleSetVal(newVal);
            this.text.setText(newString);
        }
    }

    public static class TitleBar
    extends JPanel {
        Node node;
        VisibleVariable variable;
        String title = "";
        JLabel label = new JLabel();
        JButton closebutton = new JButton();
        ActionListener al = null;

        public void addActionListener(ActionListener al2) {
            this.al = AWTEventMulticaster.add(this.al, al2);
        }

        public void removeActionListener(ActionListener al2) {
            this.al = AWTEventMulticaster.remove(al2, this.al);
        }

        public TitleBar(Node n) {
            this.node = n;
            if (this.node == null) {
                String name = "View";
            } else {
                this.title = this.node.canonicalName();
                if (this.title.startsWith("/Environment/")) {
                    this.title = this.title.substring(13);
                }
                if (this.title.startsWith("/Body/")) {
                    this.title = this.title.substring(6);
                }
            }
            this.init();
        }

        public TitleBar(VisibleVariable v) {
            this.variable = v;
            this.node = v.node;
            this.title = v.longName;
            this.init();
        }

        private void init() {
            this.setLayout(new BorderLayout());
            this.label.setOpaque(true);
            this.label.setText(this.title);
            this.label.setBackground(SystemColor.activeCaption);
            this.label.setForeground(SystemColor.activeCaptionText);
            this.label.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent e) {
                    TitleBar.this.displayNodeDialog();
                }
            });
            String toolTip = this.variable == null ? this.node.canonicalName() : String.valueOf(this.variable.longName) + " (" + this.node.canonicalName() + ")";
            this.label.setToolTipText(toolTip);
            this.add((Component)this.label, "Center");
            this.closebutton.setToolTipText("Close this graph");
            this.closebutton.setIcon(new ImageIcon(Resource.loader.getImageResource("SmallCross.gif")));
            this.closebutton.setMargin(new Insets(0, 0, 0, 0));
            this.closebutton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TitleBar.this.setVisible(false);
                    java.awt.Container p = TitleBar.this.getParent();
                    TitleBar.this.al.actionPerformed(new ActionEvent(this, 0, "Close"));
                    p.invalidate();
                }
            });
            this.add((Component)this.closebutton, "East");
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String s) {
            this.title = s;
            this.label.setText(s);
        }

        public void displayNodeDialog() {
            if (this.variable != null) {
                VariablePropertiesDialog d = new VariablePropertiesDialog();
                d.setVariable(this.variable);
                d.show();
            } else {
                System.out.println(String.valueOf(this.node.canonicalName()) + " is not a visible variable");
            }
        }
    }

    public static class Type {
        int type;

        public Type(int a) {
            this.type = a;
        }

        public Type(String name) {
            int i = 0;
            while (i < string.length) {
                if (string[i].equals(name)) {
                    this.type = i;
                    return;
                }
                ++i;
            }
            throw new IllegalArgumentException("No such display type " + name);
        }

        public static Type[] forNode(Node node) {
            if (node != null) {
                switch (node.getType()) {
                    case 2: {
                        return doubleType;
                    }
                    case 3: {
                        return booleanType;
                    }
                    case 1: {
                        return methodType;
                    }
                    case 4: {
                        return containerType;
                    }
                }
            }
            return new Type[0];
        }

        public String toString() {
            return string[this.type];
        }
    }
}

