/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.lang.reflect.Member;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import phic.common.IniReader;
import phic.gui.Node;
import phic.gui.Variables;
import phic.gui.VisibleVariable;

public class LimitedNode
extends Node {
    public DefaultMutableTreeNode realParent;
    static IniReader list = new IniReader("VisibleNodes.txt");
    static boolean fullVisibility = true;
    static Vector visibleNodes;
    public static String visibleNodesSection;

    static {
        LimitedNode.setFullVisibility();
        visibleNodesSection = null;
    }

    public LimitedNode(Member staticMember, DefaultMutableTreeNode parent) {
        super(staticMember);
        this.realParent = parent;
        this.checkVisibility();
    }

    public LimitedNode(Member nonstaticMember, Object object, DefaultMutableTreeNode parent) {
        super(nonstaticMember, object);
        this.realParent = parent;
        this.checkVisibility();
    }

    protected void checkVisibility() {
    }

    public static void setVisibleNodesDelayed(final String section) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LimitedNode.setVisibleNodes(section);
            }
        });
    }

    public static void setVisibleNodes(String section) {
        visibleNodesSection = section;
        LimitedNode.setupVisibleNodes();
    }

    public static void setupVisibleNodes() {
        if (visibleNodesSection == null) {
            LimitedNode.setFullVisibility();
            return;
        }
        System.out.println("Setting visibility to '" + visibleNodesSection + "'...");
        fullVisibility = false;
        visibleNodes = new Vector();
        String[] varnames = list.getSectionStrings(visibleNodesSection);
        int i = 0;
        while (i < Node.allNodes.size()) {
            LimitedNode n = (LimitedNode)Node.allNodes.get(i);
            boolean found = false;
            int j = 0;
            while (j < varnames.length) {
                if (n.nameEquals(varnames[j])) {
                    found = true;
                }
                ++j;
            }
            if (found) {
                n.ensureConnected();
            } else if (!visibleNodes.contains(n)) {
                n.removeFromParent();
            }
            ++i;
        }
        System.out.println("Visibility set to '" + visibleNodesSection + "'.");
    }

    public boolean nameEquals(String s) {
        String cname = this.canonicalName();
        if (cname.equalsIgnoreCase(s)) {
            return true;
        }
        VisibleVariable vv = Variables.forNode(this);
        if (vv != null && (vv.canonicalName.equalsIgnoreCase(s) || vv.longName.equalsIgnoreCase(s) || vv.shortName.equals(s))) {
            return true;
        }
        if (this.canonicalName().indexOf(47) >= 0) {
            String n = cname.replace('/', '.');
            if (n.charAt(0) == '.') {
                n = n.substring(1);
            }
            if (n.equalsIgnoreCase(s)) {
                return true;
            }
        }
        return false;
    }

    public static void setFullVisibility() {
        fullVisibility = true;
        if (visibleNodes == null) {
            visibleNodes = new Vector();
        }
        int i = 0;
        while (i < Node.allNodes.size()) {
            LimitedNode n = (LimitedNode)Node.allNodes.get(i);
            n.ensureConnected();
            ++i;
        }
    }

    protected void ensureConnected() {
        DefaultMutableTreeNode testNode = this;
        visibleNodes.add(this);
        while (testNode != null && !testNode.isRoot()) {
            if (testNode.getParent() == null) {
                this.realParent.add(this);
            }
            visibleNodes.add(this.realParent);
            testNode = testNode instanceof LimitedNode ? testNode.realParent : null;
        }
    }

    public boolean isVisible() {
        if (visibleNodes == null) {
            return true;
        }
        return visibleNodes.contains(this);
    }

    public static LimitedNode createOrFind(Member member, Object object, DefaultMutableTreeNode parent) {
        int i = 0;
        while (i < Node.allNodes.size()) {
            LimitedNode node = (LimitedNode)Node.allNodes.get(i);
            if (node.member.getName().equalsIgnoreCase(member.getName()) && node.object == object) {
                node.realParent = parent;
                return node;
            }
            ++i;
        }
        return new LimitedNode(member, object, parent);
    }
}

