/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreeNode;
import phic.common.LifeSupport;
import phic.common.UnitConstants;
import phic.gui.ModalDialog;
import phic.gui.Node;
import phic.gui.VariableSelectionCombo;
import phic.gui.Variables;
import phic.gui.VisibleVariable;

public class LifeSupportDialog
extends ModalDialog {
    private JPanel jPanel1 = new JPanel();
    private JPanel jPanel2 = new JPanel();
    private JButton jButton1 = new JButton();
    private JPanel jPanel3 = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JPanel jPanel4 = new JPanel();
    private JScrollPane jScrollPane2 = new JScrollPane();
    private JList varlist = new JList();
    private BorderLayout borderLayout3 = new BorderLayout();
    private JPanel jPanel5 = new JPanel();
    private JButton addvar = new JButton();
    private JButton removevar = new JButton();
    private JPanel jPanel6 = new JPanel();
    private JLabel jLabel1 = new JLabel();
    protected LifeSupport lifeSupport;
    private JButton selectAllButton = new JButton();
    private JPanel jPanel7 = new JPanel();
    private JPanel jPanel8 = new JPanel();
    private BorderLayout borderLayout4 = new BorderLayout();
    JTextField valuetxt = new JTextField();
    private JLabel jLabel2 = new JLabel();
    private JLabel unittxt = new JLabel();
    double unit;
    JPanel jPanel9 = new JPanel();
    BorderLayout borderLayout5 = new BorderLayout();
    VariableSelectionCombo variableSelectionCombo1 = new VariableSelectionCombo();
    VisibleVariable currentVar = null;
    JPanel jPanel10 = new JPanel();
    GridLayout gridLayout1 = new GridLayout();

    protected LifeSupportDialog() {
        this.init();
    }

    public LifeSupportDialog(LifeSupport ls) {
        this.lifeSupport = ls;
        this.init();
        this.updateList();
        this.getRootPane().setDefaultButton(this.jButton1);
    }

    protected void init() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setPreferredSize(new Dimension(550, 250));
    }

    private void jbInit() throws Exception {
        this.jButton1.setText("OK");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LifeSupportDialog.this.jButton1_actionPerformed(e);
            }
        });
        this.jPanel1.setLayout(this.borderLayout1);
        this.jPanel3.setLayout(this.borderLayout2);
        this.jPanel4.setLayout(this.borderLayout3);
        this.jScrollPane2.setPreferredSize(new Dimension(200, 100));
        this.addvar.setText("Add >>");
        this.addvar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LifeSupportDialog.this.addvar_actionPerformed(e);
            }
        });
        this.removevar.setText("<< Remove");
        this.removevar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LifeSupportDialog.this.removevar_actionPerformed(e);
            }
        });
        this.setTitle("Clamp variable values");
        this.jLabel1.setText("Select which variables will be artificially held constant");
        this.selectAllButton.setText("Select all");
        this.selectAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LifeSupportDialog.this.selectAllButton_actionPerformed(e);
            }
        });
        this.jPanel7.setLayout(this.borderLayout4);
        this.jLabel2.setText("Value");
        this.valuetxt.setColumns(8);
        this.valuetxt.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                LifeSupportDialog.this.valuetxt_focusLost(e);
            }
        });
        this.valuetxt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LifeSupportDialog.this.valuetxt_actionPerformed(e);
            }
        });
        this.varlist.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                LifeSupportDialog.this.varlist_valueChanged(e);
            }
        });
        this.jPanel9.setLayout(this.borderLayout5);
        this.variableSelectionCombo1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LifeSupportDialog.this.variableSelectionCombo1_actionPerformed(e);
            }
        });
        this.jPanel10.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(3);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jPanel3, "Center");
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.jButton1, null);
        this.getContentPane().add((Component)this.jPanel6, "North");
        this.jPanel6.add((Component)this.jLabel1, null);
        this.jPanel3.add((Component)this.jPanel4, "East");
        this.jPanel4.add((Component)this.jScrollPane2, "Center");
        this.jPanel4.add((Component)this.jPanel7, "South");
        this.jPanel7.add((Component)this.jPanel8, "Center");
        this.jPanel8.add((Component)this.valuetxt, null);
        this.jPanel8.add((Component)this.unittxt, null);
        this.jPanel7.add((Component)this.jLabel2, "West");
        this.jPanel3.add((Component)this.jPanel5, "Center");
        this.jPanel5.add((Component)this.jPanel10, null);
        this.jPanel10.add((Component)this.selectAllButton, null);
        this.jPanel10.add((Component)this.removevar, null);
        this.jPanel10.add((Component)this.addvar, null);
        this.jPanel3.add((Component)this.jPanel9, "West");
        this.jPanel9.add((Component)this.variableSelectionCombo1, "North");
        this.variableSelectionCombo1.setPreferredSize(new Dimension(160, this.variableSelectionCombo1.getPreferredSize().height));
        this.jScrollPane2.getViewport().add((Component)this.varlist, null);
    }

    void jButton1_actionPerformed(ActionEvent e) {
        this.hide();
    }

    protected void updateList() {
        DefaultListModel<VisibleVariable> lm = new DefaultListModel<VisibleVariable>();
        int i = 0;
        while (i < Variables.variable.length) {
            if (this.lifeSupport.isFudgeVariable(i)) {
                lm.addElement(Variables.variable[i]);
            }
            ++i;
        }
        this.varlist.setModel(lm);
    }

    void addvar_actionPerformed(ActionEvent e) {
        Object o = null;
        if (o instanceof Node) {
            Node n = (Node)o;
            this.addNode(n);
            return;
        }
        o = this.variableSelectionCombo1.getSelectedItem();
        if (o instanceof VisibleVariable) {
            this.addNode(((VisibleVariable)o).node);
            return;
        }
        if (o == null) {
            o = "Null";
        }
        JOptionPane.showMessageDialog(null, "Cannot apply clamp to " + o.toString(), "Invalid variable", 0);
    }

    protected void addNode(Node n) {
        VisibleVariable v = Variables.forNode(n);
        if (v != null && n.isSettable()) {
            this.lifeSupport.setFudgeVariable(v, true);
            this.updateList();
            return;
        }
        int i = 0;
        while (i < n.getChildCount()) {
            TreeNode nn = n.getChildAt(i);
            if (nn instanceof Node) {
                this.addNode((Node)nn);
            }
            ++i;
        }
    }

    void removevar_actionPerformed(ActionEvent e) {
        Object[] o = this.varlist.getSelectedValues();
        int i = 0;
        while (i < o.length) {
            if (!(o[i] instanceof VisibleVariable)) {
                throw new RuntimeException("Unexpected non-variable in variable list: " + o);
            }
            VisibleVariable v = (VisibleVariable)o[i];
            this.lifeSupport.setFudgeVariable(v, false);
            this.updateList();
            ++i;
        }
    }

    void selectAllButton_actionPerformed(ActionEvent e) {
        this.varlist.setSelectionInterval(0, this.varlist.getModel().getSize() - 1);
    }

    public void setSelection(VisibleVariable v) {
        if (this.lifeSupport.isFudgeVariable(v)) {
            this.varlist.setSelectedValue(v, true);
        }
    }

    void varlist_valueChanged(ListSelectionEvent e) {
        this.currentVar = (VisibleVariable)this.varlist.getSelectedValue();
        VisibleVariable v = this.currentVar;
        if (v != null) {
            double val = this.lifeSupport.getFudgeValue(v);
            String s = v.formatValue(val, true, false);
            int i = s.indexOf(32);
            this.valuetxt.setText(s.substring(0, i));
            this.unittxt.setText(s.substring(i + 1));
            this.valuetxt.setEnabled(true);
            this.unit = UnitConstants.getUnitMultiplier(val, v.units);
            this.valuetxt.grabFocus();
        } else {
            this.unittxt.setText("");
            this.valuetxt.setText("");
            this.valuetxt.setEnabled(false);
        }
    }

    void valuetxt_actionPerformed(ActionEvent e) {
        this.updateValue();
    }

    void valuetxt_focusLost(FocusEvent e) {
        this.updateValue();
    }

    void updateValue() {
        VisibleVariable v = this.currentVar;
        if (v != null) {
            String s = this.valuetxt.getText();
            if (s == "") {
                this.lifeSupport.setFudgeValue(v, v.node.getVDouble().initialValue);
                this.valuetxt.setText(v.formatValue(this.lifeSupport.getFudgeValue(v), false, true));
            }
            try {
                double value = Double.parseDouble(s);
                this.lifeSupport.setFudgeValue(v, value * this.unit);
            }
            catch (NumberFormatException x) {
                x.printStackTrace();
                JOptionPane.showMessageDialog(this, "Not a valid number: " + s);
            }
        }
    }

    void variableSelectionCombo1_actionPerformed(ActionEvent e) {
        VisibleVariable o = this.variableSelectionCombo1.selectedVariable;
        if (o instanceof VisibleVariable) {
            VisibleVariable vv = o;
            this.addNode(vv.node);
        }
    }
}

