/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import phic.Current;
import phic.IntravenousInfusion;
import phic.Resource;
import phic.common.UnitConstants;
import phic.drug.DrugContainer;
import phic.gui.DrugDialog;

public class InfusionPanel
extends JPanel {
    Border border1;
    FlowLayout flowLayout1 = new FlowLayout();
    JLabel namelabel = new JLabel();
    private Box box2;
    BoxLayout boxlayout;
    private JPanel jPanel1 = new JPanel();
    private JPanel jPanel2 = new JPanel();
    private JButton pharmacy = new JButton();
    private JButton eatbutton = new JButton();
    private JCheckBox continuous_check = new JCheckBox();
    private FlowLayout flowLayout2 = new FlowLayout();
    JPanel jPanel3 = new JPanel();
    JSlider rateslider = new JSlider();
    Box box1;
    JLabel ratelabel = new JLabel();
    BorderLayout borderLayout1 = new BorderLayout();
    Box fluidbox;
    protected Timer timer = new Timer(500, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            InfusionPanel.this.syringebutton.repaint();
        }
    });
    public IntravenousInfusion infusion;
    final double maximumFluid = 1.0;
    final Color fluidColour = Color.cyan;
    JToggleButton syringebutton = new JToggleButton(){

        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(InfusionPanel.this.fluidColour);
            int w = (int)((double)(this.getWidth() - 4) * (InfusionPanel.this.infusion.volume.get() / 1.0));
            g.fill3DRect(2, this.getHeight() - 6, w, 4, this.isSelected());
        }
    };

    public InfusionPanel(IntravenousInfusion i, String name) {
        this();
        this.infusion = i;
        this.namelabel.setText(name);
        this.rateslider.setValue((int)(1000.0 * i.rate));
        this.syringebutton.setOpaque(false);
    }

    public void removeNotify() {
        this.timer.stop();
        super.removeNotify();
    }

    InfusionPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.syringebutton.setIcon(new ImageIcon(Resource.loader.getImageResource("SyringeSmall.gif")));
        this.pharmacy.setIcon(new ImageIcon(Resource.loader.getImageResource("Pharmacy.jpg")));
        this.eatbutton.setIcon(new ImageIcon(Resource.loader.getImageResource("Mouth.gif")));
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createLineBorder(SystemColor.control, 2);
        this.fluidbox = Box.createVerticalBox();
        this.box2 = Box.createVerticalBox();
        this.box1 = Box.createVerticalBox();
        this.boxlayout = new BoxLayout(this, 0);
        this.setLayout(this.boxlayout);
        this.flowLayout1.setHgap(2);
        this.flowLayout1.setVgap(2);
        this.syringebutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InfusionPanel.this.syringebutton_actionPerformed(e);
            }
        });
        this.syringebutton.setMargin(new Insets(2, 2, 2, 2));
        this.syringebutton.setToolTipText("Infuse drug");
        this.syringebutton.setAlignmentX(0.5f);
        this.syringebutton.setOpaque(false);
        this.namelabel.setAlignmentX(0.5f);
        this.namelabel.setText("Fluid");
        this.pharmacy.setBackground(Color.white);
        this.pharmacy.setToolTipText("Add pharmaceuticals");
        this.pharmacy.setMargin(new Insets(2, 2, 2, 2));
        this.pharmacy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InfusionPanel.this.pharmacy_actionPerformed(e);
            }
        });
        this.eatbutton.setToolTipText("Ingest this fluid");
        this.eatbutton.setMargin(new Insets(0, 0, 0, 0));
        this.eatbutton.setText("");
        this.eatbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InfusionPanel.this.eatbutton_actionPerformed(e);
            }
        });
        this.continuous_check.setToolTipText("Replace drips as soon as they finish");
        this.continuous_check.setText("Repeat");
        this.continuous_check.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InfusionPanel.this.continuous_check_actionPerformed(e);
            }
        });
        this.jPanel1.setLayout(this.flowLayout2);
        this.flowLayout2.setAlignment(0);
        this.rateslider.setValue(16);
        this.rateslider.setMaximum(30);
        this.rateslider.setMajorTickSpacing(10);
        this.rateslider.setPaintTicks(true);
        this.rateslider.setMinorTickSpacing(5);
        this.rateslider.setPaintLabels(true);
        this.rateslider.setToolTipText("Rate of infusion /ml per minute");
        this.rateslider.setPreferredSize(new Dimension(80, 50));
        this.rateslider.setMinimumSize(new Dimension(36, 50));
        this.rateslider.setLabelTable(this.rateslider.createStandardLabels(30));
        this.rateslider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                InfusionPanel.this.rateslider_stateChanged(e);
            }
        });
        this.ratelabel.setText("19 ml/min");
        this.jPanel3.setLayout(this.borderLayout1);
        this.jPanel3.setPreferredSize(new Dimension(80, 67));
        this.add((Component)this.fluidbox, null);
        this.fluidbox.add((Component)this.syringebutton, null);
        this.fluidbox.add((Component)this.namelabel, null);
        this.jPanel1.add((Component)this.eatbutton, null);
        this.jPanel1.add((Component)this.pharmacy, null);
        this.jPanel2.add((Component)this.continuous_check, null);
        this.box2.add((Component)this.jPanel1, null);
        this.box2.add((Component)this.jPanel2, null);
        this.add((Component)this.jPanel3, null);
        this.jPanel3.add((Component)this.box1, "Center");
        this.box1.add((Component)this.rateslider, null);
        this.box1.add((Component)this.ratelabel, null);
        this.add((Component)this.box2, null);
    }

    void rateslider_stateChanged(ChangeEvent e) {
        this.infusion.rate = (double)this.rateslider.getValue() * 0.001;
        this.ratelabel.setText(UnitConstants.formatValue(this.infusion.rate, 12, true, false));
    }

    void syringebutton_actionPerformed(ActionEvent e) {
        if (this.infusion.isRunning()) {
            this.infusion.stop();
        } else {
            this.infusion.start();
        }
        if (this.infusion.isRunning()) {
            this.timer.start();
        } else {
            this.timer.stop();
        }
    }

    void pharmacy_actionPerformed(ActionEvent e) {
        DrugDialog dd = new DrugDialog();
        dd.show();
        DrugContainer drugs = dd.getDrugContainer();
        if (drugs != null) {
            this.infusion.add(drugs);
            JLabel label = new JLabel("+" + dd.getDrugLabel());
            label.setAlignmentX(0.5f);
            this.fluidbox.add(label);
            this.validate();
        }
    }

    void eatbutton_actionPerformed(ActionEvent e) {
        this.infusion.stop();
        this.timer.stop();
        Current.environment.actions.drink(this.namelabel.getText(), this.infusion);
        this.infusion.empty = true;
    }

    void continuous_check_actionPerformed(ActionEvent e) {
        this.infusion.autoRefill = this.continuous_check.isSelected();
    }
}

