/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import phic.Current;
import phic.Resource;
import phic.common.Clock;
import phic.common.Organ;
import phic.common.Quantity;
import phic.common.VDouble;
import phic.drug.Drug;
import phic.gui.CreateGraphTarget;
import phic.gui.CustomRescaleDialog;
import phic.gui.Node;
import phic.gui.OldNodeView;
import phic.gui.ThinNodeView;
import phic.gui.VDoubleNode;
import phic.gui.Variables;
import phic.gui.VisibleVariable;

public class HorzScrollGraph
extends JPanel
implements Runnable,
CreateGraphTarget {
    int defaultTimerInterval = 50;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel controlpane = new JPanel();
    TScalePane tscalepane = new TScalePane();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    public MainPane mainpane = new MainPane();
    BorderLayout borderLayout3 = new BorderLayout();
    public JPopupMenu popupmenu = new JPopupMenu();
    JPanel yscalepane = new JPanel();
    GridLayout yscalelayout = new GridLayout();
    Border border1;
    JPanel scalespacer = new JPanel();
    JMenuItem jMenuItem1 = new JMenuItem();
    Border border2;
    ImageIcon closeIcon = new ImageIcon(Resource.loader.getImageResource("SmallCross.gif"));
    Thread thread = new Thread((Runnable)this, "ScrollGraph");
    boolean running = true;
    int timer = 60;
    int scrollRate = 4;
    protected boolean enableHistory = true;
    public boolean enableWholeSessionHistory = false;
    Object waiter = new Object();
    public Clock clock;
    Vector vars = new Vector();
    int lastTimeAllRescaled = 0;
    boolean doPaintRescaling = true;
    Vector markQueue = new Vector();
    int[] markLineTimeOuts = new int[10];
    static int serial = 0;
    int xHair = 0;
    boolean drawXHair = false;
    double[] speeds = new double[]{0.1, 0.25, 1.0, 4.0, 10.0};
    public boolean flashIfOutOfRange = true;

    public HorzScrollGraph() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.thread.start();
        int i = 0;
        while (i < this.speeds.length) {
            JMenuItem m = new JMenuItem(new PopupAction(this.speeds[i]));
            this.popupmenu.add(m);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (this.running) {
                Object object;
                this.clock = Current.body.getClock();
                if (this.vars.size() == 0) {
                    object = this;
                    synchronized (object) {
                        if (this.vars.size() == 0) {
                            this.wait();
                        }
                    }
                }
                if (this.clock.running) {
                    this.mainpane.tick();
                }
                object = this.waiter;
                synchronized (object) {
                    this.waiter.wait(this.timer);
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.running) {
            throw new RuntimeException("Terminating");
        }
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(15, 0, 15, 0);
        this.border2 = BorderFactory.createEmptyBorder(15, 0, 15, 0);
        this.setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.borderLayout2);
        this.mainpane.setBackground(Color.black);
        this.mainpane.setForeground(Color.white);
        this.controlpane.setLayout(this.borderLayout3);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                HorzScrollGraph.this.rescaleAll();
            }
        });
        this.jMenuItem1.setBackground(SystemColor.activeCaption);
        this.jMenuItem1.setFont(new Font("Dialog", 1, 12));
        this.jMenuItem1.setForeground(SystemColor.activeCaptionText);
        this.jMenuItem1.setText("Timebase");
        this.yscalepane.setLayout(this.yscalelayout);
        this.yscalelayout.setColumns(1);
        this.yscalelayout.setRows(0);
        this.yscalepane.setBorder(this.border1);
        this.add((Component)this.controlpane, "East");
        this.controlpane.add((Component)this.yscalepane, "West");
        this.controlpane.add((Component)this.scalespacer, "North");
        this.jPanel1.add((Component)this.tscalepane, "North");
        this.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.mainpane, "Center");
        this.popupmenu.add(this.jMenuItem1);
        this.popupmenu.addSeparator();
        this.mainpane.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    HorzScrollGraph.this.popupmenu.show(HorzScrollGraph.this.mainpane, e.getX(), e.getY());
                }
            }
        });
        this.tscalepane.setPreferredSize(new Dimension(8, 10));
        this.scalespacer.setPreferredSize(new Dimension(0, 10));
    }

    public void addNewVariable(VisibleVariable v) {
        DisplayVariable dv = new DisplayVariable(v);
        this.addingNewVariable(dv);
    }

    public void addNewVariable(VDouble v, String name) {
        DisplayVariable dv = new DisplayVariable(v, name);
        this.addingNewVariable(dv);
    }

    public void addNewVariable(Node n) {
        DisplayVariable dv = new DisplayVariable(n);
        this.addingNewVariable(dv);
    }

    private synchronized void addingNewVariable(DisplayVariable vv) {
        vv.yscale = new YScalePane();
        vv.yscale.setBorder(BorderFactory.createLineBorder(vv.colour, 2));
        vv.yscale.variable = vv;
        vv.yscale.updatemenu();
        this.vars.add(vv);
        int height = this.rowHeight();
        this.yscalepane.add(vv.yscale);
        this.rescaleAll();
        this.notifyAll();
    }

    int rowHeight() {
        if (this.vars.size() == 0) {
            return 0;
        }
        return (this.getHeight() - 20) / this.vars.size();
    }

    public void remove(VisibleVariable v) {
        this.removeVariable(v);
    }

    public void remove(VDouble v) {
        this.removeVariable(v);
    }

    private synchronized void removeVariable(Object o) {
        Vector<DisplayVariable> removal = new Vector<DisplayVariable>();
        int i = 0;
        while (i < this.vars.size()) {
            DisplayVariable vv = (DisplayVariable)this.vars.get(i);
            if (vv.vv == o || vv.vd == o) {
                this.yscalepane.remove(vv.yscale);
                removal.add(vv);
            }
            ++i;
        }
        this.vars.removeAll(removal);
        this.yscalelayout.setRows(this.vars.size());
        this.yscalepane.doLayout();
        this.validateTree();
    }

    void remove(DisplayVariable v) {
        this.yscalepane.remove(v.yscale);
        this.vars.remove(v);
        this.rescaleAll();
    }

    public void removeAllGraphs() {
        while (this.vars.size() > 0) {
            this.remove((DisplayVariable)this.vars.get(0));
        }
    }

    void rescaleAll() {
        DisplayVariable a;
        int n = this.vars.size();
        int height = this.rowHeight();
        int i = 0;
        while (i < n) {
            a = (DisplayVariable)this.vars.get(i);
            a.yscale.setPreferredSize(new Dimension(30, 0));
            ++i;
        }
        this.yscalelayout.setRows(n);
        this.yscalepane.doLayout();
        this.validateTree();
        if (this.mainpane.switchPoint - this.lastTimeAllRescaled < 10) {
            this.doPaintRescaling = false;
        }
        i = 0;
        while (i < n) {
            a = (DisplayVariable)this.vars.get(i);
            a.rescaleRange();
            ++i;
        }
        this.doPaintRescaling = true;
        this.lastTimeAllRescaled = this.mainpane.switchPoint;
        this.repaint();
    }

    public Color getColor(Node node) {
        int i = 0;
        while (i < this.vars.size()) {
            DisplayVariable dv = (DisplayVariable)this.vars.get(i);
            if (dv.node == node || node instanceof VDoubleNode && ((VDoubleNode)node).getVDouble() == dv.vd) {
                return dv.colour;
            }
            ++i;
        }
        throw new IllegalArgumentException("Node " + node.canonicalName() + " does not have a graph");
    }

    public void reset() {
        if (!this.enableWholeSessionHistory) {
            this.mainpane.previousImages.removeAllElements();
        }
        this.markQueue.removeAllElements();
    }

    public void mark(Object event) {
        if (this.mainpane.drawArrow) {
            this.markQueue.add(event);
        } else {
            this.mainpane.drawArrow = true;
            this.mainpane.drawObject = event;
        }
    }

    void drawTick(Graphics g, Component c, int pos, boolean Xaxis, boolean major, int thickness) {
        int a = 0;
        while (a < 2) {
            if (a == 0) {
                g.setColor(SystemColor.controlShadow);
            } else {
                g.setColor(SystemColor.controlLtHighlight);
            }
            if (Xaxis) {
                int yh = thickness;
                int ym = c.getHeight();
                if (major) {
                    g.drawLine(pos + a, yh, pos + a, ym);
                } else {
                    g.drawLine(pos + a, yh + (ym - yh) / 2, pos + a, ym);
                }
            } else {
                int xw = thickness;
                if (major) {
                    g.drawLine(0, pos + a, xw, pos + a);
                } else {
                    g.drawLine(0, pos + a, xw / 2, pos + a);
                }
            }
            ++a;
        }
    }

    public void setTSpeed(double speed) {
        if (speed >= 1.0) {
            this.scrollRate = (int)speed;
            this.timer = this.defaultTimerInterval;
        } else {
            this.scrollRate = 1;
            this.timer = (int)((double)this.defaultTimerInterval / speed);
        }
    }

    public void replaceVariables() {
        int i = 0;
        while (i < this.vars.size()) {
            DisplayVariable v = (DisplayVariable)this.vars.get(i);
            if (v.vv != null) {
                v.vv = Variables.forName(v.vv.canonicalName);
                v.node = v.vv.node;
            } else {
                v.node = Node.findNodeByName(v.node.canonicalName());
            }
            ++i;
        }
    }

    public void removeAnyDrugQuantities() {
        int i = 0;
        while (i < this.vars.size()) {
            DisplayVariable v = (DisplayVariable)this.vars.get(i);
            if (v != null) {
                if (v.vv == null && v.vd instanceof Drug) {
                    this.remove(v);
                    --i;
                }
                if (this.isVisible()) {
                    this.validate();
                }
            }
            ++i;
        }
    }

    public boolean getEnableHistory() {
        return this.enableHistory;
    }

    public void setEnableHistory(boolean enableHistory) {
        this.enableHistory = enableHistory;
        if (!enableHistory) {
            this.mainpane.previousImages.removeAllElements();
        }
    }

    public ThinNodeView getThinNodeView(VisibleVariable vv) {
        int i = 0;
        if (i < this.vars.size()) {
            DisplayVariable dv = (DisplayVariable)this.vars.get(i);
            VisibleVariable cfr_ignored_0 = dv.vv;
            return dv.thinNodeView;
        }
        throw new IllegalArgumentException(vv + " is not graphed");
    }

    public DisplayVariable getDisplayVariable(VisibleVariable vv) throws IllegalArgumentException {
        int i = 0;
        while (i < this.vars.size()) {
            DisplayVariable dv = (DisplayVariable)this.vars.get(i);
            if (dv.vv == vv) {
                return dv;
            }
            ++i;
        }
        throw new IllegalArgumentException(vv + " is not graphed");
    }

    public void setThinNodeView(VisibleVariable vv, ThinNodeView thinNodeView) {
        int i = 0;
        while (i < this.vars.size()) {
            DisplayVariable dv = (DisplayVariable)this.vars.get(i);
            if (dv.vv == vv) {
                dv.thinNodeView = thinNodeView;
                return;
            }
            ++i;
        }
        throw new IllegalArgumentException(vv + " is not graphed");
    }

    public void zoomAllGraphs(boolean zoomState) {
        int i = 0;
        while (i < this.vars.size()) {
            DisplayVariable v = (DisplayVariable)this.vars.get(i);
            if (v.zoomed != zoomState) {
                v.zoomed = zoomState;
                v.rescaleRange();
            }
            ++i;
        }
        this.yscalepane.repaint();
    }

    public void setTimer(int i) {
        this.timer = i;
    }

    public int getTimer() {
        return this.timer;
    }

    class CloseAction
    extends AbstractAction {
        DisplayVariable v;

        CloseAction(DisplayVariable v) {
            super("Close graph of " + v.getLongName());
            this.v = v;
        }

        public void actionPerformed(ActionEvent e) {
            HorzScrollGraph.this.remove(this.v);
        }
    }

    public final class DisplayVariable {
        protected String friendlyName = "";
        protected Node node;
        VisibleVariable vv;
        VDouble vd;
        protected String _longname;
        int lastPosition;
        public double origin;
        public double scale;
        public double maximum;
        public double minimum;
        Color colour;
        YScalePane yscale;
        JPanel controls;
        JLabel field;
        public boolean isOutOfRange = false;
        double currentValue;
        boolean zoomed = true;
        public boolean customScaled = false;
        double[] decades = new double[]{0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
        double[] triads = new double[]{0.1, 0.2, 0.5, 1.0};
        Color[] colours = new Color[]{Color.red, Color.yellow, Color.pink, Color.green, Color.magenta, Color.orange, new Color(128, 255, 128), new Color(0, 128, 255), new Color(128, 255, 255)};
        ThinNodeView thinNodeView;

        DisplayVariable(VDouble vd, String longName) {
            this.vd = vd;
            this._longname = longName;
            this.init();
        }

        DisplayVariable(Node n) {
            this.node = n;
            this._longname = n.canonicalName();
            this.init();
        }

        DisplayVariable(VisibleVariable vv) {
            this.vv = vv;
            this.node = vv.node;
            this.init();
        }

        void init() {
            this.colour = this.colours[serial++ % this.colours.length];
            if (this.vv != null) {
                this.friendlyName = Resource.identifierToText(this.vv.longName);
                this.zoomed = this.vv.maximum / this.vv.minimum > 31.0;
            } else {
                this.friendlyName = Resource.identifierToText(this._longname);
            }
        }

        int getCurrentPosition() {
            this.lastPosition = -((int)((this.currentValue - this.origin) * this.scale)) + this.yscale.getY() + this.yscale.getHeight();
            return this.lastPosition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        double getCurrentValue() {
            Organ.DataLock dataLock = Organ.cycleLock;
            synchronized (dataLock) {
                if (this.node != null) {
                    return this.node.doubleGetVal();
                }
                return this.vd.get();
            }
        }

        public void updateValue() {
            this.currentValue = this.getCurrentValue();
        }

        protected double getCurrentMinimum() {
            return Math.min(this.getMinimum(), this.currentValue);
        }

        protected double getCurrentMaximum() {
            return Math.max(this.getMaximum(), this.currentValue);
        }

        double getInitial() {
            if (this.vv != null) {
                return this.vv.initial;
            }
            if (this.vd != null) {
                return this.vd.initialValue;
            }
            return 0.0;
        }

        double getMaximum() {
            if (this.vv != null) {
                return this.vv.maximum;
            }
            if (this.vd != null) {
                return this.vd.maximum;
            }
            return 1.0;
        }

        double getMinimum() {
            if (this.vv != null) {
                return this.vv.minimum;
            }
            if (this.vd != null) {
                return this.vd.minimum;
            }
            return 0.0;
        }

        String getLongName() {
            return this.friendlyName;
        }

        String formatValue(double value, boolean showUnit, boolean fixed) {
            if (this.vv != null) {
                return this.vv.formatValue(value, showUnit, fixed);
            }
            if (this.vd != null) {
                return this.vd.formatValue(value, showUnit, fixed);
            }
            return Quantity.toString(value);
        }

        void rescaleRange() {
            this.updateValue();
            double current = this.currentValue;
            if (this.customScaled) {
                this.rescalePanel();
                return;
            }
            if (this.zoomed) {
                this.minimum = Math.min(this.currentValue, Math.min(0.0, this.getMinimum()));
                this.maximum = Math.max(current, this.getMaximum());
                double maxdecade = Math.pow(10.0, 1 + (int)Math.floor(Math.log(this.maximum) / Math.log(10.0)));
                int i = this.findFirstIndexAbove(this.maximum / maxdecade, this.triads);
                this.maximum = maxdecade * this.triads[i];
                if (this.minimum < 0.0) {
                    double mindecade = Math.pow(10.0, 1 + (int)Math.floor(Math.log(Math.abs(this.minimum)) / Math.log(10.0)));
                    i = this.findFirstIndexAbove(this.minimum / mindecade, this.triads);
                    this.minimum = -mindecade * this.triads[i];
                }
            } else {
                int i;
                boolean negative = current < 0.0;
                double decade = Math.pow(10.0, 1 + (int)Math.floor(Math.log(current = Math.abs(current)) / Math.log(10.0)));
                if (decade == 0.0) {
                    decade = 1.0;
                }
                if ((i = this.findFirstIndexAbove(current / decade, this.decades)) == 0) {
                    this.minimum = this.decades[i] * decade;
                    this.maximum = this.decades[i + 1] * decade;
                } else {
                    this.minimum = this.decades[i - 1] * decade;
                    this.maximum = this.decades[i] * decade;
                }
                if (negative) {
                    double tmp = this.minimum;
                    this.minimum = -this.maximum;
                    this.maximum = -tmp;
                }
            }
            if (this.maximum == this.minimum) {
                this.maximum = this.vv != null ? this.minimum + this.vv.initial : this.minimum + 1.0;
                System.out.println("Scaling of " + this.node + " failed");
            }
            this.origin = this.minimum;
            this.rescalePanel();
        }

        public void rescalePanel() {
            this.yscale.setToolTipText("<HTML><B>" + this.getLongName() + "</B>: " + "Scale " + this.formatValue(this.minimum, true, false) + " - " + this.formatValue(this.maximum, true, false) + "<BR>Right-click for options, double click autoscale" + "</HTML>");
            this.scale = (double)this.yscale.getHeight() / (this.maximum - this.origin);
            if (HorzScrollGraph.this.doPaintRescaling) {
                HorzScrollGraph.this.mainpane.paintRescalingInformation(this);
            }
            this.yscale.repaint();
        }

        int findFirstIndexAbove(double value, double[] list) {
            int i = 0;
            while (i < list.length) {
                if (list[i] >= value) {
                    return i;
                }
                ++i;
            }
            return list.length - 1;
        }
    }

    class MainPane
    extends JPanel {
        BufferedImage i1;
        BufferedImage i2;
        BufferedImage lower;
        BufferedImage upper;
        Vector previousImages = new Vector();
        int switchPoint = 0;
        int scrollPoint = 0;
        boolean allowDrawOnGraph = true;
        int smoothScrollRate = 0;
        double smoothScrollVel = 0.0;
        Timer smoothScroller = new Timer(50, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainPane.this.scrollPoint = Math.min(Math.max(MainPane.this.scrollPoint - (int)MainPane.this.smoothScrollVel, 0), MainPane.this.previousImages.size() * MainPane.this.getWidth());
                MainPane.this.smoothScrollVel += (double)MainPane.this.smoothScrollRate;
                MainPane.this.smoothScrollVel *= 0.5;
                MainPane.this.smoothScrollRate /= 2;
                MainPane.this.repaint();
                if (MainPane.this.smoothScrollVel == 0.0) {
                    MainPane.this.smoothScroller.stop();
                }
            }
        });
        MouseInputAdapter drawAdapter = new GraphMouseAdapter();
        public boolean overlayGraphVariables = true;
        public int overlayFontSize = 10;
        boolean isMajorTick;
        boolean isMinorTick;
        boolean isMinuteTick;
        long prevTimeMins;
        long prevTimeHours;
        long prevTimeDays;
        boolean drawArrow;
        Object drawObject;
        public boolean antiAlias = true;
        public int thickness = 0;
        public boolean DONT_DRAW_IF_NO_CALCULATION = false;
        boolean canFitWholeDateIn = true;
        int cycleLockID = Organ.cycleLock.createID();
        static final int MAX_SCROLL_HISTORY = 25;
        int hourlyDisplay = 6;
        int minutelyDisplay = 0;
        private BufferedImage future = null;

        MainPane() {
            this.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    MainPane.this.createImages();
                }
            });
            this.addMouseListener(this.drawAdapter);
            this.addMouseMotionListener(this.drawAdapter);
            this.addMouseWheelListener(this.drawAdapter);
            this.setDoubleBuffered(false);
        }

        void createImages() {
            int w = this.getWidth();
            int h = this.getHeight();
            if (w > 0 && h > 0) {
                this.i1 = this.createNewImage(w, h);
                this.i2 = this.createNewImage(w, h);
                if (this.upper != null && this.upper.getWidth() == w) {
                    this.i1.getGraphics().drawImage(this.upper, 0, 0, null);
                }
                this.lower = this.i2;
                this.upper = this.i1;
                this.future = null;
            }
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (this.upper != null) {
                g.drawImage(this.upper, this.scrollPoint - this.switchPoint + this.upper.getWidth(), 0, this);
            }
            if (this.lower != null) {
                g.drawImage(this.lower, this.scrollPoint - this.switchPoint, 0, this);
            }
            int n = this.previousImages.size();
            int cum_t = 0;
            if (HorzScrollGraph.this.enableHistory && this.scrollPoint > 0) {
                int i = n - 1;
                while (i >= 0) {
                    BufferedImage prev = (BufferedImage)this.previousImages.get(i);
                    if (prev != null) {
                        g.drawImage(prev, this.scrollPoint - this.switchPoint - (cum_t += prev.getWidth()), 0, this);
                    }
                    --i;
                }
            }
            this.paintOverlayComponents(g);
        }

        public void paintOverlayComponents(Graphics g) {
            if (HorzScrollGraph.this.drawXHair) {
                g.setColor(Color.white);
                g.drawLine(HorzScrollGraph.this.xHair, 0, HorzScrollGraph.this.xHair, this.getHeight());
            }
            if (this.overlayGraphVariables) {
                int i = 0;
                while (i < HorzScrollGraph.this.vars.size()) {
                    DisplayVariable v = (DisplayVariable)HorzScrollGraph.this.vars.get(i);
                    g.setColor(v.colour);
                    g.setFont(new Font("Dialog", 1, this.overlayFontSize));
                    int y = v.yscale.getY();
                    g.drawString(v.getLongName(), 10, y + this.overlayFontSize + 2);
                    double val = v.currentValue;
                    String s = v.formatValue(val, true, true);
                    g.drawString(s, 10, y + this.overlayFontSize * 2 + 4);
                    ++i;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void tick() {
            if (this.lower == null) {
                return;
            }
            Organ.DataLock dataLock = Organ.cycleLock;
            synchronized (dataLock) {
                if (this.DONT_DRAW_IF_NO_CALCULATION && !Organ.cycleLock.isDirty(this.cycleLockID)) {
                    return;
                }
                int i = 0;
                while (i < HorzScrollGraph.this.vars.size()) {
                    ((DisplayVariable)HorzScrollGraph.this.vars.get(i)).updateValue();
                    ++i;
                }
                Organ.cycleLock.clean(this.cycleLockID);
            }
            this.scrollPoint = 0;
            int i = 0;
            while (i < HorzScrollGraph.this.markLineTimeOuts.length) {
                if (HorzScrollGraph.this.markLineTimeOuts[i] > 0) {
                    int n = i;
                    HorzScrollGraph.this.markLineTimeOuts[n] = HorzScrollGraph.this.markLineTimeOuts[n] - HorzScrollGraph.this.scrollRate;
                }
                ++i;
            }
            this.advanceImages();
            double pixrate = (double)HorzScrollGraph.this.scrollRate / (double)HorzScrollGraph.this.timer * HorzScrollGraph.this.clock.getSecond();
            int n = pixrate > 0.5 ? 1 : (pixrate > 0.2 ? 5 : (this.minutelyDisplay = pixrate > 0.04 ? 30 : 0));
            this.hourlyDisplay = pixrate > 0.01 ? 1 : (pixrate > 0.002 ? 6 : 24);
            this.canFitWholeDateIn = pixrate > 0.002;
            long timeMins = HorzScrollGraph.this.clock.getTime() / 60000L;
            long timeHours = timeMins / 60L;
            long timeDays = timeHours / 24L;
            this.isMajorTick = this.prevTimeDays != timeDays;
            boolean bl = this.isMinorTick = this.prevTimeHours != timeHours;
            if (this.minutelyDisplay > 0) {
                this.isMinuteTick = this.prevTimeMins / (long)this.minutelyDisplay != timeMins / (long)this.minutelyDisplay;
            }
            this.prevTimeDays = timeDays;
            this.prevTimeHours = timeHours;
            this.prevTimeMins = timeMins;
            if (this.drawArrow) {
                Graphics g = this.upper.getGraphics();
                g.setColor(Color.white);
                int w = this.switchPoint;
                int markHeight = 0;
                while (HorzScrollGraph.this.markLineTimeOuts[markHeight] > 0 && markHeight < HorzScrollGraph.this.markLineTimeOuts.length - 1) {
                    ++markHeight;
                }
                int dist = 8 + markHeight * 10;
                g.drawLine(w, this.getHeight() - dist, w, this.getHeight());
                String s = this.drawObject.toString();
                int width = this.drawStringCenteredOn(g, w, this.getHeight() - dist - 8, s, false);
                if (HorzScrollGraph.this.markQueue.isEmpty()) {
                    this.drawArrow = false;
                } else {
                    this.drawObject = HorzScrollGraph.this.markQueue.get(0);
                    HorzScrollGraph.this.markQueue.remove(0);
                }
                HorzScrollGraph.this.markLineTimeOuts[markHeight] = width + 4;
            }
            int i2 = 0;
            while (i2 < HorzScrollGraph.this.vars.size()) {
                DisplayVariable v = (DisplayVariable)HorzScrollGraph.this.vars.get(i2);
                this.doGrid(v);
                ++i2;
            }
            i2 = 0;
            while (i2 < HorzScrollGraph.this.vars.size()) {
                DisplayVariable v = (DisplayVariable)HorzScrollGraph.this.vars.get(i2);
                Graphics g = this.upper.getGraphics();
                if (this.antiAlias) {
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                if (this.thickness > 0) {
                    ((Graphics2D)g).setStroke(new BasicStroke(this.thickness));
                }
                g.setColor(v.colour);
                int lastpos = v.lastPosition;
                int pos = v.getCurrentPosition();
                int w = this.getWidth();
                pos = Math.max(0, Math.min(pos, this.getHeight() - 1));
                g.drawLine(this.switchPoint, lastpos, this.switchPoint + HorzScrollGraph.this.scrollRate, pos);
                if (this.switchPoint + HorzScrollGraph.this.scrollRate > w) {
                    Graphics g2 = this.getFutureCanvas().getGraphics();
                    if (this.antiAlias) {
                        ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    }
                    if (this.thickness > 0) {
                        ((Graphics2D)g).setStroke(new BasicStroke(this.thickness));
                    }
                    g2.setColor(v.colour);
                    g2.drawLine(this.switchPoint - w, lastpos, this.switchPoint + HorzScrollGraph.this.scrollRate - w, pos);
                }
                ++i2;
            }
            this.repaint();
        }

        private int drawStringCenteredOn(Graphics g, int x, int y, String s, boolean centreX) {
            Graphics g2;
            Rectangle2D rr = g.getFont().getStringBounds(s, ((Graphics2D)g).getFontRenderContext());
            int txtx = x - (centreX ? (int)rr.getWidth() / 2 : 0);
            int txty = y + (int)rr.getHeight() / 2;
            g.drawString(s, txtx, txty);
            if ((double)txtx + rr.getWidth() > (double)this.getWidth()) {
                g2 = this.getFutureCanvas().getGraphics();
                g2.setColor(g.getColor());
                g2.drawString(s, txtx - this.getWidth(), txty);
            }
            if (txtx < 0) {
                g2 = this.lower.getGraphics();
                g2.setColor(g.getColor());
                g2.drawString(s, txtx + this.getWidth(), txty);
            }
            return (int)rr.getWidth();
        }

        final void doGrid(DisplayVariable v) {
            Graphics g = this.upper.getGraphics();
            g.setColor(Color.gray);
            int gh = v.yscale.minorSpacing;
            int gw = HorzScrollGraph.this.tscalepane.minorSpacing;
            int w = this.switchPoint;
            if (this.isMajorTick) {
                g.drawLine(w, v.yscale.getY(), w, v.yscale.getY() + v.yscale.getHeight());
                String datetxt = this.canFitWholeDateIn ? HorzScrollGraph.this.clock.getTimeString(1) : HorzScrollGraph.this.clock.getTimeString(4);
                this.drawStringCenteredOn(g, w, 19, datetxt, false);
            } else if (this.isMinorTick && gh > 0) {
                int y = 0;
                while (y < v.yscale.getHeight()) {
                    g.drawLine(w, v.yscale.getY() + y, w, v.yscale.getY() + y);
                    y += gh;
                }
                if (this.prevTimeHours % (long)this.hourlyDisplay == 0L) {
                    this.drawStringCenteredOn(g, w, 7, String.valueOf(String.valueOf(this.prevTimeHours % 24L)) + "h", true);
                }
            } else if (this.minutelyDisplay > 0 && this.isMinuteTick) {
                this.drawStringCenteredOn(g, w, 7, String.valueOf(String.valueOf((long)this.minutelyDisplay * (this.prevTimeMins % 60L / (long)this.minutelyDisplay))) + "m", true);
            } else {
                int y = v.yscale.getY();
                g.drawLine(w, y, w, y);
                g.drawLine(w, y += v.yscale.getHeight(), w, y);
            }
        }

        final void advanceImages() {
            this.switchPoint += HorzScrollGraph.this.scrollRate;
            if (this.switchPoint > this.getWidth()) {
                this.switchPoint -= this.getWidth();
                BufferedImage t = this.lower;
                this.lower = this.upper;
                this.upper = t;
                if (HorzScrollGraph.this.enableHistory) {
                    this.previousImages.add(this.upper);
                    this.upper = this.getFutureCanvas();
                    if (this.previousImages.size() > 25) {
                        this.previousImages.remove(0);
                    }
                } else {
                    Graphics g = this.upper.getGraphics();
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, this.upper.getWidth(), this.upper.getHeight());
                }
            }
        }

        protected BufferedImage getFutureCanvas() {
            if (!HorzScrollGraph.this.enableHistory) {
                return this.lower;
            }
            if (this.future == this.upper || this.future == null) {
                this.future = this.createNewImage(this.getWidth(), this.getHeight());
            }
            return this.future;
        }

        BufferedImage createNewImage(int x, int y) {
            return new BufferedImage(x, y, 13);
        }

        void markFullXLine(int x) {
            BufferedImage b = null;
            int xp = x + this.switchPoint - this.scrollPoint;
            if (xp > this.getWidth()) {
                b = this.upper;
                xp -= this.getWidth();
            } else if (xp >= 0) {
                b = this.lower;
            } else {
                int i = this.previousImages.size();
                while (xp < 0) {
                    xp += this.getWidth();
                    b = (BufferedImage)this.previousImages.get(--i);
                }
            }
            if (b == null) {
                throw new RuntimeException("Could not find correct scrollgraph image");
            }
            Graphics g = b.getGraphics();
            g.setColor(Color.white);
            g.drawLine(xp, 0, xp, this.getHeight());
        }

        protected void paintRescalingInformation(DisplayVariable dv) {
            if (this.upper == null) {
                return;
            }
            int y0 = dv.yscale.getY();
            int y1 = y0 + dv.yscale.getHeight();
            int xp = this.switchPoint;
            String top = dv.formatValue(dv.maximum, false, false);
            String bottom = dv.formatValue(dv.minimum, false, false);
            Graphics g = this.upper.getGraphics();
            g.setColor(Color.lightGray);
            g.drawLine(xp, y1, xp, y0);
            this.drawStringCenteredOn(g, xp + 2, y0 + 4, top, false);
            this.drawStringCenteredOn(g, xp + 2, y1 - 8, bottom, false);
        }

        class GraphMouseAdapter
        extends MouseInputAdapter
        implements MouseWheelListener {
            Point o;
            int oSw;
            BufferedImage oupper;
            boolean dragging;

            GraphMouseAdapter() {
                this.oupper = MainPane.this.upper;
                this.dragging = false;
            }

            public void mouseWheelMoved(MouseWheelEvent e) {
                if (((MainPane)MainPane.this).HorzScrollGraph.this.enableHistory) {
                    MainPane.this.smoothScrollRate += e.getWheelRotation() * 45;
                    MainPane.this.smoothScroller.start();
                    MainPane.this.repaint();
                }
            }

            public void mouseDragged(MouseEvent e) {
                this.dragging = true;
                if (((MainPane)MainPane.this).HorzScrollGraph.this.enableHistory && ((e.getModifiersEx() & 0x800) > 0 || (e.getModifiersEx() & 0x80) > 0)) {
                    this.scrollDrag(e);
                    return;
                }
                if (MainPane.this.scrollPoint > 0) {
                    return;
                }
                boolean flip = MainPane.this.i1 == MainPane.this.upper;
                Point p = e.getPoint();
                if (this.o != null && MainPane.this.upper == this.oupper && MainPane.this.allowDrawOnGraph) {
                    Graphics g = MainPane.this.upper.getGraphics();
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setColor(Color.white);
                    g.drawLine(this.o.x + this.oSw - MainPane.this.getWidth(), this.o.y, p.x + MainPane.this.switchPoint - MainPane.this.getWidth(), p.y);
                    g = MainPane.this.lower.getGraphics();
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setColor(Color.white);
                    g.drawLine(this.o.x + this.oSw, this.o.y, p.x + MainPane.this.switchPoint, p.y);
                    MainPane.this.repaint();
                }
                this.o = p;
                this.oSw = MainPane.this.switchPoint;
                this.oupper = MainPane.this.upper;
            }

            void scrollDrag(MouseEvent e) {
                Point p = e.getPoint();
                int dx = p.x - this.o.x;
                int dy = p.y - this.o.y;
                MainPane.this.scrollPoint = Math.min(Math.max(MainPane.this.scrollPoint + dx, 0), MainPane.this.previousImages.size() * MainPane.this.getWidth());
                this.o = p;
                MainPane.this.repaint();
            }

            public void mouseReleased(MouseEvent e) {
                if (this.dragging) {
                    this.dragging = false;
                    e.consume();
                }
            }

            public void mousePressed(MouseEvent e) {
                this.o = e.getPoint();
                this.oSw = MainPane.this.switchPoint;
            }
        }
    }

    class PopupAction
    extends AbstractAction {
        double speed;

        PopupAction(double speed) {
            super(String.valueOf(speed));
            this.speed = speed;
        }

        public void actionPerformed(ActionEvent e) {
            HorzScrollGraph.this.setTSpeed(this.speed);
        }
    }

    class StopFlashTimer
    extends Timer {
        StopFlashTimer(int time, final DisplayVariable variable) {
            super(time, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    variable.field.setBackground(Color.black);
                }
            });
            this.setRepeats(false);
        }
    }

    class TScalePane
    extends JPanel {
        int majorPerMinor = 5;
        int minorSpacing = 30;

        TScalePane() {
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseMoved(MouseEvent e) {
                    ((TScalePane)TScalePane.this).HorzScrollGraph.this.xHair = e.getX();
                    ((TScalePane)TScalePane.this).HorzScrollGraph.this.drawXHair = true;
                    ((TScalePane)TScalePane.this).HorzScrollGraph.this.mainpane.repaint();
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mouseExited(MouseEvent e) {
                    ((TScalePane)TScalePane.this).HorzScrollGraph.this.drawXHair = false;
                    ((TScalePane)TScalePane.this).HorzScrollGraph.this.mainpane.repaint();
                }

                public void mouseClicked(MouseEvent e) {
                    ((TScalePane)TScalePane.this).HorzScrollGraph.this.mainpane.markFullXLine(((TScalePane)TScalePane.this).HorzScrollGraph.this.xHair);
                }
            });
        }

        public void paint(Graphics g) {
            super.paint(g);
            int xw = this.getWidth();
            int i = 0;
            int yh = 2;
            g.setColor(SystemColor.controlShadow);
            g.drawLine(this.getHeight() - 1, 0, this.getHeight() - 1, this.getWidth());
            int x = xw;
            while (x > 0) {
                HorzScrollGraph.this.drawTick(g, this, x, true, i++ % this.majorPerMinor == 0, yh);
                x -= this.minorSpacing;
            }
        }
    }

    class YScalePane
    extends JPanel {
        boolean labelInitialValue = false;
        int majorPerMinor = 5;
        int minorSpacing;
        int nMinors = 10;
        DisplayVariable variable;
        static final int fixedWidth = 30;
        final int majorDepth = 10;
        final int textDepth = 13;
        final int vTextGap = 6;
        JPopupMenu jPopupMenu1 = new JPopupMenu();
        JRadioButtonMenuItem jRadioButtonMenuItem1 = new JRadioButtonMenuItem();
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem();
        JRadioButtonMenuItem customscaleradio = new JRadioButtonMenuItem();
        Action startAtZeroAction = new AbstractAction("Start at zero"){

            public void actionPerformed(ActionEvent e) {
                if (YScalePane.this.variable.minimum != 0.0) {
                    YScalePane.this.variable.customScaled = true;
                    YScalePane.this.variable.origin = 0.0;
                    YScalePane.this.variable.minimum = 0.0;
                    YScalePane.this.variable.rescalePanel();
                }
            }
        };
        JMenuItem startAtZero = new JMenuItem(this.startAtZeroAction);
        JMenuItem closeItem;
        ButtonGroup buttonGroup1 = new ButtonGroup();

        public YScalePane() {
            this.addMouseListener(new ScaleMouseAdapter());
            this.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    YScalePane.this.variable.rescalePanel();
                }
            });
            this.jbInit();
        }

        public void paint(Graphics g) {
            super.paint(g);
            this.minorSpacing = this.getHeight() / this.nMinors;
            int xw = this.getWidth();
            int i = 0;
            int yh = this.getHeight();
            g.setColor(SystemColor.controlShadow);
            g.drawLine(0, 0, 0, this.getHeight() - 1);
            int y = 0;
            while (y < yh) {
                HorzScrollGraph.this.drawTick(g, this, y, false, i++ % this.majorPerMinor == 0, 10);
                y += this.minorSpacing;
            }
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setFont(new Font("Arial", 0, 10));
            if (this.labelInitialValue) {
                this.labelTick(g, this.variable.getInitial());
            }
            this.drawArrow(g, this.variable.getInitial(), Color.red);
            this.labelTick(g, this.variable.minimum);
            this.labelTick(g, this.variable.maximum);
        }

        int ycoord(double value) {
            int a = (int)((value - this.variable.origin) * this.variable.scale);
            a = this.getHeight() - a;
            if ((double)Math.abs(a) < 100000.0) {
                return a;
            }
            return 0;
        }

        final void labelTick(Graphics g, double value) {
            int y = this.ycoord(value);
            HorzScrollGraph.this.drawTick(g, this, y, false, true, 10);
            String label = this.variable.formatValue(value, false, false);
            if (label.endsWith(".0")) {
                label = label.substring(0, label.length() - 2);
            }
            Rectangle2D rr = this.getFont().getStringBounds(label, ((Graphics2D)g).getFontRenderContext());
            Dimension r = new Dimension((int)rr.getWidth(), (int)rr.getHeight());
            if (y + r.height / 2 > this.getHeight()) {
                y = this.getHeight() - r.height / 2 - 3;
            }
            if (y - r.height / 2 < 0) {
                y = r.height / 2 + 3;
            }
            g.setColor(Color.black);
            g.drawString(label, 13, y + r.height / 2);
        }

        final void drawArrow(Graphics g, double value, Color colour) {
            g.setColor(colour);
            int y = this.ycoord(value);
            int x = 8;
            g.fillPolygon(new int[]{x, x + 8, x + 8}, new int[]{y, y - 4, y + 4}, 3);
        }

        void jbInit() {
            this.jRadioButtonMenuItem1.setText("Scale to current value");
            this.jRadioButtonMenuItem1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    YScalePane.this.variable.zoomed = false;
                    YScalePane.this.variable.customScaled = false;
                    YScalePane.this.variable.rescaleRange();
                    YScalePane.this.repaint();
                }
            });
            this.jRadioButtonMenuItem2.setText("Scale to full range");
            this.jRadioButtonMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    YScalePane.this.variable.zoomed = true;
                    YScalePane.this.variable.customScaled = false;
                    YScalePane.this.variable.rescaleRange();
                    YScalePane.this.repaint();
                }
            });
            this.customscaleradio.setText("Custom scale...");
            this.customscaleradio.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CustomRescaleDialog crd = new CustomRescaleDialog();
                    crd.setVariable(YScalePane.this.variable);
                    YScalePane.this.variable.customScaled = true;
                    crd.show();
                }
            });
            this.jPopupMenu1.add(this.jRadioButtonMenuItem1);
            this.jPopupMenu1.add(this.jRadioButtonMenuItem2);
            this.jPopupMenu1.add(this.customscaleradio);
            this.jPopupMenu1.add(this.startAtZeroAction);
            this.buttonGroup1.add(this.jRadioButtonMenuItem1);
            this.buttonGroup1.add(this.jRadioButtonMenuItem2);
            this.buttonGroup1.add(this.customscaleradio);
            this.updatemenu();
        }

        void updatemenu() {
            if (this.variable != null) {
                this.jRadioButtonMenuItem2.setSelected(this.variable.zoomed);
                this.jRadioButtonMenuItem1.setSelected(!this.variable.zoomed);
            }
        }

        class ScaleMouseAdapter
        extends MouseAdapter
        implements MouseMotionListener {
            ScaleMouseAdapter() {
            }

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    YScalePane.this.variable.zoomed = !YScalePane.this.variable.zoomed;
                    YScalePane.this.variable.customScaled = false;
                    YScalePane.this.variable.rescaleRange();
                    YScalePane.this.updatemenu();
                    YScalePane.this.repaint();
                } else if (e.getButton() == 3) {
                    if (YScalePane.this.closeItem == null && OldNodeView.TitleBar.allowClose) {
                        YScalePane.this.closeItem = new JMenuItem(new CloseAction(YScalePane.this.variable));
                        YScalePane.this.jPopupMenu1.add(YScalePane.this.closeItem);
                    }
                    YScalePane.this.jPopupMenu1.show(YScalePane.this, e.getX(), e.getY());
                }
            }

            public void mouseEntered(MouseEvent e) {
                if (YScalePane.this.variable.thinNodeView != null) {
                    YScalePane.this.variable.thinNodeView.varnamelabel.setBorder(YScalePane.this.variable.thinNodeView.highlightBorder);
                }
            }

            public void mouseExited(MouseEvent e) {
                if (YScalePane.this.variable.thinNodeView != null) {
                    YScalePane.this.variable.thinNodeView.varnamelabel.setBorder(null);
                }
            }

            public void mouseMoved(MouseEvent e) {
            }

            public void mouseDragged(MouseEvent e) {
            }
        }
    }
}

