/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import phic.common.Organ;
import phic.common.Quantity;
import phic.common.Ticker;
import phic.gui.Node;
import phic.gui.VisibleVariable;
import phic.modifiable.Range;

public class HorizontalBar
extends JLabel
implements Ticker {
    static int BAR_UPDATE_INTERVAL = 200;
    static Thread thread;
    static Vector bars;
    static boolean running;
    double val;
    VisibleVariable variable;
    Node node;
    protected double scaleMin;
    protected double scaleMax;
    public boolean alwaysIncludeZero;
    public boolean alwaysIncludeMinimum;
    public boolean alwaysIncludeMaximum;
    public int zoom;
    protected boolean SYMMETRICAL;
    private int b;
    public boolean drawText;

    static {
        bars = new Vector();
        running = false;
    }

    public HorizontalBar() {
        HorizontalBar.ensureThreadRunning();
        this.alwaysIncludeZero = true;
        this.alwaysIncludeMinimum = true;
        this.alwaysIncludeMaximum = true;
        this.zoom = 1;
        this.SYMMETRICAL = true;
        this.b = 2;
        this.drawText = true;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setText("");
        this.setOpaque(true);
        this.setBackground(Color.black);
        this.setForeground(new Color(0, 0, 128));
        int prefHeight = 14;
        this.setPreferredSize(new Dimension(72, prefHeight));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                HorizontalBar.this.rescale();
            }
        });
    }

    public void addNotify() {
        bars.add(this);
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
        bars.remove(this);
    }

    private static void ensureThreadRunning() {
        if (!running) {
            running = true;
            thread = new Thread((Runnable)new BarThreadRunnable(), "BarUpdater");
            thread.start();
        }
    }

    public static void addBar(Ticker t) {
        bars.add(t);
        HorizontalBar.ensureThreadRunning();
    }

    public static void removeBar(Ticker t) {
        bars.remove(t);
    }

    public static void stop() {
        running = false;
    }

    public void tick(double time) {
        double newval = this.getValue();
        if (newval != this.val) {
            this.val = newval;
            this.repaint();
        }
    }

    public void setVariable(VisibleVariable v) {
        this.variable = v;
        this.node = v.node;
        this.rescale();
    }

    public void setNode(Node n) {
        this.node = n;
    }

    public VisibleVariable getVariable() {
        return this.variable;
    }

    public Node getNode() {
        return this.node;
    }

    void rescale() {
        ++this.zoom;
        this.zoom %= Range.ZOOM_RANGES.length;
        double val = this.getValue();
        double min = 0.0;
        double max = 0.0;
        if (this.variable != null) {
            if (this.alwaysIncludeMinimum) {
                min = Math.min(this.variable.minimum, val);
            }
            if (this.alwaysIncludeZero) {
                min = Math.min(min, 0.0);
            }
            if (this.alwaysIncludeMaximum) {
                max = Math.max(this.variable.maximum, val);
            }
        } else if (this.node != null) {
            min = max = val;
        }
        if (this.variable != null) {
            Range r = Range.findRange(this.variable, this.zoom);
            if (this.SYMMETRICAL) {
                r = Range.findRangeSymmetrical(this.variable, this.zoom);
            }
            this.scaleMin = r.minimum;
            this.scaleMax = r.maximum;
            this.repaint();
        }
        String ttt = null;
        ttt = this.drawText ? (this.variable != null ? "Scale " + this.variable.formatValue(this.scaleMin, true, false) + " - " + this.variable.formatValue(this.scaleMax, true, false) : "Scale " + Quantity.toString(this.scaleMin) + " - " + Quantity.toString(this.scaleMax)) : (this.variable != null ? "Value = " + this.variable.formatValue(val, true, false) + ", Scale " + this.variable.formatValue(this.scaleMin, true, false) + " - " + this.variable.formatValue(this.scaleMax, true, false) : "Value = " + Quantity.toString(val) + ", Scale " + Quantity.toString(this.scaleMin) + " - " + Quantity.toString(this.scaleMax));
        this.setToolTipText(ttt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final double getValue() {
        if (this.node != null) {
            Organ.DataLock dataLock = Organ.cycleLock;
            synchronized (dataLock) {
                return this.node.doubleGetVal();
            }
        }
        return Double.NaN;
    }

    protected Color getColour() {
        double val = this.getValue();
        if (val < this.variable.minimum) {
            return Color.yellow;
        }
        if (val <= this.variable.maximum) {
            return Color.cyan;
        }
        return Color.red;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.variable != null) {
            g.setColor(this.getForeground());
            double val = this.getValue();
            int bw = this.barWidth(val);
            if (bw > 0) {
                g.fill3DRect(this.b, this.b, bw, this.getHeight() - 2 * this.b, true);
            }
            int minx = this.barWidth(this.variable.minimum) + this.b;
            int maxx = this.barWidth(this.variable.maximum) + this.b;
            int initx = this.barWidth(this.variable.initial) + this.b;
            g.setColor(Color.yellow);
            g.drawLine(minx, 0, minx, this.getHeight());
            g.setColor(Color.red);
            g.drawLine(maxx, 0, maxx, this.getHeight());
            g.setColor(Color.orange);
            g.drawLine(initx, 0, initx, this.getHeight());
            if (this.drawText) {
                g.setColor(this.getColour());
                g.setFont(this.getFont());
                g.drawString(this.variable.formatValue(val, true, true), this.b, this.getHeight() - this.b);
            }
        }
    }

    protected int barWidth(double v) {
        double f = (v - this.scaleMin) / (this.scaleMax - this.scaleMin);
        f = Math.max(0.0, Math.min(1.0, f));
        double w = (double)(this.getWidth() - 2 * this.b) * f;
        if (w > 0.0) {
            return (int)w;
        }
        return 0;
    }

    private void jbInit() throws Exception {
        this.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    static class BarThreadRunnable
    implements Runnable {
        BarThreadRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            try {
                ** GOTO lbl27
                {
                    var1_1 = Organ.cycleLock;
                    synchronized (var1_1) {
                        i = 0;
                        while (i < HorizontalBar.bars.size()) {
                            b = (Ticker)HorizontalBar.bars.get(i);
                            b.tick((double)HorizontalBar.BAR_UPDATE_INTERVAL / 1000.0);
                            ++i;
                        }
                    }
                    try {
                        Thread.sleep(HorizontalBar.BAR_UPDATE_INTERVAL);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    do {
                        if (HorizontalBar.bars.size() > 0) continue block10;
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException x) {
                            x.printStackTrace();
                        }
lbl27:
                        // 3 sources

                    } while (HorizontalBar.running);
                }
            }
            finally {
                HorizontalBar.running = false;
            }
        }
    }
}

