/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import phic.Resource;
import phic.common.IniReader;
import phic.common.ServerCheck;
import phic.gui.PhicApplication;

public class HomLauncher
extends JFrame
implements ActionListener {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel bottompanel = new JPanel();
    JPanel buttonpanel = new JPanel();
    JButton exitb = new JButton();
    JScrollPane txtscr = new JScrollPane();
    JTextArea txt = new JTextArea();
    public static boolean reshowMenuOnClose = true;
    ActionListener reshowListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            HomLauncher.this.setVisible(true);
        }
    };
    WindowListener phicFrameListener = new WindowAdapter(){

        public void windowOpened(WindowEvent e) {
            HomLauncher.this.restoring();
        }
    };
    boolean firstTime = true;
    ServerCheck server;
    String framesetupfile = "FrameSetup.txt";
    GridLayout gridLayout1 = new GridLayout();
    JPanel cardpanel = new JPanel();
    CardLayout cardLayout1 = new CardLayout();
    JPanel loadingpanel = new JPanel();
    JTextArea loadinglabel = new JTextArea();
    BorderLayout borderLayout2 = new BorderLayout();
    Border border1;

    public HomLauncher() throws HeadlessException {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setupButtons();
        this.txtscr.getViewport().setView(this.txt);
        this.txtscr.setPreferredSize(new Dimension(100, 80));
        this.txt.setEditable(false);
        this.txt.setText("Please select a setup");
        this.txt.setLineWrap(true);
        this.txt.setWrapStyleWord(true);
        this.txt.setFont(this.getFont());
        this.bottompanel.add((Component)this.txtscr, "Center");
        this.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d.width - this.getWidth()) / 2, (d.height - this.getHeight()) / 2);
        this.setVisible(true);
        this.setIconImage(Resource.loader.getImageResource("Humanico16.gif"));
    }

    public static void main(String[] s) {
        if (s.length > 0) {
            PhicApplication.main(s);
        } else {
            new HomLauncher();
        }
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().setLayout(this.borderLayout1);
        this.exitb.setText("Exit");
        this.exitb.addActionListener(this);
        this.setTitle("HOM: demo version");
        this.buttonpanel.setLayout(this.gridLayout1);
        this.buttonpanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.gridLayout1.setColumns(1);
        this.cardpanel.setLayout(this.cardLayout1);
        this.loadinglabel.setBackground(SystemColor.control);
        this.loadinglabel.setFont(new Font("Arial", 1, 18));
        this.loadinglabel.setText("Loading HOM...");
        this.loadinglabel.setLineWrap(true);
        this.loadinglabel.setWrapStyleWord(true);
        this.loadingpanel.setLayout(this.borderLayout2);
        this.loadingpanel.setBorder(this.border1);
        this.loadinglabel.setCursor(Cursor.getPredefinedCursor(3));
        this.getContentPane().add((Component)this.bottompanel, "South");
        this.bottompanel.setLayout(new BorderLayout());
        this.bottompanel.add((Component)this.exitb, "South");
        this.getContentPane().add((Component)this.cardpanel, "Center");
        this.cardpanel.add((Component)this.buttonpanel, "SelectorPanel");
        this.loadingpanel.add((Component)this.loadinglabel, "Center");
        this.cardpanel.add((Component)this.loadingpanel, "LoadingPanel");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                HomLauncher.this.dispose();
                try {
                    System.exit(0);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void command(final ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals("Exit")) {
            this.setVisible(false);
            this.dispose();
            if (this.server != null) {
                ServerCheck serverCheck = this.server;
                synchronized (serverCheck) {
                    this.server.homrunning = false;
                    this.server.notify();
                }
            }
            try {
                System.exit(0);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        new Thread(new Runnable(){

            public void run() {
                HomLauncher.this.launch(e.getActionCommand());
            }
        }).start();
    }

    public void launch(String s) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.cardLayout1.show(this.cardpanel, "LoadingPanel");
        this.repaint();
        this.loadinglabel.setText("Loading HOM: " + Resource.identifierToText(s));
        PhicApplication.main(new String[]{"setup", s});
        PhicApplication.frame.getJFrame().addWindowListener(this.phicFrameListener);
        if (PhicApplication.frame.getJFrame().isShowing()) {
            this.restoring();
        }
        PhicApplication.frame.addCloseListener(this.reshowListener);
    }

    void restoring() {
        this.setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.cardLayout1.show(this.cardpanel, "SelectorPanel");
        if (this.firstTime) {
            this.server = new ServerCheck();
            this.firstTime = false;
        }
    }

    public void setupButtons() {
        String[] items = Resource.loader.getStringList(this.framesetupfile, "HOMLauncher");
        IniReader r = new IniReader(this.framesetupfile);
        this.gridLayout1.setRows(items.length);
        this.gridLayout1.setVgap(10);
        int i = 0;
        while (i < items.length) {
            String itemText = Resource.identifierToText(items[i]);
            JButton b = new JButton(itemText);
            b.setActionCommand(items[i]);
            b.addActionListener(this);
            try {
                String description = r.getSectionMap(items[i]).get("Description").toString();
                b.setToolTipText(description);
                b.addMouseListener(new ButtonML(String.valueOf(itemText) + ": " + description));
            }
            catch (NullPointerException e) {
                System.out.println(String.valueOf(items[i]) + " in " + this.framesetupfile + " has no description");
            }
            this.buttonpanel.add(b);
            if (i == 0) {
                this.getRootPane().setDefaultButton(b);
            }
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.command(e);
    }

    class ButtonML
    extends MouseAdapter {
        String str;

        ButtonML(String s) {
            this.str = s;
        }

        public void mouseEntered(MouseEvent e) {
            HomLauncher.this.txt.setText(this.str);
            HomLauncher.this.txt.setCaretPosition(0);
            HomLauncher.this.txt.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        }
    }
}

