/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.applet.Applet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import phic.Current;
import phic.Person;
import phic.gui.HorizontalBar;
import phic.gui.PhicApplication;
import phic.gui.PhicFrameSetup;
import phic.gui.SimplePhicFrame;

public class HomEmbeddedApplet
extends JApplet {
    private static final String physiologyFrameClass = "phic.gui.PhicFrameSetup";
    private static final String defaultFrameSetupFile = "FrameSetup.txt";
    private static final String defaultFrameSetup = "Default";
    public PhicFrameSetup frame;

    public void init() {
        super.init();
        String frameSetupFile = this.getParameter("FrameSetupFile");
        String frameSetup = this.getParameter("FrameSetup");
        ParamMap m = new ParamMap(this);
        if (frameSetupFile == null) {
            frameSetupFile = defaultFrameSetupFile;
        }
        if (frameSetup == null) {
            frameSetup = defaultFrameSetup;
        }
        try {
            Class<?> fclass = Class.forName(physiologyFrameClass);
            this.frame = (PhicFrameSetup)fclass.newInstance();
            PhicApplication.frame = this.frame;
            this.frame.doSetup(frameSetupFile, frameSetup);
            this.frame.doSetup(m);
            this.getContentPane().add(this.frame.mainFramePanel);
            this.frame.initialise();
        }
        catch (ClassNotFoundException x) {
            x.printStackTrace();
            JOptionPane.showMessageDialog(this, "Unable to find class phic.gui.PhicFrameSetup; " + x.toString());
        }
        catch (InstantiationException x) {
            x.printStackTrace();
            JOptionPane.showMessageDialog(this, "Unable to instantiate class phic.gui.PhicFrameSetup; " + x.toString());
        }
        catch (IllegalAccessException x) {
            x.printStackTrace();
            JOptionPane.showMessageDialog(this, "No access to create frame; " + x.toString());
        }
    }

    public void start() {
        super.start();
    }

    public void destroy() {
        if (this.frame != null) {
            Current.body.setRunning(false);
            HorizontalBar.running = false;
            SimplePhicFrame f = (SimplePhicFrame)((Object)PhicApplication.frame);
            f.graph.running = false;
            f.bodyTree.running = false;
            try {
                Current.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public Person getPerson() {
        return Current.person;
    }

    public static class ParamMap
    implements Map {
        Applet applet;

        public ParamMap(Applet a) {
            this.applet = a;
        }

        String getParameter(String s) {
            return this.applet.getParameter(s);
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object key) {
            return this.getParameter(key.toString()) != null;
        }

        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            throw new UnsupportedOperationException();
        }

        public Object get(Object key) {
            String s = this.getParameter(key.toString());
            if (s == null) {
                return null;
            }
            if (s.equalsIgnoreCase("Yes") || s.equalsIgnoreCase("True")) {
                return new Boolean(true);
            }
            if (s.equalsIgnoreCase("No") || s.equalsIgnoreCase("False")) {
                return new Boolean(false);
            }
            try {
                double d = Double.parseDouble(s);
                return new Double(d);
            }
            catch (NumberFormatException numberFormatException) {
                return this.getParameter(key.toString());
            }
        }

        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        public Set keySet() {
            throw new UnsupportedOperationException();
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            throw new UnsupportedOperationException();
        }

        public Collection values() {
            throw new UnsupportedOperationException();
        }
    }
}

