/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import phic.Resource;
import phic.gui.ModalDialog;
import phic.gui.PhicApplication;

public class HTMLMessagePane
extends JPanel
implements HyperlinkListener {
    protected JOptionPane op;
    protected JEditorPane ed;

    public HTMLMessagePane(String htmlResource) {
        this.setLayout(new BorderLayout());
        try {
            this.ed = new JEditorPane(Resource.loader.getResourceURL(htmlResource));
        }
        catch (IOException x) {
            this.ed = new JEditorPane("text/plain", "Error loading file " + htmlResource + "\n" + x.getMessage());
            x.printStackTrace();
        }
        JScrollPane sp = new JScrollPane(this.ed);
        this.ed.setEditable(false);
        this.ed.addHyperlinkListener(this);
        this.op = new JOptionPane(sp, 1, -1);
        this.add((Component)this.op, "Center");
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane pane = (JEditorPane)e.getSource();
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
            } else {
                try {
                    pane.setPage(e.getURL());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public static void showDialog(String htmlResource, String title) {
        final ModalDialog d = new ModalDialog();
        HTMLMessagePane mp = new HTMLMessagePane(htmlResource);
        d.getContentPane().add(mp);
        d.pack();
        Dimension d1 = PhicApplication.frame.getJFrame().getSize();
        d.setPreferredSize(new Dimension(Math.min(640, (int)d1.getWidth() - 20), Math.min(480, (int)d1.getHeight() - 40)));
        mp.op.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                d.hide();
            }
        });
        d.setTitle(title);
        d.show();
    }
}

