/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import javax.swing.JPanel;

public class GraphPaper
extends JPanel {
    protected double minx;
    protected double maxx;
    protected double majorx;
    protected double minorx;
    protected double miny;
    protected double maxy;
    protected double majory;
    protected double minory;
    double offsetx;
    double offsety;
    public boolean internalResize = false;
    boolean drawXLabels = false;
    boolean drawYLabels = false;

    public GraphPaper() {
        this.setFont(new Font("Dialog", 0, 10));
        this.setForeground(Color.green);
        this.setBackground(Color.black);
        this.miny = 0.0;
        this.minx = 0.0;
        this.maxy = 100.0;
        this.maxx = 100.0;
        this.majory = 50.0;
        this.majorx = 50.0;
        this.minory = 10.0;
        this.minorx = 10.0;
    }

    public void paint(Graphics g) {
        super.paint(g);
        double dx = this.maxx - this.minx;
        double dy = this.maxy - this.miny;
        g.setColor(this.getFracColour(0.3));
        this.drawg(g, this.minx + this.offsetx, (int)(dx / this.minorx), this.minorx, false, false);
        this.drawg(g, this.miny + this.offsety, (int)(dy / this.minory), this.minory, true, false);
        g.setColor(this.getFracColour(0.7));
        this.drawg(g, this.minx + this.offsetx, 2 + (int)(dx / this.majorx), this.majorx, false, this.drawXLabels);
        this.drawg(g, this.miny + this.offsety, 1 + (int)(dy / this.majory), this.majory, true, this.drawYLabels);
        super.paintChildren(g);
    }

    public void paintComponents(Graphics g) {
        super.paintComponent(g);
    }

    public Color getFracColour(double p) {
        Color f = this.getForeground();
        Color b = this.getBackground();
        double q = 1.0 - p;
        return new Color((int)(p * (double)f.getRed() + q * (double)b.getRed()), (int)(p * (double)f.getGreen() + q * (double)b.getGreen()), (int)(p * (double)f.getBlue() + q * (double)b.getBlue()));
    }

    public void setXRange(double minimum, double maximum) {
        this.minx = minimum;
        this.maxx = maximum;
        if (!this.internalResize) {
            double nx;
            double b = 10.0 * this.tenths(this.maxx - this.minx);
            while ((nx = (this.maxx - this.minx) / (b /= 10.0)) == 0.0) {
            }
            if ((double)this.getWidth() / nx < 50.0) {
                this.majorx = b;
                this.minorx = b / 2.0;
            } else {
                this.majorx = b;
                this.minorx = b / 5.0;
            }
            this.offsetx = (this.minx - this.majorx * (double)((int)(this.minx / this.majorx))) / 2.0;
        }
    }

    public void setYRange(double minimum, double maximum) {
        this.miny = minimum;
        this.maxy = maximum;
        if (!this.internalResize) {
            double b = this.tenths(this.maxy - this.miny);
            double ny = (this.maxy - this.miny) / b;
            if ((double)this.getHeight() / ny < 50.0) {
                this.majory = b;
                this.minory = b / 2.0;
            } else {
                this.majory = b / 2.0;
                this.minory = b / 5.0;
            }
            this.offsety = (this.miny - this.majory * (double)((int)(this.miny / this.majory))) / 2.0;
        }
    }

    public void drawLine(Graphics g, double x1, double y1, double x2, double y2) {
        g.drawLine(this.xS(x1), this.yS(y1), this.xS(x2), this.yS(y2));
    }

    public Point toScreen(Point2D p) {
        return new Point(this.xS(p.getX()), this.yS(p.getY()));
    }

    public Point2D toGraph(Point p) {
        return new Point2D.Double(this.xG(p.x), this.yG(p.y));
    }

    public void setDrawLabels(boolean d) {
        this.drawXLabels = this.drawYLabels = d;
        this.repaint();
    }

    public boolean isDrawLabels() {
        return this.drawXLabels || this.drawYLabels;
    }

    public void setDrawXLabels(boolean d) {
        this.drawXLabels = d;
        this.repaint();
    }

    public void setDrawYLabels(boolean d) {
        this.drawYLabels = d;
        this.repaint();
    }

    public boolean isDrawXLabels() {
        return this.drawXLabels;
    }

    public boolean isDrawYLabels() {
        return this.drawYLabels;
    }

    public double getMajorX() {
        return this.majorx;
    }

    public void setMajorX(double d) {
        this.majorx = d;
        this.repaint();
    }

    public double getMajorY() {
        return this.majory;
    }

    public void setMajorY(double d) {
        this.majory = d;
        this.repaint();
    }

    public void setMinorX(double d) {
        this.minorx = d;
    }

    public double getMinorX() {
        return this.minorx;
    }

    public double getMinorY() {
        return this.minory;
    }

    public void setMinorY(double minory) {
        this.minory = minory;
    }

    double tenths(double a) {
        int r = (int)Math.round(Math.log(a) / Math.log(10.0));
        return Math.pow(10.0, r - 1);
    }

    void drawg(Graphics g, double low, int n, double dist, boolean horz, boolean labels) {
        if (horz) {
            int i = 0;
            while (i < n) {
                double yg = low + dist * (double)i;
                int y = this.yS(yg);
                g.drawLine(0, y, this.getWidth(), y);
                if (labels) {
                    g.drawString(this.tostring(yg, this.majory), 0, y);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                double xg = low + dist * (double)i;
                int x = this.xS(xg);
                g.drawLine(x, 0, x, this.getHeight());
                if (labels) {
                    g.drawString(this.tostring(xg, this.majorx), x, this.getHeight() - 10);
                }
                ++i;
            }
        }
    }

    String tostring(double a, double major) {
        a = (double)((int)(100.0 * a)) / 100.0;
        String z = major > 10.0 ? String.valueOf((int)a) : String.valueOf(a);
        if (z.endsWith(".0")) {
            z = z.substring(0, z.length() - 2);
        }
        return z;
    }

    public int xS(double xG) {
        return (int)((double)this.getWidth() * (xG - this.minx) / (this.maxx - this.minx));
    }

    public int yS(double yG) {
        return (int)((double)this.getHeight() * (1.0 - (yG - this.miny) / (this.maxy - this.miny)));
    }

    public double xG(double xS) {
        return xS / (double)this.getWidth() * (this.maxx - this.minx) + this.minx;
    }

    public double yG(double yS) {
        return (1.0 - yS / (double)this.getHeight()) * (this.maxy - this.miny) + this.miny;
    }
}

