/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import phic.Current;
import phic.common.Clock;
import phic.common.EventLog;
import phic.common.UnitConstants;
import phic.gui.ModalDialog;

public class FluidBalanceDialog
extends ModalDialog {
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JButton jButton1 = new JButton();
    Box box1;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    Border border1;
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    Box box2;
    JTextField intotal = new JTextField();
    JPanel jPanel5 = new JPanel();
    BorderLayout borderLayout4 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextField outtotal = new JTextField();
    Box box3;
    Box box4;
    Box box5;
    JPanel jPanel6 = new JPanel();
    JPanel jPanel7 = new JPanel();
    JList inlist = new JList();
    JList outlist = new JList();
    BorderLayout borderLayout5 = new BorderLayout();
    BorderLayout borderLayout6 = new BorderLayout();
    private JRadioButton radioday = new JRadioButton();
    private JRadioButton radioweek = new JRadioButton();
    private ButtonGroup buttonGroup1 = new ButtonGroup();
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    public long historyLength = 86400000L;
    JPanel jPanel8 = new JPanel();
    GridLayout gridLayout1 = new GridLayout();

    public FluidBalanceDialog() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.buttonGroup1.add(this.radioday);
        this.buttonGroup1.add(this.radioweek);
        this.fillOut();
        this.setPreferredSize(new Dimension(600, 270));
        this.getRootPane().setDefaultButton(this.jButton1);
    }

    private void jbInit() throws Exception {
        this.box1 = Box.createHorizontalBox();
        this.box2 = Box.createHorizontalBox();
        this.box3 = Box.createHorizontalBox();
        this.setTitle("Fluid balance");
        this.border1 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.jButton1.setToolTipText("");
        this.jButton1.setText("OK");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FluidBalanceDialog.this.jButton1_actionPerformed(e);
            }
        });
        this.jPanel2.setLayout(this.borderLayout1);
        this.jPanel2.setBorder(this.border1);
        this.jPanel3.setLayout(this.borderLayout2);
        this.jPanel4.setLayout(this.borderLayout3);
        this.jLabel1.setFont(new Font("Dialog", 1, 12));
        this.jLabel1.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jLabel1.setPreferredSize(new Dimension(51, 21));
        this.jLabel1.setText("Fluid in");
        this.jLabel2.setFont(new Font("Dialog", 1, 12));
        this.jLabel2.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jLabel2.setText("Fluid out");
        this.intotal.setFont(new Font("SansSerif", 1, 12));
        this.intotal.setPreferredSize(new Dimension(32, 21));
        this.intotal.setText("0.0 L");
        this.intotal.setHorizontalAlignment(4);
        this.jPanel5.setLayout(this.borderLayout4);
        this.outtotal.setFont(new Font("SansSerif", 1, 12));
        this.outtotal.setPreferredSize(new Dimension(32, 21));
        this.outtotal.setText("0.0 L");
        this.outtotal.setHorizontalAlignment(4);
        this.inlist.setBackground(new Color(175, 175, 255));
        this.inlist.setBorder(BorderFactory.createLoweredBevelBorder());
        this.outlist.setBackground(Color.pink);
        this.outlist.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jPanel6.setLayout(this.borderLayout5);
        this.jPanel7.setLayout(this.borderLayout6);
        this.radioday.setText("Day");
        this.radioday.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FluidBalanceDialog.this.radioday_actionPerformed(e);
            }
        });
        this.radioday.setSelected(true);
        this.radioweek.setText("Week");
        this.radioweek.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FluidBalanceDialog.this.radioweek_actionPerformed(e);
            }
        });
        this.jPanel8.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(2);
        this.jPanel1.add((Component)this.radioweek, null);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.radioday, null);
        this.jPanel1.add((Component)this.jButton1, null);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.box1, "North");
        this.box1.add((Component)this.jPanel3, null);
        this.jPanel3.add((Component)this.jLabel1, "North");
        this.box1.add((Component)this.jPanel4, null);
        this.jPanel4.add((Component)this.jLabel2, "North");
        this.jPanel2.add((Component)this.box2, "South");
        this.box2.add((Component)this.intotal, null);
        this.box2.add((Component)this.outtotal, null);
        this.jPanel2.add((Component)this.jPanel5, "Center");
        this.jPanel5.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.jPanel8, null);
        this.jPanel8.add((Component)this.jPanel6, null);
        this.jPanel6.add((Component)this.inlist, "Center");
        this.jPanel8.add((Component)this.jPanel7, null);
        this.jPanel7.add((Component)this.outlist, "Center");
    }

    void jButton1_actionPerformed(ActionEvent e) {
        this.hide();
    }

    private void fillOut() {
        EventLog log = Current.body.eventLog;
        Clock clock = Current.body.getClock();
        Vector v = log.getEventsOfType(EventLog.FLUID_EVENT);
        Vector<String> inv = new Vector<String>();
        Vector<String> outv = new Vector<String>();
        double totalin = 0.0;
        double totalout = 0.0;
        long currentTime = clock.getTime();
        int i = 0;
        while (i < v.size()) {
            EventLog.Event e = (EventLog.Event)v.get(i);
            if (e.time >= currentTime - this.historyLength && e.type == EventLog.FLUID_EVENT) {
                double amt = Double.NaN;
                try {
                    amt = (Double)e.parameter;
                }
                catch (Exception x) {
                    System.out.println(e.parameter + " is not a double");
                    x.printStackTrace();
                }
                if (amt >= 0.0) {
                    totalin += amt;
                    inv.add(String.valueOf(clock.getTimeAsString(e.time, 0)) + ": " + e.name + " " + UnitConstants.formatValue(amt, 4, true));
                    outv.add(" ");
                } else {
                    totalout += amt;
                    outv.add(String.valueOf(clock.getTimeAsString(e.time, 0)) + ": " + e.name + " " + UnitConstants.formatValue(amt, 4, true));
                    inv.add(" ");
                }
            }
            ++i;
        }
        this.inlist.setListData(inv);
        this.outlist.setListData(outv);
        this.intotal.setText(UnitConstants.formatValue(totalin, 4, true));
        this.outtotal.setText(UnitConstants.formatValue(totalout, 4, true));
    }

    private void radioday_actionPerformed(ActionEvent e) {
        this.historyLength = 86400000L;
        this.fillOut();
    }

    private void radioweek_actionPerformed(ActionEvent e) {
        this.historyLength = 604800000L;
        this.fillOut();
    }
}

