/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import phic.drug.Drug;
import phic.drug.Pharmacy;
import phic.gui.ModalDialog;

public class DrugEditor
extends ModalDialog {
    DefaultTableModel drugmodel = new DefaultTableModel();
    JTextField nameText = new JTextField();
    JLabel nameLabel = new JLabel();
    JLabel unit = new JLabel();
    JPanel toppanel = new JPanel();
    JPanel bottompanel = new JPanel();
    JPanel centrePanel = new JPanel();
    JTable table = new JTable();
    JScrollPane tablescroll = new JScrollPane();
    JTextArea infotext = new JTextArea();
    JScrollPane infotextscroll = new JScrollPane();
    Action okaction = new AbstractAction("OK"){

        public void actionPerformed(ActionEvent e) {
            CustomDrug d = DrugEditor.this.getDrug();
            if (d != null) {
                Pharmacy.defineDrug(d.toString(), d);
                DrugEditor.this.setVisible(false);
            }
        }
    };
    Action cancelaction = new AbstractAction("Cancel"){

        public void actionPerformed(ActionEvent e) {
            DrugEditor.this.setVisible(false);
        }
    };
    int propidx = 1;
    Action addaction = new AbstractAction("Add property"){

        public void actionPerformed(ActionEvent e) {
            DrugEditor.this.drugmodel.addRow(new String[]{"PROPERTY_" + DrugEditor.this.propidx++, "0"});
        }
    };
    Action removeaction = new AbstractAction("Remove property"){

        public void actionPerformed(ActionEvent e) {
            DrugEditor.this.drugmodel.removeRow(DrugEditor.this.table.getSelectedRow());
        }
    };
    JButton addprop = new JButton(this.addaction);
    JButton removeprop = new JButton(this.removeaction);
    JButton ok = new JButton(this.okaction);
    JButton cancel = new JButton(this.cancelaction);

    public DrugEditor() {
        this.setTitle("Drug editor");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toppanel, "North");
        this.getContentPane().add((Component)this.bottompanel, "South");
        this.getContentPane().add((Component)this.centrePanel, "Center");
        this.centrePanel.setLayout(new BorderLayout());
        this.centrePanel.add((Component)this.tablescroll, "Center");
        this.centrePanel.add((Component)this.infotextscroll, "South");
        this.infotextscroll.setViewportView(this.infotext);
        this.tablescroll.setViewportView(this.table);
        this.tablescroll.setPreferredSize(new Dimension(400, 150));
        this.table.setModel(this.drugmodel);
        this.toppanel.add(this.nameLabel);
        this.nameLabel.setText("Name:");
        this.nameText.setColumns(30);
        this.toppanel.add(this.nameText);
        this.nameText.setText("New Drug");
        this.unit.setText("Units");
        this.drugmodel.setColumnIdentifiers(new String[]{"Property name", "Value"});
        this.infotext.setText(this.getKnownDrugPropertiesAsText());
        this.infotextscroll.setPreferredSize(new Dimension(400, 150));
        this.infotext.setWrapStyleWord(true);
        this.infotext.setLineWrap(true);
        this.infotext.setEditable(false);
        this.bottompanel.add(this.addprop);
        this.bottompanel.add(this.removeprop);
        this.bottompanel.add(this.ok);
        this.bottompanel.add(this.cancel);
        this.getRootPane().setDefaultButton(this.ok);
        this.pack();
    }

    public void setDrug(String name, Map properties) {
        this.nameText.setText(String.valueOf(name) + " modified");
        for (String k : properties.keySet()) {
            if (k.equalsIgnoreCase("Description")) continue;
            Object o = properties.get(k);
            String v = o instanceof Double ? Double.toString((Double)o) : o.toString();
            this.drugmodel.addRow(new String[]{k, v});
        }
    }

    public CustomDrug getDrug() {
        CustomDrug d = new CustomDrug();
        d.name = this.nameText.getText();
        try {
            int i = 0;
            while (i < this.drugmodel.getRowCount()) {
                d.setProperty(this.drugmodel.getValueAt(i, 0).toString(), Double.parseDouble(this.drugmodel.getValueAt(i, 1).toString()));
                ++i;
            }
            return d;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Column 2 must contain numbers only.");
            return null;
        }
    }

    String[] knownProperyNames() {
        Vector<String> str = new Vector<String>();
        Field[] f = Drug.class.getFields();
        int i = 0;
        while (i < f.length) {
            if (f[i].getType() == String.class) {
                str.add(f[i].getName());
            }
            ++i;
        }
        return str.toArray(new String[str.size()]);
    }

    String getKnownDrugPropertiesAsText() {
        String[] s = this.knownProperyNames();
        StringBuffer sb = new StringBuffer("The following drug properties are currently known:\n");
        int i = 0;
        while (i < s.length) {
            sb.append(s[i]);
            if (i < s.length - 1) {
                sb.append("\n");
            }
            ++i;
        }
        return sb.toString();
    }

    public void addNotify() {
        super.addNotify();
        this.infotext.setCaretPosition(0);
        this.infotext.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
    }

    static class CustomDrug
    implements Drug {
        Map map = new HashMap();
        protected String name;

        CustomDrug() {
        }

        public void setProperty(String key, double value) {
            this.map.put(key, new Double(value));
        }

        public double getProperty(Object key) {
            return (Double)this.map.get(key);
        }

        public void setUnit(int unit) {
        }

        public Collection getKnownProperties() {
            return this.map.keySet();
        }

        public String toString() {
            return this.name;
        }
    }
}

