/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import phic.common.UnitConstants;
import phic.drug.DrugContainer;
import phic.drug.DrugQuantity;
import phic.drug.NoSuchDrugException;
import phic.drug.Pharmacy;
import phic.gui.DrugEditor;
import phic.gui.ModalDialog;

public class DrugDialog
extends ModalDialog {
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JButton cancel = new JButton();
    public JButton OK = new JButton();
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JList druglist = new JList();
    Box box1;
    JLabel drugname = new JLabel();
    JSlider amountslider = new JSlider();
    JLabel amounttext = new JLabel();
    JScrollPane jScrollPane2 = new JScrollPane();
    Border border1;
    JTextArea descriptiontext = new JTextArea();
    Border border2;
    JTabbedPane jTabbedPane1 = new JTabbedPane();
    JScrollPane jScrollPane3 = new JScrollPane();
    JTable drugpropstable = new JTable();
    JButton editButton = new JButton();
    DefaultTableModel tablemodel = new DefaultTableModel(new String[]{"Property", "Value"}, 0){

        public boolean isCellEditable(int i, int j) {
            return false;
        }
    };
    Action createNewDrug = new AbstractAction("Create new drug"){

        public void actionPerformed(ActionEvent e) {
        }
    };
    protected String drug;
    protected double middleAmount;
    protected double quantity;
    protected int sliderMid = 50;
    protected int minExponent = -2;
    private boolean OKpressed = false;
    private DrugContainer lastDispensedDrug = null;
    Action editDrugAction = new AbstractAction("Custom..."){

        public void actionPerformed(ActionEvent e) {
            DrugEditor de = new DrugEditor();
            if (DrugDialog.this.drug != null && DrugDialog.this.drug.length() > 0) {
                try {
                    de.setDrug(DrugDialog.this.drug, Pharmacy.getDrugMap(DrugDialog.this.drug));
                }
                catch (NoSuchDrugException e1) {
                    e1.printStackTrace();
                }
            }
            de.setVisible(true);
            DrugDialog.this.refreshList();
        }
    };

    public DrugDialog() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setPreferredSize(new Dimension(350, 300));
        this.refreshList();
        this.getRootPane().setDefaultButton(this.OK);
    }

    protected void refreshList() {
        this.druglist.setListData(Pharmacy.getDrugList());
    }

    private void jbInit() throws Exception {
        this.box1 = Box.createVerticalBox();
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.border2 = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setTitle("Choose drug from pharmacy");
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrugDialog.this.cancel_actionPerformed(e);
            }
        });
        this.editButton.setAction(this.editDrugAction);
        this.editButton.setToolTipText("Create a custom drug");
        this.OK.setText("OK");
        this.OK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrugDialog.this.OK_actionPerformed(e);
            }
        });
        this.jPanel1.setLayout(this.borderLayout1);
        this.drugname.setFont(new Font("Dialog", 1, 12));
        this.drugname.setAlignmentY(0.0f);
        this.drugname.setToolTipText("Name of drug");
        this.drugname.setText("Drug");
        this.amounttext.setAlignmentY(0.0f);
        this.amounttext.setToolTipText("Amount of drug");
        this.amounttext.setText("0 mg");
        this.jScrollPane1.setBorder(this.border2);
        this.jScrollPane1.setPreferredSize(new Dimension(160, 132));
        this.amountslider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DrugDialog.this.amountslider_stateChanged(e);
            }
        });
        this.druglist.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DrugDialog.this.druglist_valueChanged(e);
            }
        });
        this.jScrollPane2.setBorder(this.border1);
        this.amountslider.setValue(0);
        this.druglist.setToolTipText("List of drugs");
        this.descriptiontext.setText("Description");
        this.descriptiontext.setLineWrap(true);
        this.descriptiontext.setWrapStyleWord(true);
        this.descriptiontext.setBackground(SystemColor.control);
        this.descriptiontext.setEditable(false);
        this.descriptiontext.setFont(new Font("SansSerif", 0, 12));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jScrollPane1, "West");
        this.jPanel1.add((Component)this.box1, "Center");
        this.box1.add((Component)this.jTabbedPane1, null);
        this.jTabbedPane1.add((Component)this.jScrollPane2, "Description");
        this.jTabbedPane1.add((Component)this.jScrollPane3, "Properties");
        this.jScrollPane3.getViewport().add((Component)this.drugpropstable, null);
        this.jScrollPane2.getViewport().add((Component)this.descriptiontext, null);
        this.box1.add((Component)this.drugname, null);
        this.box1.add((Component)this.amountslider, null);
        this.box1.add((Component)this.amounttext, null);
        this.jScrollPane1.getViewport().add((Component)this.druglist, null);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.OK, null);
        this.jPanel2.add((Component)this.cancel, null);
        this.jPanel2.add(this.editButton);
        this.drugpropstable.setModel(this.tablemodel);
    }

    void druglist_valueChanged(ListSelectionEvent e) {
        Object o = this.druglist.getSelectedValue();
        if (o != null) {
            this.drug = (String)this.druglist.getSelectedValue();
            this.drugname.setText(this.drug);
            try {
                this.descriptiontext.setText(Pharmacy.getDrugDescription(this.drug));
                this.middleAmount = Pharmacy.getSingleDrugDose(this.drug);
                Map m = Pharmacy.getDrugMap(this.drug);
                this.tablemodel.setRowCount(0);
                for (Object k : m.keySet()) {
                    this.tablemodel.addRow(new Object[]{k, m.get(k)});
                }
                this.descriptiontext.setCaretPosition(0);
                this.descriptiontext.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            }
            catch (NoSuchDrugException m) {
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.amountslider.setValue(0);
            this.amountslider.setValue(this.sliderMid);
        }
    }

    protected void amountslider_stateChanged(ChangeEvent e) {
        int v = this.amountslider.getValue();
        double exponent = (double)((v - this.sliderMid) * -this.minExponent) / (double)this.sliderMid;
        this.quantity = this.middleAmount * Math.pow(10.0, exponent);
        try {
            this.amounttext.setText(UnitConstants.formatValue(this.quantity, Pharmacy.getDrugUnit(this.drug), false));
        }
        catch (NoSuchDrugException noSuchDrugException) {
            // empty catch block
        }
    }

    private void OK_actionPerformed(ActionEvent e) {
        this.OKpressed = true;
        this.hide();
    }

    private void cancel_actionPerformed(ActionEvent e) {
        this.hide();
    }

    public DrugContainer getDrugContainer() {
        if (this.OKpressed) {
            try {
                this.OKpressed = false;
                this.lastDispensedDrug = Pharmacy.dispenseAmpoule(this.drug, this.quantity);
                return this.lastDispensedDrug;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getDrugName() {
        return this.drug;
    }

    public String getDrugLabel() {
        if (this.lastDispensedDrug == null) {
            return String.valueOf(this.drug) + " " + this.amounttext.getText();
        }
        DrugQuantity q = (DrugQuantity)this.lastDispensedDrug.drugqs.get(0);
        return String.valueOf(q.getName()) + " " + q.formatValue(q.get(), true, false);
    }
}

