/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import phic.Current;
import phic.common.Quantity;
import phic.drug.DrugContainer;
import phic.drug.DrugQuantity;
import phic.drug.NoSuchDrugException;
import phic.drug.Pharmacy;
import phic.gui.ModalDialog;
import phic.gui.PhicApplication;
import phic.gui.SimplePhicFrame;

public class DrugConcentrationGraphChooser
extends ModalDialog {
    private JPanel jPanel1 = new JPanel();
    private JPanel jPanel2 = new JPanel();
    private JButton closeButton = new JButton();
    private JButton showButton = new JButton();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel jPanel3 = new JPanel();
    private JPanel jPanel4 = new JPanel();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JList drugList = new JList();
    private JPanel jPanel5 = new JPanel();
    private JTextField concentrationText = new JTextField();
    private DefaultListModel druglistmodel = new DefaultListModel();
    DrugContainer[] containers;
    String[] containerNames;
    private JComboBox containerList;
    private BorderLayout borderLayout2;
    private Border border1;
    private JLabel jLabel1;
    private BorderLayout borderLayout3;
    private Border border2;
    private Border border3;
    private JScrollPane jScrollPane2;
    private JTextArea drugdescription;

    public DrugConcentrationGraphChooser() {
        this.containers = new DrugContainer[]{Current.body.blood, (DrugContainer)Current.body.ecf, Current.body.Fat.getDrugContainer(), (DrugContainer)Current.body.bladder, Current.environment.stool, (DrugContainer)Current.body.kidney.urine, Current.body.gitract.stomach, (DrugContainer)Current.body.gitract.colon};
        this.containerNames = new String[]{"Blood", "ECF", "Fat", "Bladder", "Stool", "Urine", "Stomach", "Colon"};
        this.containerList = new JComboBox<String>(this.containerNames);
        this.borderLayout2 = new BorderLayout();
        this.jLabel1 = new JLabel();
        this.borderLayout3 = new BorderLayout();
        this.jScrollPane2 = new JScrollPane();
        this.drugdescription = new JTextArea();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setPreferredSize(new Dimension(400, 200));
        this.containerList.setSelectedIndex(0);
        this.getRootPane().setDefaultButton(this.closeButton);
    }

    DrugContainer currentContainer() {
        return this.containers[this.containerList.getSelectedIndex()];
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.border2 = BorderFactory.createEmptyBorder(6, 6, 6, 6);
        this.border3 = BorderFactory.createBevelBorder(1);
        this.setTitle("Drug concentration viewer");
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrugConcentrationGraphChooser.this.closeButton_actionPerformed(e);
            }
        });
        this.showButton.setToolTipText("Shows the drug in the graph window");
        this.showButton.setText("Show");
        this.showButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrugConcentrationGraphChooser.this.showButton_actionPerformed(e);
            }
        });
        this.jPanel1.setLayout(this.borderLayout1);
        this.jPanel4.setLayout(this.borderLayout2);
        this.concentrationText.setPreferredSize(new Dimension(190, 21));
        this.concentrationText.setToolTipText("Concentration of the drug");
        this.concentrationText.setText("0");
        this.concentrationText.setHorizontalAlignment(4);
        this.drugList.setToolTipText("Shows a list of drugs in the currently selected container");
        this.drugList.setModel(this.druglistmodel);
        this.drugList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DrugConcentrationGraphChooser.this.drugList_valueChanged(e);
            }
        });
        this.containerList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrugConcentrationGraphChooser.this.containerList_actionPerformed(e);
            }
        });
        this.jPanel4.setBorder(this.border1);
        this.jLabel1.setText("Container");
        this.containerList.setToolTipText("Select the container from which to choose a drug");
        this.jPanel5.setLayout(this.borderLayout3);
        this.jPanel5.setBorder(this.border2);
        this.drugdescription.setBorder(this.border3);
        this.drugdescription.setToolTipText("Drug description");
        this.drugdescription.setEditable(false);
        this.drugdescription.setText("No drug selected");
        this.drugdescription.setLineWrap(true);
        this.drugdescription.setWrapStyleWord(true);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jPanel3, "North");
        this.jPanel3.add((Component)this.jLabel1, null);
        this.jPanel3.add((Component)this.containerList, null);
        this.jPanel1.add((Component)this.jPanel4, "Center");
        this.jPanel4.add((Component)this.jScrollPane1, "Center");
        this.jPanel1.add((Component)this.jPanel5, "East");
        this.jPanel5.add((Component)this.concentrationText, "North");
        this.jPanel5.add((Component)this.jScrollPane2, "Center");
        this.jScrollPane2.getViewport().add((Component)this.drugdescription, null);
        this.jScrollPane1.getViewport().add((Component)this.drugList, null);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.showButton, null);
        this.jPanel2.add((Component)this.closeButton, null);
    }

    void containerList_actionPerformed(ActionEvent e) {
        DrugContainer c = this.currentContainer();
        this.druglistmodel.removeAllElements();
        int i = 0;
        while (i < c.drugqs.size()) {
            this.druglistmodel.addElement(c.drugqs.get(i));
            ++i;
        }
    }

    void closeButton_actionPerformed(ActionEvent e) {
        this.hide();
    }

    void drugList_valueChanged(ListSelectionEvent e) {
        Object o = this.drugList.getSelectedValue();
        if (o != null) {
            try {
                DrugQuantity q = (DrugQuantity)o;
                this.concentrationText.setText(q.toString());
                this.drugdescription.setText(Pharmacy.getDrugDescription(q.getName()));
            }
            catch (NoSuchDrugException x) {
                this.drugdescription.setText(x.toString());
            }
        } else {
            this.concentrationText.setText("");
            this.drugdescription.setText("No drug selected");
        }
    }

    void showButton_actionPerformed(ActionEvent e) {
        Object o = this.drugList.getSelectedValue();
        if (o == null) {
            return;
        }
        if (PhicApplication.frame instanceof SimplePhicFrame) {
            ((SimplePhicFrame)((Object)PhicApplication.frame)).graph.addNewVariable((Quantity)o, String.valueOf(this.containerList.getSelectedItem().toString()) + " " + ((DrugQuantity)o).getName());
        }
    }
}

