/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JLabel;
import phic.Resource;
import phic.common.Curve;
import phic.common.GasConc;
import phic.common.IniReader;
import phic.common.Quantity;
import phic.common.Ticker;
import phic.common.VDouble;
import phic.gui.GraphPaper;
import phic.gui.HorizontalBar;
import phic.gui.Node;
import phic.gui.VDoubleNode;
import phic.gui.VariablePropertiesDialog;
import phic.gui.Variables;
import phic.gui.VisibleVariable;
import phic.modifiable.Range;

public class CurveViewPanel
extends GraphPaper
implements Ticker {
    private static final String GRAPH_SETUP_FILE = "GraphSetups.txt";
    Node curveNode;
    Vector pointNodes = new Vector();
    Vector pointColors = new Vector();
    Vector pointAxes = new Vector();
    Vector pointNames = new Vector();
    Curve curve;
    int[] curvePoints = new int[this.getWidth()];
    Vector pointComponents = new Vector();
    Color curveColor = Color.yellow;

    public CurveViewPanel() {
        this.setLayout(null);
        this.setForeground(new Color(0, 128, 0));
    }

    public void setDescription(String s) {
        this.setToolTipText(s);
    }

    public void findAndAddAllCurvePointNodes() {
        try {
            IniReader ir = new IniReader(Resource.loader.getResource(GRAPH_SETUP_FILE));
            String[] hdr = ir.getSectionHeaders();
            int i = 0;
            while (i < hdr.length) {
                String[][] s = ir.getSectionPairs(hdr[i]);
                boolean found = false;
                int j = 0;
                while (j < s.length) {
                    if (s[j][1].equalsIgnoreCase("Curve") && s[j][0].equalsIgnoreCase(this.curveNode.canonicalNameReplaced())) {
                        found = true;
                    } else if (found) {
                        if (s[j][1].equalsIgnoreCase("CurvePointX")) {
                            this.addPointNode(Node.findNodeByName(s[j][0]), Color.red, false);
                        } else if (s[j][1].equalsIgnoreCase("CurvePointY")) {
                            this.addPointNode(Node.findNodeByName(s[j][0]), Color.yellow, true);
                        } else {
                            found = false;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addPointNode(final Node n, Color c, boolean axis) {
        if (this.pointNodes.contains(n)) {
            return;
        }
        this.pointNodes.add(n);
        this.pointColors.add(c);
        this.pointAxes.add(new Boolean(axis));
        JLabel l = new JLabel();
        this.add(l);
        l.setSize(5, 5);
        l.setBackground(c);
        l.setOpaque(true);
        l.setCursor(Cursor.getPredefinedCursor(12));
        l.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                try {
                    VisibleVariable vv = Variables.forNode(n);
                    VariablePropertiesDialog d = new VariablePropertiesDialog();
                    d.setVariable(vv);
                    d.show();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.pointComponents.add(l);
        String name = Resource.identifierToText(n.canonicalName());
        try {
            name = Resource.identifierToText(Variables.forNode((Node)n).longName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pointNames.add(name);
        Range xr = new Range(this.minx, this.maxx);
        Range yr = new Range(this.miny, this.maxy);
        if (this.pointNodes.size() == 1) {
            xr.set(0.0, 0.0);
            yr.set(0.0, 0.0);
        }
        if (n instanceof VDoubleNode) {
            VDouble vd = ((VDoubleNode)n).vDouble;
            if (axis) {
                yr.include(vd.minimum, vd.maximum);
                this.setYRange(yr.minimum, yr.maximum);
                double z = vd.minimum;
                while (z <= vd.maximum) {
                    xr.include(this.curve.getInverse(z) * 1.1);
                    z += (vd.maximum - vd.minimum) / 100.0;
                }
                this.setXRange(xr.minimum, xr.maximum);
            } else {
                xr.include(vd.minimum, vd.maximum);
                this.setXRange(xr.minimum, xr.maximum);
                double z = vd.minimum;
                while (z <= vd.maximum) {
                    yr.include(this.curve.getValue(z) * 1.1);
                    z += (vd.maximum - vd.minimum) / 100.0;
                }
                if (this.curve instanceof GasConc.DissocCurve) {
                    yr.maximum = 0.12;
                }
                this.setYRange(yr.minimum, yr.maximum);
            }
        }
    }

    public void setCurveNode(Node n) {
        this.curveNode = n;
        this.curve = (Curve)this.curveNode.objectGetVal();
    }

    public void tick(double t) {
        if (this.curvePoints.length != this.getWidth()) {
            this.curvePoints = new int[this.getWidth()];
        }
        int i = 0;
        while (i < this.getWidth()) {
            this.curvePoints[i] = this.yS(this.curve.getValue(this.xG(i)));
            ++i;
        }
        i = 0;
        while (i < this.pointNodes.size()) {
            double x;
            double y;
            JLabel l = (JLabel)this.pointComponents.get(i);
            Node n = (Node)this.pointNodes.get(i);
            boolean isY = (Boolean)this.pointAxes.get(i);
            double val = n.doubleGetVal();
            if (isY) {
                y = val;
                x = this.curve.getInverse(val);
            } else {
                x = val;
                y = this.curve.getValue(val);
            }
            l.setLocation(this.xS(x) - 2, this.yS(y) - 2);
            String name = (String)this.pointNames.get(i);
            if (n instanceof VDoubleNode) {
                l.setToolTipText(String.valueOf(name) + " = " + ((VDoubleNode)n).vDouble.formatValue(true, false));
            } else {
                l.setToolTipText(String.valueOf(name) + " = " + Quantity.toString(val));
            }
            ++i;
        }
        this.repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(this.curveColor);
        int i = 1;
        while (i < this.curvePoints.length) {
            g.drawLine(i - 1, this.curvePoints[i - 1], i, this.curvePoints[i]);
            ++i;
        }
        i = 0;
        while (i < this.pointNodes.size()) {
            int o;
            Node n = (Node)this.pointNodes.get(i);
            Color c = (Color)this.pointColors.get(i);
            boolean isY = (Boolean)this.pointAxes.get(i);
            g.setColor(c);
            double val = n.doubleGetVal();
            if (isY) {
                o = this.yS(val);
                g.drawLine(0, o, this.xS(this.curve.getInverse(val)), o);
            } else {
                o = this.xS(val);
                g.drawLine(o, this.getHeight(), o, this.yS(this.curve.getValue(val)));
            }
            ++i;
        }
    }

    public void addNotify() {
        super.addNotify();
        HorizontalBar.addBar(this);
    }

    public void removeNotify() {
        super.removeNotify();
        HorizontalBar.removeBar(this);
    }
}

