/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import phic.Body;
import phic.gui.HorizontalBar;
import phic.gui.VariableSelectionCombo;
import phic.gui.VisibleVariable;
import phic.modifiable.Controller;

public class ControllerEditor
extends JPanel {
    Controller[] controller;
    private Body body;
    JComboBox typeCombo = new JComboBox<Controller.Type>(Controller.Type.getTypes());
    TableCellEditor typeEditor = new DefaultCellEditor(this.typeCombo);
    JComboBox varCombo = new VariableSelectionCombo();
    TableCellEditor variableEditor = new DefaultCellEditor(this.varCombo);
    TableCellRenderer barRenderer = new BarRenderer();
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTable jTable1 = new JTable();
    ControllerTableModel model = new ControllerTableModel();

    public ControllerEditor() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.varCombo.setEditable(true);
    }

    public void setBody(Body b) {
        this.body = b;
        this.refreshControllers();
        this.jTable1.createDefaultColumnsFromModel();
        this.jTable1.getColumnModel().getColumn(1).setCellEditor(this.variableEditor);
        this.jTable1.getColumnModel().getColumn(2).setCellEditor(this.variableEditor);
        this.jTable1.getColumnModel().getColumn(3).setCellEditor(this.typeEditor);
        this.jTable1.getColumnModel().getColumn(7).setCellRenderer(this.barRenderer);
    }

    public void refreshControllers() {
        this.controller = this.body.getControllerList().getControllers();
        this.model.fireTableDataChanged();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.add((Component)this.jScrollPane1, "Center");
        this.jTable1.setModel(this.model);
        this.jScrollPane1.getViewport().add((Component)this.jTable1, null);
    }

    class BarRenderer
    implements TableCellRenderer {
        BarRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object o = table.getModel().getValueAt(row, 2);
            if (o instanceof VisibleVariable) {
                VisibleVariable vv = (VisibleVariable)o;
                HorizontalBar b = new HorizontalBar();
                b.drawText = false;
                b.setForeground(Color.cyan);
                b.setVariable(vv);
                return b;
            }
            return null;
        }
    }

    class ControllerTableModel
    extends AbstractTableModel {
        final String[] columns = new String[]{"Description", "Target", "Controller", "Control type", "Gain", "Rate", "Constant", "Error"};

        ControllerTableModel() {
        }

        public int getColumnCount() {
            return 8;
        }

        public int getRowCount() {
            if (ControllerEditor.this.controller == null) {
                return 0;
            }
            return ControllerEditor.this.controller.length;
        }

        public Object getValueAt(int r, int c) {
            if (ControllerEditor.this.controller == null) {
                return null;
            }
            switch (c) {
                case 0: {
                    return ControllerEditor.this.controller[r].getDescription();
                }
                case 1: {
                    return ControllerEditor.this.controller[r].getControlledVariable();
                }
                case 2: {
                    if (ControllerEditor.this.controller[r].getControlling() != null) {
                        return ControllerEditor.this.controller[r].getControllingVariable();
                    }
                    return ControllerEditor.this.controller[r].getDrugProperty();
                }
                case 3: {
                    return ControllerEditor.this.controller[r].getType();
                }
                case 4: {
                    return new Double(ControllerEditor.this.controller[r].getGain());
                }
                case 5: {
                    return new Double(ControllerEditor.this.controller[r].getRateFractionPerMinute());
                }
                case 6: {
                    return new Double(ControllerEditor.this.controller[r].getConstant());
                }
            }
            return null;
        }

        public String getColumnName(int c) {
            return this.columns[c];
        }

        public boolean isCellEditable(int r, int c) {
            return c < 7;
        }

        /*
         * Unable to fully structure code
         */
        public void setValueAt(Object o, int r, int c) {
            if (ControllerEditor.this.controller == null) {
                return;
            }
            switch (c) {
                case 0: {
                    ControllerEditor.this.controller[r].setDescription(o.toString());
                    break;
                }
                case 1: {
                    if (!(o instanceof VisibleVariable)) break;
                    ControllerEditor.this.controller[r].setControlledVariable((VisibleVariable)o);
                    break;
                }
                case 2: {
                    if (!(o instanceof VisibleVariable)) ** GOTO lbl15
                    ControllerEditor.this.controller[r].setControllingVariable((VisibleVariable)o);
                    ** GOTO lbl17
lbl15:
                    // 1 sources

                    if (o != null) {
                        ControllerEditor.this.controller[r].setDrugProperty(o.toString());
                    }
                }
lbl17:
                // 5 sources

                case 3: {
                    if (!(o instanceof Controller.Type)) break;
                    ControllerEditor.this.controller[r].setType((Controller.Type)o);
                    break;
                }
                case 4: {
                    if (o instanceof Number) {
                        ControllerEditor.this.controller[r].setGain(((Number)o).doubleValue());
                        break;
                    }
                    if (o == null) break;
                    try {
                        ControllerEditor.this.controller[r].setGain(Double.parseDouble(o.toString()));
                        break;
                    }
                    catch (NumberFormatException e) {
                        return;
                    }
                }
                case 5: {
                    if (o instanceof Number) {
                        ControllerEditor.this.controller[r].setRateFractionPerMinute(((Number)o).doubleValue());
                        break;
                    }
                    if (o == null) break;
                    try {
                        ControllerEditor.this.controller[r].setRateFractionPerMinute(Double.parseDouble(o.toString()));
                        break;
                    }
                    catch (NumberFormatException e) {
                        return;
                    }
                }
                case 6: {
                    if (o instanceof Number) {
                        ControllerEditor.this.controller[r].setConstant(((Number)o).doubleValue());
                        break;
                    }
                    if (o == null) break;
                    try {
                        ControllerEditor.this.controller[r].setConstant(Double.parseDouble(o.toString()));
                        break;
                    }
                    catch (NumberFormatException e) {
                        return;
                    }
                }
            }
        }
    }
}

