/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import phic.common.Container;
import phic.common.Quantity;

public class ContainerView
extends JPanel
implements Runnable {
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTable table = new JTable();
    MyTableModel tablemodel = new MyTableModel();
    protected boolean showingQuantities = false;
    String[] cnames = new String[]{"Volume /l", "%Solids", "[H]", "[HCO3-]", "[Na]", "[K]", "[glucose]", "[protein]", "[urea]"};
    int[] tx;
    int[] un;
    Thread thread;
    long delay;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContainer(Container c) {
        MyTableModel myTableModel = this.tablemodel;
        synchronized (myTableModel) {
            this.tablemodel.containers.add(c);
            this.tablemodel.fireTableStructureChanged();
            this.tablemodel.notifyAll();
        }
    }

    public ContainerView(Container c) {
        int[] nArray = new int[8];
        nArray[0] = 7;
        nArray[1] = 1;
        nArray[3] = 6;
        nArray[4] = 5;
        nArray[5] = 2;
        nArray[6] = 4;
        nArray[7] = 3;
        this.tx = nArray;
        this.un = new int[]{4, 17, 14, 14, 14, 14, 14, 14, 14};
        this.thread = new Thread((Runnable)this, "Container view updater");
        this.delay = 1000L;
        this.tablemodel.containers.add(c);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ContainerView(Container c, boolean update) {
        this(c);
        if (update) {
            this.thread.start();
        }
    }

    public void run() {
        while (true) {
            if (this.tablemodel.containers.size() > 0) {
                this.tablemodel.fireTableDataChanged();
                try {
                    Thread.sleep(this.delay);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            try {
                this.tablemodel.wait();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.table.setToolTipText("");
        this.table.setModel(this.tablemodel);
        this.setPreferredSize(new Dimension(454, 42));
        this.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.table, null);
    }

    public boolean isShowingQuantities() {
        return this.showingQuantities;
    }

    public void setShowingQuantities(boolean showingQuantities) {
        this.showingQuantities = showingQuantities;
    }

    class MyTableModel
    extends DefaultTableModel {
        public Vector containers = new Vector();

        MyTableModel() {
        }

        public int getRowCount() {
            if (this.containers != null) {
                return this.containers.size();
            }
            return 0;
        }

        public int getColumnCount() {
            return 8;
        }

        public String getColumnName(int i) {
            return ContainerView.this.cnames[i];
        }

        public Object getValueAt(int row, int column) {
            if (this.containers != null) {
                Container c = (Container)this.containers.get(row);
                if (column == 0) {
                    return new Double(c.volume.get());
                }
                Quantity q = (Quantity)c.qs.get(ContainerView.this.tx[column - 1]);
                if (ContainerView.this.showingQuantities) {
                    return q.Q;
                }
                return q;
            }
            return null;
        }
    }
}

