/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import phic.common.Container;
import phic.common.UnitConstants;
import phic.modifiable.Range;

public class ContainerDiagram
extends JPanel {
    Container container;
    int margin = 8;
    int nTicks = 5;
    int fluidLevel;
    JLabel[] constituents;
    double maxQuantity = 1.0;
    public static Color[] quantityColors = new Color[]{Color.green, Color.yellow, Color.pink, Color.orange, Color.white, Color.blue, Color.red, Color.darkGray, Color.magenta};
    boolean started;
    static Vector currentDiagrams = new Vector();
    static boolean running = true;
    static int timerDelay = 300;
    static Thread thread = new Thread(new Runnable(){

        public void run() {
            while (running) {
                int i = 0;
                while (i < currentDiagrams.size()) {
                    ContainerDiagram d = (ContainerDiagram)currentDiagrams.get(i);
                    if (d.started) {
                        if (d.getParent() == null) {
                            currentDiagrams.remove(d);
                        } else {
                            d.calculateRectangles();
                            d.repaint();
                        }
                    } else if (d.getParent() != null) {
                        d.started = true;
                    }
                    ++i;
                }
                try {
                    Thread.sleep(timerDelay);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    running = false;
                }
            }
            System.out.println("Containerview thread died");
        }
    }, "ContainerDiagram Updater");

    static {
        thread.start();
    }

    public ContainerDiagram() {
        this.setLayout(null);
        this.setPreferredSize(new Dimension(150, 150));
    }

    public void addNotify() {
        super.addNotify();
        currentDiagrams.add(this);
        if (this.container != null) {
            this.calculateRectangles();
        }
    }

    public void removeNotify() {
        currentDiagrams.remove(this);
        super.removeNotify();
    }

    public void paint(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int containerHeight = this.getHeight() - 2 * this.margin;
        double v = this.container.volume.get();
        Range range = Range.findRange(v, 3);
        this.fluidLevel = (int)((double)containerHeight * v / range.maximum);
        g.setColor(Color.cyan);
        g.fillRect(this.margin, this.getHeight() - this.margin - this.fluidLevel, this.getWidth() - 2 * this.margin, this.fluidLevel);
        g.setColor(Color.black);
        g.drawLine(this.margin, this.margin, this.margin, this.getHeight() - this.margin);
        g.drawLine(this.margin, this.getHeight() - this.margin, this.getWidth() - this.margin, this.getHeight() - this.margin);
        g.drawLine(this.getWidth() - this.margin, this.margin, this.getWidth() - this.margin, this.getHeight() - this.margin);
        int i = 0;
        while (i < this.nTicks) {
            int z = this.margin + i * containerHeight / this.nTicks;
            g.drawLine(this.margin - 2, z, this.margin, z);
            ++i;
        }
        g.drawString(UnitConstants.formatValue(range.maximum, 4, false), 0, 12);
        this.paintChildren(g);
    }

    public void setContainer(Container c) {
        this.container = c;
        this.constituents = new JLabel[Container.quantityname.length];
        int i = 0;
        while (i < this.constituents.length) {
            this.constituents[i] = new JLabel();
            this.constituents[i].setToolTipText(Container.quantityname[i]);
            this.constituents[i].setOpaque(true);
            this.constituents[i].setBackground(quantityColors[i]);
            this.add(this.constituents[i]);
            ++i;
        }
        this.calculateRectangles();
    }

    public void calculateRectangles() {
        int cumulativeHeight = 0;
        double totalMoles = 0.0;
        int solidHeight = (int)((double)this.fluidLevel * this.container.solids.getC());
        this.constituents[7].setBounds(this.margin + 1, this.getHeight() - this.margin - solidHeight, this.getWidth() - 2 * this.margin - 1, solidHeight);
        cumulativeHeight += solidHeight;
        int i = 0;
        while (i < 7) {
            double q = this.container.substance(i).getQ();
            totalMoles += q;
            ++i;
        }
        Range range = Range.findRange(totalMoles, 2);
        double scale = (double)(this.fluidLevel - cumulativeHeight) / range.maximum;
        int i2 = 0;
        while (i2 < 7) {
            double q = this.container.substance(i2).getQ();
            int height = (int)(q * scale);
            height = Math.min(Math.max(height, 0), this.fluidLevel);
            this.constituents[i2].setBounds(this.margin + 1, this.getHeight() - this.margin - cumulativeHeight - height, this.getWidth() - 2 * this.margin - 1, height);
            cumulativeHeight += height;
            this.constituents[i2].setToolTipText(String.valueOf(Container.quantityname[i2]) + " (" + this.container.substance(i2).formatValue(true, false) + ")");
            ++i2;
        }
    }
}

