/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;
import javax.swing.event.MouseInputAdapter;
import phic.Current;
import phic.Resource;
import phic.common.Clock;
import phic.common.Organ;
import phic.common.Quantity;
import phic.common.VDouble;
import phic.drug.Drug;
import phic.gui.Node;
import phic.gui.OldNodeView;
import phic.gui.Variables;
import phic.gui.VisibleVariable;

public class CombinedScrollGraph
extends JPanel
implements Runnable {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel controlpane = new JPanel();
    YScalePane tscalepane = new YScalePane();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel xscalepane = new JPanel();
    public MainPane mainpane = new MainPane();
    JPanel varnamepane = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    FlowLayout flowLayout1 = new FlowLayout();
    FlowLayout flowLayout2 = new FlowLayout();
    public JPopupMenu popupmenu = new JPopupMenu();
    Thread thread = new Thread((Runnable)this, "ScrollGraph");
    boolean running = true;
    int timer = 50;
    int scrollRate = 4;
    protected boolean enableHistory = true;
    public boolean enableWholeSessionHistory = false;
    Object waiter = new Object();
    public Clock clock;
    Vector vars = new Vector();
    static int serial = 0;
    double[] speeds = new double[]{0.1, 0.25, 1.0, 4.0, 10.0};
    int defaultTimerInterval = 50;
    JMenuItem jMenuItem1 = new JMenuItem();
    public boolean flashIfOutOfRange = true;

    public CombinedScrollGraph() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.thread.start();
        int i = 0;
        while (i < this.speeds.length) {
            JMenuItem m = new JMenuItem(new PopupAction(this.speeds[i]));
            this.popupmenu.add(m);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (this.running) {
                Object object;
                this.clock = Current.body.getClock();
                if (this.vars.size() == 0) {
                    object = this;
                    synchronized (object) {
                        if (this.vars.size() == 0) {
                            this.wait();
                        }
                    }
                }
                if (this.clock.running) {
                    this.mainpane.tick();
                    this.updateValues();
                }
                object = this.waiter;
                synchronized (object) {
                    this.waiter.wait(this.timer);
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        throw new RuntimeException("Terminating");
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.borderLayout2);
        this.mainpane.setBackground(Color.black);
        this.mainpane.setForeground(Color.white);
        this.controlpane.setLayout(this.borderLayout3);
        this.xscalepane.setLayout(this.flowLayout1);
        this.flowLayout1.setHgap(0);
        this.flowLayout1.setVgap(0);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                CombinedScrollGraph.this.rescaleAll();
            }
        });
        this.varnamepane.setLayout(this.flowLayout2);
        this.flowLayout2.setHgap(0);
        this.flowLayout2.setVgap(0);
        this.jMenuItem1.setBackground(SystemColor.activeCaption);
        this.jMenuItem1.setFont(new Font("Dialog", 1, 12));
        this.jMenuItem1.setForeground(SystemColor.activeCaptionText);
        this.jMenuItem1.setText("Timebase");
        this.add((Component)this.controlpane, "North");
        this.controlpane.add((Component)this.varnamepane, "Center");
        this.tscalepane.setPreferredSize(new Dimension(8, 10));
        this.add((Component)this.tscalepane, "West");
        this.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.xscalepane, "North");
        this.jPanel1.add((Component)this.mainpane, "Center");
        this.popupmenu.add(this.jMenuItem1);
        this.popupmenu.addSeparator();
        this.mainpane.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    CombinedScrollGraph.this.popupmenu.show(CombinedScrollGraph.this.mainpane, e.getX(), e.getY());
                }
            }
        });
    }

    public void addNewVariable(VisibleVariable v) {
        DisplayVariable vv = new DisplayVariable(v);
        this.addingNewVariable(vv);
    }

    public void addNewVariable(VDouble v, String name) {
        DisplayVariable vv = new DisplayVariable(v, name);
        this.addingNewVariable(vv);
    }

    public void addNewVariable(Node n) {
        DisplayVariable vv = new DisplayVariable(n);
        this.addingNewVariable(vv);
    }

    private synchronized void addingNewVariable(DisplayVariable vv) {
        vv.xscale = new XScalePane();
        vv.xscale.variable = vv;
        this.vars.add(vv);
        int n = this.vars.size();
        int width = this.columnWidth();
        this.createControls(vv);
        this.xscalepane.add(vv.xscale);
        vv.controls.setPreferredSize(new Dimension(width, vv.controls.getPreferredSize().height));
        vv.xscale.setPreferredSize(new Dimension(width, 20));
        this.rescaleAll();
        this.notifyAll();
    }

    int columnWidth() {
        if (this.vars.size() == 0) {
            return 0;
        }
        return (this.getWidth() - 20) / this.vars.size();
    }

    public void remove(VisibleVariable v) {
        this.removeVariable(v);
    }

    public void remove(VDouble v) {
        this.removeVariable(v);
    }

    private synchronized void removeVariable(Object o) {
        Vector<DisplayVariable> removal = new Vector<DisplayVariable>();
        int i = 0;
        while (i < this.vars.size()) {
            DisplayVariable vv = (DisplayVariable)this.vars.get(i);
            if (vv.vv == o || vv.vd == o) {
                this.xscalepane.remove(vv.xscale);
                removal.add(vv);
            }
            ++i;
        }
        this.vars.removeAll(removal);
        this.validate();
    }

    void remove(DisplayVariable v) {
        this.xscalepane.remove(v.xscale);
        this.varnamepane.remove(v.controls);
        this.vars.remove(v);
        this.rescaleAll();
    }

    public void removeAllGraphs() {
        while (this.vars.size() > 0) {
            this.remove((DisplayVariable)this.vars.get(0));
        }
    }

    void rescaleAll() {
        int n = this.vars.size();
        int width = this.columnWidth();
        int i = 0;
        while (i < n) {
            DisplayVariable a = (DisplayVariable)this.vars.get(i);
            a.xscale.setPreferredSize(new Dimension(width - 12 / n, 20));
            a.controls.setPreferredSize(new Dimension(width, a.controls.getPreferredSize().height));
            a.rescaleRange();
            ++i;
        }
        this.validateTree();
        this.xscalepane.doLayout();
        this.repaint();
    }

    void createControls(DisplayVariable v) {
        JPanel panel;
        v.controls = panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel titlebar = new JPanel();
        titlebar.setLayout(new BorderLayout());
        JLabel title = new JLabel(v.getLongName());
        if (OldNodeView.TitleBar.allowClose) {
            JButton closebutton = new JButton();
            closebutton.setToolTipText("Close this graph");
            closebutton.setIcon(new ImageIcon(Resource.loader.getImageResource("SmallCross.gif")));
            closebutton.setMargin(new Insets(0, 0, 0, 0));
            closebutton.addActionListener(new CloseListener(v));
            titlebar.add((Component)closebutton, "East");
        }
        title.setOpaque(true);
        title.setBackground(SystemColor.activeCaption);
        title.setForeground(SystemColor.activeCaptionText);
        if (v.vv != null) {
            title.addMouseListener(new TitleMouseListener(v));
        }
        if (v.vv != null) {
            title.setToolTipText(String.valueOf(v.vv.longName) + " (" + v.vv.canonicalName + ")");
        } else {
            title.setToolTipText(v.getLongName());
        }
        titlebar.add((Component)title, "Center");
        panel.add((Component)titlebar, "North");
        JLabel field = new JLabel("0.0");
        field.setOpaque(true);
        field.setBackground(Color.black);
        field.setForeground(v.colour);
        field.setFont(new Font("Arial", 1, 13));
        panel.add((Component)field, "Center");
        v.field = field;
        panel.setPreferredSize(new Dimension(this.columnWidth(), panel.getPreferredSize().height));
        panel.setBorder(new EtchedBorder(1));
        this.varnamepane.add(panel);
        this.validate();
    }

    void updateValues() {
        int i = 0;
        while (i < this.vars.size()) {
            DisplayVariable v = (DisplayVariable)this.vars.get(i);
            if (v.field != null) {
                double val = v.getCurrentValue();
                String s = v.formatValue(val, true, true);
                v.field.setText(s);
                if (v.vv != null && this.flashIfOutOfRange) {
                    if (val < v.vv.minimum || val > v.vv.maximum) {
                        if (!v.isOutOfRange) {
                            v.isOutOfRange = true;
                            v.field.setBackground(Color.white);
                            new StopFlashTimer(300, v).start();
                        }
                    } else if (v.isOutOfRange) {
                        v.isOutOfRange = false;
                    }
                }
            }
            ++i;
        }
    }

    public void reset() {
        if (!this.enableWholeSessionHistory) {
            this.mainpane.previousImages.removeAllElements();
        }
    }

    public void mark(Object event) {
        this.mainpane.drawArrow = true;
        this.mainpane.drawObject = event;
    }

    void drawTick(Graphics g, Component c, int pos, boolean Xaxis, boolean major, int thickness) {
        int a = 0;
        while (a < 2) {
            if (a == 0) {
                g.setColor(SystemColor.controlShadow);
            } else {
                g.setColor(SystemColor.controlLtHighlight);
            }
            if (Xaxis) {
                int yh = thickness;
                int ym = c.getHeight();
                if (major) {
                    g.drawLine(pos + a, yh, pos + a, ym);
                } else {
                    g.drawLine(pos + a, yh + (ym - yh) / 2, pos + a, ym);
                }
            } else {
                int xw = thickness;
                if (major) {
                    g.drawLine(0, pos + a, xw, pos + a);
                } else {
                    g.drawLine(xw / 2, pos + a, xw, pos + a);
                }
            }
            ++a;
        }
    }

    public void setYSpeed(double speed) {
        if (speed >= 1.0) {
            this.scrollRate = (int)speed;
            this.timer = this.defaultTimerInterval;
        } else {
            this.scrollRate = 1;
            this.timer = (int)((double)this.defaultTimerInterval / speed);
        }
    }

    public void replaceVariables() {
        int i = 0;
        while (i < this.vars.size()) {
            DisplayVariable v = (DisplayVariable)this.vars.get(i);
            if (v.vv != null) {
                v.vv = Variables.forName(v.vv.canonicalName);
                v.node = v.vv.node;
            } else {
                v.node = Node.findNodeByName(v.node.canonicalName());
            }
            ++i;
        }
    }

    public void removeAnyDrugQuantities() {
        int i = 0;
        while (i < this.vars.size()) {
            DisplayVariable v = (DisplayVariable)this.vars.get(i);
            if (v != null) {
                if (v.vv == null && v.vd instanceof Drug) {
                    this.remove(v);
                    --i;
                }
                if (this.isVisible()) {
                    this.validate();
                }
            }
            ++i;
        }
    }

    public boolean getEnableHistory() {
        return this.enableHistory;
    }

    public void setEnableHistory(boolean enableHistory) {
        this.enableHistory = enableHistory;
        if (!enableHistory) {
            this.mainpane.previousImages.removeAllElements();
        }
    }

    class CloseListener
    implements ActionListener {
        DisplayVariable v;

        CloseListener(DisplayVariable v) {
            this.v = v;
        }

        public void actionPerformed(ActionEvent e) {
            CombinedScrollGraph.this.remove(this.v);
        }
    }

    final class DisplayVariable {
        private Node node;
        VisibleVariable vv;
        VDouble vd;
        private String _longname;
        int lastPosition;
        double origin;
        double scale;
        double maximum;
        double minimum;
        Color colour;
        XScalePane xscale;
        JPanel controls;
        JLabel field;
        public boolean isOutOfRange = false;
        boolean zoomed = true;
        double[] decades = new double[]{0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
        double[] triads = new double[]{0.1, 0.2, 0.5, 1.0};
        Color[] colours = new Color[]{Color.red, Color.cyan, Color.pink, Color.yellow, Color.green, Color.magenta, Color.orange};

        DisplayVariable(VDouble vd, String longName) {
            this.vd = vd;
            this._longname = longName;
            this.colour = this.colours[serial++ % this.colours.length];
        }

        DisplayVariable(Node n) {
            this.node = n;
            this._longname = n.canonicalName();
            this.colour = this.colours[serial++ % this.colours.length];
        }

        DisplayVariable(VisibleVariable vv) {
            this.vv = vv;
            this.node = vv.node;
            this.colour = this.colours[serial++ % this.colours.length];
        }

        int getCurrentPosition() {
            this.lastPosition = (int)((this.getCurrentValue() - this.origin) * this.scale) + this.xscale.getX();
            return this.lastPosition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        double getCurrentValue() {
            Organ.DataLock dataLock = Organ.cycleLock;
            synchronized (dataLock) {
                if (this.node != null) {
                    return this.node.doubleGetVal();
                }
                return this.vd.get();
            }
        }

        private double getCurrentMinimum() {
            return Math.min(this.getMinimum(), this.getCurrentValue());
        }

        private double getCurrentMaximum() {
            return Math.max(this.getMaximum(), this.getCurrentValue());
        }

        double getInitial() {
            if (this.vv != null) {
                return this.vv.initial;
            }
            if (this.vd != null) {
                return this.vd.initialValue;
            }
            return 0.0;
        }

        double getMaximum() {
            if (this.vv != null) {
                return this.vv.maximum;
            }
            if (this.vd != null) {
                return this.vd.maximum;
            }
            return 1.0;
        }

        double getMinimum() {
            if (this.vv != null) {
                return this.vv.minimum;
            }
            if (this.vd != null) {
                return this.vd.minimum;
            }
            return 0.0;
        }

        String getLongName() {
            if (this.vv != null) {
                return this.vv.longName;
            }
            return this._longname;
        }

        String formatValue(double value, boolean showUnit, boolean fixed) {
            if (this.vv != null) {
                return this.vv.formatValue(value, showUnit, fixed);
            }
            if (this.vd != null) {
                return this.vd.formatValue(value, showUnit, fixed);
            }
            return Quantity.toString(value);
        }

        void rescaleRange() {
            double current = this.getCurrentValue();
            double decade = Math.pow(10.0, 1 + (int)Math.floor(Math.log(current) / Math.log(10.0)));
            if (decade == 0.0) {
                decade = 1.0;
            }
            if (this.zoomed && current > 0.0) {
                this.minimum = 0.0;
                current = Math.max(current, this.getMaximum());
                decade = Math.pow(10.0, 1 + (int)Math.floor(Math.log(current) / Math.log(10.0)));
                int i = this.findFirstIndexAbove(current / decade, this.triads);
                this.maximum = decade * this.triads[i];
            } else {
                int i = this.findFirstIndexAbove(current / decade, this.decades);
                if (i == 0) {
                    this.minimum = this.decades[i] * decade;
                    this.maximum = this.decades[i + 1] * decade;
                } else {
                    this.minimum = this.decades[i - 1] * decade;
                    this.maximum = this.decades[i] * decade;
                }
            }
            if (this.maximum == this.minimum) {
                this.maximum = this.vv != null ? this.minimum + this.vv.initial : this.minimum + 1.0;
                System.out.println("Scaling of " + this.node + " failed");
            }
            this.origin = this.minimum;
            this.rescalePanel();
            this.xscale.setToolTipText("Scale " + this.formatValue(this.minimum, true, false) + " - " + this.formatValue(this.maximum, true, false));
        }

        public void rescalePanel() {
            this.scale = (double)this.xscale.getPreferredSize().width / (this.maximum - this.origin);
        }

        int findFirstIndexAbove(double value, double[] list) {
            int i = 0;
            while (i < list.length) {
                if (list[i] >= value) {
                    return i;
                }
                ++i;
            }
            return list.length - 1;
        }
    }

    class MainPane
    extends JPanel {
        BufferedImage i1;
        BufferedImage i2;
        BufferedImage lower;
        BufferedImage upper;
        Vector previousImages = new Vector();
        int switchPoint = 0;
        int scrollPoint = 0;
        MouseInputAdapter drawAdapter = new MouseInputAdapter(){
            Point o;
            int oSw;
            boolean oflip;
            boolean dragging;
            {
                this.oflip = MainPane.this.i1 == MainPane.this.upper;
                this.dragging = false;
            }

            public void mouseDragged(MouseEvent e) {
                this.dragging = true;
                if (((MainPane)MainPane.this).CombinedScrollGraph.this.enableHistory && ((e.getModifiersEx() & 0x800) > 0 || (e.getModifiersEx() & 0x80) > 0)) {
                    this.scrollDrag(e);
                    return;
                }
                if (MainPane.this.scrollPoint > 0) {
                    return;
                }
                boolean flip = MainPane.this.i1 == MainPane.this.upper;
                Point p = e.getPoint();
                if (this.o != null && flip == this.oflip) {
                    Graphics g = MainPane.this.upper.getGraphics();
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setColor(Color.white);
                    g.drawLine(this.o.x, this.o.y - this.oSw + MainPane.this.getHeight(), p.x, p.y - MainPane.this.switchPoint + MainPane.this.getHeight());
                    g = MainPane.this.lower.getGraphics();
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setColor(Color.white);
                    g.drawLine(this.o.x, this.o.y - this.oSw, p.x, p.y - MainPane.this.switchPoint);
                    MainPane.this.repaint();
                }
                this.o = p;
                this.oSw = MainPane.this.switchPoint;
                this.oflip = flip;
            }

            void scrollDrag(MouseEvent e) {
                Point p = e.getPoint();
                int dx = p.x - this.o.x;
                int dy = p.y - this.o.y;
                MainPane.this.scrollPoint = Math.min(Math.max(MainPane.this.scrollPoint - dy, 0), MainPane.this.previousImages.size() * MainPane.this.getHeight());
                this.o = p;
                MainPane.this.repaint();
            }

            public void mouseReleased(MouseEvent e) {
                if (this.dragging) {
                    this.dragging = false;
                    e.consume();
                }
            }

            public void mousePressed(MouseEvent e) {
                this.o = e.getPoint();
                this.oSw = MainPane.this.switchPoint;
            }
        };
        boolean isMajorTick;
        boolean isMinorTick;
        boolean isMinuteTick;
        long prevTimeMins;
        long prevTimeHours;
        long prevTimeDays;
        boolean drawArrow;
        Object drawObject;
        public boolean antiAlias = true;
        int thickness = 2;
        int hourlyDisplay = 6;
        int minutelyDisplay = 0;

        MainPane() {
            this.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    MainPane.this.createImages();
                }
            });
            this.addMouseListener(this.drawAdapter);
            this.addMouseMotionListener(this.drawAdapter);
            this.setDoubleBuffered(false);
        }

        void createImages() {
            int w = this.getWidth();
            int h = this.getHeight();
            if (w > 0 && h > 0) {
                this.i1 = new BufferedImage(w, h, 5);
                this.i2 = new BufferedImage(w, h, 5);
                if (this.upper != null && this.upper.getHeight() == h) {
                    this.i1.getGraphics().drawImage(this.upper, 0, 0, null);
                }
                this.lower = this.i2;
                this.upper = this.i1;
            }
        }

        public void paint(Graphics g) {
            g.drawImage(this.upper, 0, -this.scrollPoint + this.switchPoint - this.upper.getHeight(), this);
            g.drawImage(this.lower, 0, -this.scrollPoint + this.switchPoint, this);
            int n = this.previousImages.size();
            if (CombinedScrollGraph.this.enableHistory && this.scrollPoint > 0) {
                int i = 0;
                while (i < n) {
                    BufferedImage prev = (BufferedImage)this.previousImages.get(i);
                    g.drawImage(prev, 0, -this.scrollPoint + this.switchPoint + (n - i) * this.upper.getHeight(), this);
                    ++i;
                }
            }
        }

        void tick() {
            if (this.lower == null) {
                return;
            }
            this.scrollPoint = 0;
            this.advanceImages();
            double pixrate = (double)CombinedScrollGraph.this.scrollRate / (double)CombinedScrollGraph.this.timer * CombinedScrollGraph.this.clock.getSecond();
            int n = pixrate > 0.5 ? 1 : (pixrate > 0.2 ? 5 : (this.minutelyDisplay = pixrate > 0.04 ? 30 : 0));
            this.hourlyDisplay = pixrate > 0.01 ? 1 : (pixrate > 0.002 ? 6 : 24);
            long timeMins = CombinedScrollGraph.this.clock.getTime() / 60000L;
            long timeHours = timeMins / 60L;
            long timeDays = timeHours / 24L;
            this.isMajorTick = this.prevTimeDays != timeDays;
            boolean bl = this.isMinorTick = this.prevTimeHours != timeHours;
            if (this.minutelyDisplay > 0) {
                this.isMinuteTick = this.prevTimeMins / (long)this.minutelyDisplay != timeMins / (long)this.minutelyDisplay;
            }
            this.prevTimeDays = timeDays;
            this.prevTimeHours = timeHours;
            this.prevTimeMins = timeMins;
            if (this.drawArrow) {
                this.drawArrow = false;
                Graphics g = this.upper.getGraphics();
                g.setColor(Color.white);
                int h = this.getHeight() - this.switchPoint;
                g.drawLine(this.getWidth() - 4, h, this.getWidth(), h);
                String s = this.drawObject.toString();
                Rectangle2D rr = g.getFont().getStringBounds(s, ((Graphics2D)g).getFontRenderContext());
                g.drawString(s, this.getWidth() - (int)rr.getWidth() - 5, h + (int)rr.getHeight() / 2);
            }
            int i = 0;
            while (i < CombinedScrollGraph.this.vars.size()) {
                DisplayVariable v = (DisplayVariable)CombinedScrollGraph.this.vars.get(i);
                this.doGrid(v);
                Graphics g = this.upper.getGraphics();
                if (this.antiAlias) {
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                if (this.thickness > 0) {
                    ((Graphics2D)g).setStroke(new BasicStroke(this.thickness));
                }
                g.setColor(v.colour);
                int lastpos = v.lastPosition;
                int pos = v.getCurrentPosition();
                int h = this.getHeight();
                pos = Math.max(0, Math.min(pos, this.getWidth() - 1));
                g.drawLine(lastpos, h - this.switchPoint + CombinedScrollGraph.this.scrollRate, pos, h - this.switchPoint);
                if (this.switchPoint > this.getHeight() - CombinedScrollGraph.this.scrollRate) {
                    Graphics g2 = this.lower.getGraphics();
                    g2.setColor(v.colour);
                    g2.drawLine(v.lastPosition, -this.switchPoint + CombinedScrollGraph.this.scrollRate, v.getCurrentPosition(), -this.switchPoint);
                }
                ++i;
            }
            this.repaint();
        }

        final void doGrid(DisplayVariable v) {
            Graphics g = this.upper.getGraphics();
            g.setColor(Color.gray);
            int gw = v.xscale.minorSpacing;
            int gh = CombinedScrollGraph.this.tscalepane.minorSpacing;
            int h = this.getHeight() - this.switchPoint;
            if (this.isMajorTick) {
                g.drawLine(v.xscale.getX(), h, v.xscale.getX() + v.xscale.getWidth(), h);
                g.drawString(CombinedScrollGraph.this.clock.getTimeString(1), 0, h - 2);
            } else if (this.isMinorTick && gw > 0) {
                int x = 0;
                while (x < v.xscale.getWidth()) {
                    g.drawLine(v.xscale.getX() + x, h, v.xscale.getX() + x, h);
                    x += gw;
                }
                if (this.prevTimeHours % (long)this.hourlyDisplay == 0L) {
                    g.drawString(String.valueOf(String.valueOf(this.prevTimeHours % 24L)) + "h", 0, h - 2);
                }
            } else if (this.minutelyDisplay > 0 && this.isMinuteTick) {
                g.drawString(String.valueOf(String.valueOf((long)this.minutelyDisplay * (this.prevTimeMins % 60L / (long)this.minutelyDisplay))) + "m", 0, h - 2);
            } else {
                int x = v.xscale.getX();
                g.drawLine(x, h, x, h);
                g.drawLine(x += v.xscale.getWidth(), h, x, h);
            }
        }

        final void advanceImages() {
            this.switchPoint += CombinedScrollGraph.this.scrollRate;
            if (this.switchPoint > this.getHeight()) {
                this.switchPoint -= this.getHeight();
                BufferedImage t = this.lower;
                this.lower = this.upper;
                this.upper = t;
                if (CombinedScrollGraph.this.enableHistory) {
                    this.previousImages.add(this.upper);
                    this.upper = new BufferedImage(this.getWidth(), this.getHeight(), 5);
                } else {
                    Graphics g = this.upper.getGraphics();
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, this.upper.getWidth(), this.upper.getHeight());
                }
            }
        }
    }

    class PopupAction
    extends AbstractAction {
        double speed;

        PopupAction(double speed) {
            super(String.valueOf(speed));
            this.speed = speed;
        }

        public void actionPerformed(ActionEvent e) {
            CombinedScrollGraph.this.setYSpeed(this.speed);
        }
    }

    class StopFlashTimer
    extends Timer {
        StopFlashTimer(int time, final DisplayVariable variable) {
            super(time, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    variable.field.setBackground(Color.black);
                }
            });
            this.setRepeats(false);
        }
    }

    class TitleMouseListener
    extends MouseAdapter {
        DisplayVariable variable;

        public TitleMouseListener(DisplayVariable v) {
            this.variable = v;
        }

        public void mouseClicked(MouseEvent e) {
            this.variable.vv.displayVariableDialog();
        }
    }

    class XScalePane
    extends JPanel {
        boolean labelInitialValue = false;
        int majorPerMinor = 5;
        int minorSpacing;
        int nMinors = 10;
        DisplayVariable variable;
        static final int fixedHeight = 20;
        final int majorDepth = 10;
        final int textDepth = 13;
        final int hTextGap = 6;

        public XScalePane() {
            this.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent e) {
                    XScalePane.this.variable.zoomed = !XScalePane.this.variable.zoomed;
                    XScalePane.this.variable.rescaleRange();
                    XScalePane.this.repaint();
                }
            });
        }

        public void paint(Graphics g) {
            super.paint(g);
            this.minorSpacing = this.getWidth() / this.nMinors;
            int yh = this.getHeight();
            int i = 0;
            int xw = this.getWidth();
            g.setColor(SystemColor.controlShadow);
            g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            int x = 0;
            while (x < xw) {
                CombinedScrollGraph.this.drawTick(g, this, x, true, i++ % this.majorPerMinor == 0, 10);
                x += this.minorSpacing;
            }
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setFont(new Font("Arial", 0, 10));
            if (this.labelInitialValue) {
                this.labelTick(g, this.variable.getInitial());
            }
            this.drawArrow(g, this.variable.getInitial(), Color.red);
            this.labelTick(g, this.variable.minimum);
            this.labelTick(g, this.variable.maximum);
        }

        int xcoord(double value) {
            int a = (int)((value - this.variable.origin) * this.variable.scale);
            if ((double)a < 100000.0) {
                return a;
            }
            return 0;
        }

        final void labelTick(Graphics g, double value) {
            int x = this.xcoord(value);
            CombinedScrollGraph.this.drawTick(g, this, x, true, true, 10);
            String label = this.variable.formatValue(value, false, false);
            if (label.endsWith(".0")) {
                label = label.substring(0, label.length() - 2);
            }
            Rectangle2D rr = this.getFont().getStringBounds(label, ((Graphics2D)g).getFontRenderContext());
            Dimension r = new Dimension((int)rr.getWidth(), (int)rr.getHeight());
            if (x + r.width / 2 > this.getWidth()) {
                x = this.getWidth() - r.width / 2 - 3;
            }
            if (x - r.width / 2 < 0) {
                x = r.width / 2 + 3;
            }
            g.setColor(Color.black);
            g.drawString(label, x - r.width / 2, 13);
        }

        final void drawArrow(Graphics g, double value, Color colour) {
            g.setColor(colour);
            int x = this.xcoord(value);
            int y = 8;
            g.fillPolygon(new int[]{x, x - 4, x + 4}, new int[]{y, y - 8, y - 8}, 3);
        }
    }

    class YScalePane
    extends JPanel {
        int majorPerMinor = 5;
        int minorSpacing = 30;

        YScalePane() {
        }

        public void paint(Graphics g) {
            super.paint(g);
            int yh = this.getHeight();
            int i = 0;
            int xw = this.getWidth();
            g.setColor(SystemColor.controlShadow);
            g.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight());
            int y = yh;
            while (y > 0) {
                CombinedScrollGraph.this.drawTick(g, this, y, false, i++ % this.majorPerMinor == 0, xw);
                y -= this.minorSpacing;
            }
        }
    }
}

