/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.Scrollable;
import javax.swing.SwingConstants;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import phic.Current;
import phic.common.Organ;
import phic.common.Quantity;
import phic.common.VDoubleReadOnly;
import phic.gui.BodyTree;
import phic.gui.Node;
import phic.gui.PhicApplication;
import phic.gui.SimplePhicFrame;
import phic.gui.Variables;
import phic.gui.VisibleVariable;

public class BodyTreeLabelled
extends BodyTree
implements SwingConstants {
    protected final int LABEL_UPDATE_TIME = 1000;
    JScrollPane jScrollPane1 = new JScrollPane();
    JSplitPane jSplitPane1 = new JSplitPane();
    JPopupMenu menu = new JPopupMenu("Node menu");
    private JMenuItem infomenuitem = new JMenuItem();
    private JMenu displaymenu = new JMenu();
    private JMenu unitmenuitem;
    JMenuItem clampmenu = new JMenuItem();
    private JPanel rightPanel = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JPanel mainPanel = new ScrollablePane();
    public boolean needsNewLabels = false;
    private JPanel labelspanel = new JPanel(){

        public void paint(Graphics g) {
            if (BodyTreeLabelled.this.needsNewLabels) {
                BodyTreeLabelled.this.newValues();
                BodyTreeLabelled.this.needsNewLabels = false;
            }
            super.paint(g);
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.height = Math.max(15, d.height);
            d.width = Math.max(15, d.width);
            return d;
        }
    };
    private GridLayout labelslayout = new GridLayout();
    TreeExpansionListener tel = new TreeExpansionListener(){

        public void treeExpanded(TreeExpansionEvent e) {
            BodyTreeLabelled.this.updateValues();
        }

        public void treeCollapsed(TreeExpansionEvent e) {
            BodyTreeLabelled.this.updateValues();
        }
    };
    Node[] nodes;
    JComponent[] labels;
    public boolean updateWhileStopped = true;
    boolean running = true;
    Thread thread = new Thread("TreeLabelUpdater"){

        public void run() {
            while (BodyTreeLabelled.this.running) {
                BodyTreeLabelled.this.tick();
                try {
                    3.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    };
    JMenuItem resetmenuitem = new JMenuItem();
    JMenuItem copynamemenu = new JMenuItem();
    JMenuItem eqnsmenu = new JMenuItem("Show equations");
    Action copyNameAction = new AbstractAction("Copy name"){

        public void actionPerformed(ActionEvent e) {
            String cp = "";
            if (BodyTreeLabelled.this.tree.getSelectionCount() > 0) {
                int[] s = BodyTreeLabelled.this.tree.getSelectionRows();
                int i = 0;
                while (i < s.length) {
                    Node n = BodyTreeLabelled.this.getNodeForRow(s[i]);
                    cp = String.valueOf(cp) + n.canonicalNameReplaced();
                    if (i < s.length - 1) {
                        cp = String.valueOf(cp) + ";";
                    }
                    ++i;
                }
            }
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(cp), null);
        }
    };

    public BodyTreeLabelled() {
        this.removeAll();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.scrollpane.getVerticalScrollBar().setUnitIncrement(10);
        this.jSplitPane1.setLeftComponent(this.tree);
        this.tree.addTreeExpansionListener(this.tel);
        this.thread.start();
    }

    void updateValues() {
        this.needsNewLabels = true;
        this.labelspanel.repaint();
    }

    void newValues() {
        this.labelslayout.setRows(this.tree.getRowCount());
        this.labelspanel.removeAll();
        this.nodes = new Node[this.tree.getRowCount()];
        this.labels = new JComponent[this.nodes.length];
        int i = 0;
        while (i < this.nodes.length) {
            this.nodes[i] = this.getNodeForRow(i);
            this.labels[i] = this.createLabel(this.nodes[i]);
            this.labels[i].setPreferredSize(new Dimension(this.labels[i].getPreferredSize().width, this.tree.getRowBounds((int)i).height));
            this.labelspanel.add(this.labels[i]);
            ++i;
        }
        this.labelspanel.setPreferredSize(new Dimension(Math.max(200, this.labelspanel.getPreferredSize().width), this.tree.getPreferredSize().height));
        this.jScrollPane1.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tick() {
        if (this.nodes == null || this.nodes.length < 1 || !this.updateWhileStopped && !Current.body.getClock().running) {
            return;
        }
        Organ.DataLock dataLock = Organ.cycleLock;
        synchronized (dataLock) {
            int i = 0;
            while (i < this.nodes.length) {
                if (this.labels[i] instanceof JLabel) {
                    ((JLabel)this.labels[i]).setText(this.nodeToString(this.nodes[i]));
                }
                ++i;
            }
        }
    }

    String nodeToString(Node n) {
        int type;
        if (n != null && (type = n.getType()) == 2) {
            VisibleVariable v = Variables.forNode(n);
            if (v != null) {
                double x = n.doubleGetVal();
                String s = v.formatValue(x, true, true);
                if (x < v.minimum) {
                    s = String.valueOf(s) + " *L";
                } else if (x > v.maximum) {
                    s = String.valueOf(s) + " *H";
                }
                return s;
            }
            return Quantity.toString(n.doubleGetVal());
        }
        return "";
    }

    JComponent createLabel(Node n) {
        return new JLabel(this.nodeToString(n));
    }

    private void jbInit() throws Exception {
        this.infomenuitem.setText("Info");
        this.infomenuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BodyTreeLabelled.this.showNodeInfo(e);
            }
        });
        this.displaymenu.setText("Display");
        this.labelslayout.setColumns(1);
        this.labelspanel.setLayout(this.labelslayout);
        this.labelspanel.setMinimumSize(new Dimension(15, 15));
        this.resetmenuitem.setText("Reset");
        this.resetmenuitem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BodyTreeLabelled.this.resetnodeval(e);
            }
        });
        this.copynamemenu.setAction(this.copyNameAction);
        this.menu.add(this.infomenuitem);
        this.menu.add(this.eqnsmenu);
        this.eqnsmenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BodyTreeLabelled.this.showVariableEqns();
            }
        });
        this.menu.add(this.displaymenu);
        this.menu.add(this.resetmenuitem);
        this.menu.add(this.clampmenu);
        this.menu.add(this.copynamemenu);
        this.rightPanel.setLayout(this.borderLayout1);
        this.rightPanel.add((Component)this.labelspanel, "North");
        this.jSplitPane1.setRightComponent(this.rightPanel);
        this.jScrollPane1.getViewport().setView(this.mainPanel);
        this.mainPanel.setLayout(this.borderLayout2);
        this.mainPanel.add(this.jSplitPane1);
        this.add((Component)this.jScrollPane1, "Center");
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JTree tree = BodyTreeLabelled.this.tree;
                    int r = tree.getRowForLocation(e.getX(), e.getY());
                    if (r >= 0) {
                        tree.setSelectionRow(r);
                    }
                    SimplePhicFrame f = (SimplePhicFrame)PhicApplication.frame.getJFrame();
                    BodyTreeLabelled.this.displaymenu.removeAll();
                    if (f.selectednode == null) {
                        return;
                    }
                    JPopupMenu pm = f.createDisplayPopup(f.selectednode);
                    if (pm != null) {
                        Component[] c = pm.getComponents();
                        int i = 0;
                        while (i < c.length) {
                            BodyTreeLabelled.this.displaymenu.add(c[i]);
                            ++i;
                        }
                    }
                    VisibleVariable vv = BodyTreeLabelled.this.tryGetSelectedVariable();
                    BodyTreeLabelled.this.infomenuitem.setEnabled(vv != null);
                    boolean ee = vv != null && !(vv.node.objectGetVal() instanceof VDoubleReadOnly);
                    BodyTreeLabelled.this.resetmenuitem.setEnabled(ee);
                    BodyTreeLabelled.this.clampmenu.setEnabled(ee);
                    if (BodyTreeLabelled.this.unitmenuitem != null) {
                        BodyTreeLabelled.this.menu.remove(BodyTreeLabelled.this.unitmenuitem);
                    }
                    if (vv != null) {
                        BodyTreeLabelled.this.unitmenuitem = vv.createUnitsMenu();
                    }
                    if (BodyTreeLabelled.this.unitmenuitem != null) {
                        BodyTreeLabelled.this.menu.add(BodyTreeLabelled.this.unitmenuitem);
                    }
                    if (vv != null) {
                        BodyTreeLabelled.this.clampmenu.setAction(vv.clampVariable);
                    }
                    BodyTreeLabelled.this.menu.show(tree, e.getX(), e.getY());
                }
            }
        });
    }

    VisibleVariable tryGetSelectedVariable() {
        try {
            Node n = ((SimplePhicFrame)PhicApplication.frame.getJFrame()).selectednode;
            VisibleVariable vv = Variables.forNode(n);
            return vv;
        }
        catch (Exception x) {
            return null;
        }
    }

    void showNodeInfo(ActionEvent e) {
        if (this.tree.getSelectionCount() > 0) {
            Node n = this.getNodeForRow(this.tree.getSelectionRows()[0]);
            VisibleVariable vv = Variables.forNode(n);
            if (vv != null) {
                vv.displayVariableDialog();
            } else {
                System.out.println(n + " is not a visible variable");
            }
        }
    }

    void showVariableEqns() {
        if (this.tree.getSelectionCount() > 0) {
            Node n = this.getNodeForRow(this.tree.getSelectionRows()[0]);
            VisibleVariable vv = Variables.forNode(n);
            if (vv != null) {
                vv.displayEqnsDialog();
            } else {
                System.out.println(n + " is not a visible variable");
            }
        }
    }

    void refreshNodes() {
        this.setupNodes();
        this.newValues();
    }

    void resetnodeval(ActionEvent e) {
        VisibleVariable vv = this.tryGetSelectedVariable();
        if (vv != null) {
            vv.initialise();
        }
    }

    class ScrollablePane
    extends JPanel
    implements Scrollable {
        ScrollablePane() {
        }

        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int o, int dir) {
            if (o == 1) {
                return visibleRect.height;
            }
            return visibleRect.width;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int o, int dir) {
            return 10;
        }
    }
}

