/*
 * Decompiled with CFR 0.152.
 */
package phic.gui;

import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Member;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import phic.Current;
import phic.common.ClassVisualiser;
import phic.gui.LimitedNode;
import phic.gui.MyRenderer;
import phic.gui.Node;

public class BodyTree
extends JPanel {
    DefaultMutableTreeNode root = new DefaultMutableTreeNode("HOM");
    public JTree tree = new JTree();
    ActionListener al = null;
    JScrollPane scrollpane = new JScrollPane();
    MyRenderer renderer = new MyRenderer();

    public void addActionListener(ActionListener a) {
        this.al = AWTEventMulticaster.add(this.al, a);
    }

    public void removeActionListener(ActionListener a) {
        this.al = AWTEventMulticaster.remove(this.al, a);
    }

    public BodyTree() {
        this.setLayout(new BorderLayout());
        this.setupNodes();
        this.renderer.setupIcons();
        this.scrollpane.getViewport().setView(this.tree);
        this.scrollpane.getVerticalScrollBar().setUnitIncrement(10);
        this.add(this.scrollpane);
        this.tree.setCellRenderer(this.renderer);
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Object o;
                int selRow = BodyTree.this.tree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = BodyTree.this.tree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getClickCount() == 2 && (o = selPath.getLastPathComponent()) instanceof Node) {
                    Node n = (Node)o;
                    String name = n.canonicalName();
                    if (BodyTree.this.al != null) {
                        BodyTree.this.al.actionPerformed(new ActionEvent(BodyTree.this.tree, 1001, name));
                    }
                }
            }
        });
    }

    public Node getNodeForRow(int row) {
        Object o = this.tree.getPathForRow(row).getLastPathComponent();
        if (o instanceof Node) {
            return (Node)o;
        }
        return null;
    }

    void setupNodes() {
        this.root.removeAllChildren();
        this.setupNodes(Current.environment, "Environment");
        this.setupNodes(Current.body, "Body");
        this.tree.setModel(new DefaultTreeModel(this.root));
    }

    void setupNodes(Object cn, String nn) {
        try {
            ClassVisualiser c = new ClassVisualiser(cn);
            c.name = nn;
            LimitedNode n = new LimitedNode((Member)c, this.root);
            this.root.add(n);
            c.createTree(n);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reload() {
        ((DefaultTreeModel)this.tree.getModel()).reload();
    }
}

