/*
 * Decompiled with CFR 0.152.
 */
package phic.ecg;

import phic.ecg.Axis;
import phic.ecg.Heart;

public class SimpleHeart
implements Heart {
    public double P_DELAY = 0.4;
    public double P_SIZE = 0.1;
    public double P_DURATION = 0.05;
    public double PR_INTERVAL = 0.2;
    public double QRS_SIZE = 1.5;
    public double QRS_WIDTH = 0.05;
    public double QT_INTERVAL = 0.2;
    public double ST_SEGMENT = 0.0;
    public double T_SIZE = 0.3;
    public double T_WIDTH = 0.2;
    public Axis T_AXIS = new Axis(1.3962634015954636, 0.6283185307179586);
    public Axis ST_AXIS = new Axis(1.0471975511965976, 0.0);
    public Axis QRS_AXIS = new Axis(0.9424777960769379, 0.6283185307179586);
    public Axis P_AXIS = new Axis(1.0471975511965976, 0.7853981633974483);
    double[][] field = this.createField();
    public double rate = 72.0;

    public double[][] createField() {
        Axis q_axis = new Axis(this.QRS_AXIS, 0.0, 0.0);
        return new double[][]{{0.0, 0.0, 0.0, this.P_DELAY}, this.P_AXIS.vector(this.P_SIZE, this.P_DURATION / 2.0), {0.0, 0.0, 0.0, this.P_DURATION / 2.0}, {0.0, 0.0, 0.0, this.PR_INTERVAL - this.P_DURATION}, q_axis.vector(this.QRS_SIZE, this.QRS_WIDTH / 3.0), this.QRS_AXIS.vector(-0.3 * this.QRS_SIZE, this.QRS_WIDTH / 3.0), this.ST_AXIS.vector(this.ST_SEGMENT, this.QRS_WIDTH / 3.0), this.ST_AXIS.vector(this.ST_SEGMENT, this.QT_INTERVAL - this.QRS_WIDTH), {this.T_SIZE * this.T_AXIS.x(), this.T_SIZE * this.T_AXIS.y(), this.T_SIZE * this.T_AXIS.z(), this.T_WIDTH / 2.0}, {0.0, 0.0, 0.0, this.T_WIDTH / 2.0}};
    }

    public double getRate() {
        return this.rate;
    }

    public double[][] getBeatsField(double time) {
        this.field = this.createField();
        double sBeat = 60.0 / this.rate;
        int n = 2 + (int)(time / sBeat);
        double[][] b = new double[this.field.length * n][4];
        double cumulativeTime = 0.0;
        int i = 0;
        while (i < b.length) {
            int j = 0;
            while (j < 3) {
                b[i][j] = this.field[i % this.field.length][j];
                ++j;
            }
            b[i][3] = cumulativeTime += sBeat * this.field[i % this.field.length][3];
            ++i;
        }
        return b;
    }
}

