/*
 * Decompiled with CFR 0.152.
 */
package phic.ecg;

import phic.Body;
import phic.ecg.Axis;
import phic.ecg.SimpleHeart;

public class PhicHeart
extends SimpleHeart {
    Body body;
    public double[][] ectopicField;
    public double[][] chbField;
    public double[][] afField;
    public double afWander = 0.04;
    public double afVar = 0.3;
    double pVE = 0.0;
    public static final int SINUS = 0;
    public static final int CHB = 2;
    public static final int AF = 4;
    public int rhythm = 0;

    public PhicHeart(Body body) {
        this.body = body;
        this.ectopicField = this.createEctopic();
        this.chbField = this.createEctopic();
        this.chbField[0][3] = 0.7;
        this.initialiseHeart();
        this.afField = this.createAF();
    }

    public double[][] createField() {
        this.initialiseHeart();
        return super.createField();
    }

    public double[][] createEctopic() {
        this.P_DELAY = 0.2;
        this.P_SIZE = 0.0;
        this.PR_INTERVAL = 0.1;
        this.QRS_SIZE = 2.4;
        this.QRS_AXIS = new Axis(-1.9477874452256718, -0.9424777960769379);
        this.QRS_WIDTH = 0.4;
        this.QT_INTERVAL = 0.5;
        this.ST_SEGMENT = 1.4;
        this.T_SIZE = 0.05;
        this.T_WIDTH = 0.2;
        return super.createField();
    }

    public double[][] createAF() {
        this.P_SIZE = 0.0;
        double[][] f = super.createField();
        int i = 0;
        while (i < f[0].length) {
            double[] dArray = f[i];
            dArray[0] = dArray[0] + (Math.random() * 2.0 - 1.0) * this.afWander;
            double[] dArray2 = f[i];
            dArray2[1] = dArray2[1] + (Math.random() * 2.0 - 1.0) * this.afWander;
            double[] dArray3 = f[i];
            dArray3[1] = dArray3[1] + (Math.random() * 2.0 - 1.0) * this.afWander;
            ++i;
        }
        return f;
    }

    public void initialiseHeart() {
        if (this.body == null) {
            return;
        }
        if (this.body.brain.getFeeling() == 3) {
            this.QRS_SIZE = 0.0;
            this.T_SIZE = 0.0;
            this.P_SIZE = 0.0;
            this.ST_SEGMENT = 0.0;
            return;
        }
        this.pVE = this.body.CVS.heart.pVE;
        this.rate = this.body.CVS.heart.rate.get();
        this.rhythm = this.body.blood.PK.get() < 0.002 ? 4 : 0;
        this.P_DELAY = 0.2;
        this.P_SIZE = 0.1;
        this.P_DURATION = 0.05;
        this.PR_INTERVAL = 0.2;
        double lvh = this.body.CVS.heart.LVH.getError();
        double rvstrain = Math.max(0.0, Math.min(1.0, this.body.CVS.heart.right.sysV.getError() * 20.0));
        this.QRS_SIZE = 1.5 + Math.min(Math.max((this.body.CVS.heart.right.atrialP.get() - 0.008) * 2000.0, 0.0), 1.0) + lvh;
        this.QRS_AXIS = new Axis(0.9424777960769379 - lvh * Math.PI / 2.0 + rvstrain * Math.PI / 2.0, 0.6283185307179586);
        this.QT_INTERVAL = 0.2;
        double plasmaK = this.body.blood.PK.getError();
        this.T_SIZE = 0.3 + Math.min(plasmaK * 500.0, 4.0);
        this.P_SIZE = 0.14 - plasmaK * 10.0;
        this.QRS_WIDTH = 0.05 + Math.max(0.0, plasmaK * 42.0);
        double ischaemia = this.body.CVS.heart.ischaemia.get();
        this.T_AXIS.phi = 1.3962634015954636 - Math.min(ischaemia / 0.008, 1.0) * Math.PI;
        this.T_AXIS.theta = 0.6283185307179586 - Math.min(ischaemia / 0.008, 1.0) * Math.PI;
        this.T_SIZE = 0.3;
        this.ST_SEGMENT = Math.min(ischaemia, 0.01) * -80.0;
    }

    public double[][] getBeatsField(double time) {
        this.field = this.createField();
        double sBeat = 60.0 / this.rate;
        double sEctopic = 0.35;
        int n = 2 + (int)(time / Math.min(sBeat, sEctopic));
        double[][] b = new double[this.field.length * n][4];
        double cumulativeTime = 0.0;
        int i = 0;
        int w = 0;
        while (w < n) {
            double beatDuration;
            double[][] beatData;
            if (Math.random() < this.pVE) {
                beatData = this.ectopicField;
                beatDuration = sEctopic;
            } else if (this.rhythm == 2) {
                beatData = this.chbField;
                beatDuration = 1.54;
            } else if (this.rhythm == 4) {
                beatData = this.afField;
                beatDuration = Math.max(0.2, sBeat + (Math.random() * 2.0 - 1.0) * this.afVar);
            } else {
                beatData = this.field;
                beatDuration = sBeat;
            }
            int k = 0;
            while (k < beatData.length) {
                int j = 0;
                while (j < 3) {
                    b[i][j] = beatData[k][j];
                    ++j;
                }
                b[i][3] = cumulativeTime += beatDuration * beatData[k][3];
                ++i;
                ++k;
            }
            ++w;
        }
        return b;
    }
}

