/*
 * Decompiled with CFR 0.152.
 */
package phic.ecg;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import phic.gui.GraphPaper;

public class Paper
extends GraphPaper {
    double largeSquaresPerSecond = 5.0;
    double largeSquaresPerVolt = 1.0;
    double pixelsPerSecond = 125.0;
    double pixelsPerVolt = 25.0;
    double traceTime = 1.0;
    double traceHeightVolts = 4.0;

    public Paper() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setBackground(Color.white);
        this.setFont(new Font("Dialog", 1, 12));
        this.setForeground(Color.red);
        this.setMajorX(1.0 / this.largeSquaresPerSecond);
        this.setMajorY(1.0 / this.largeSquaresPerVolt);
        this.setMinorX(1.0 / this.largeSquaresPerSecond / 5.0);
        this.setMinorY(1.0 / this.largeSquaresPerVolt / 5.0);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                Paper.this.this_componentResized(e);
            }
        });
    }

    void this_componentResized(ComponentEvent e) {
        this.internalResize = true;
        this.traceTime = (double)this.getWidth() / this.pixelsPerSecond;
        this.setXRange(0.0, this.traceTime);
        this.traceHeightVolts = (double)this.getHeight() / this.pixelsPerVolt;
        this.setYRange(0.0, this.traceHeightVolts);
        this.internalResize = false;
    }

    public double getPixelsPerSecond() {
        return this.pixelsPerSecond;
    }

    public void setPixelsPerSecond(double pixelsPerSecond) {
        this.pixelsPerSecond = pixelsPerSecond;
    }
}

