/*
 * Decompiled with CFR 0.152.
 */
package phic.ecg;

import phic.ecg.Axis;

public class Lead {
    double x;
    double y;
    double z;
    public String name;

    public Lead() {
    }

    public Lead(double positionX, double positionY, double positionZ, String name) {
        this.x = positionX;
        this.y = positionY;
        this.z = positionZ;
        this.name = name;
    }

    public Lead(double theta, double phi, String name) {
        this(new Axis(theta, phi), name);
    }

    public Lead(Axis a, String name) {
        this.x = a.x();
        this.y = a.y();
        this.z = a.z();
        this.name = name;
    }

    double resolve(double[] v) {
        double magn = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        double dot = v[0] * this.x + v[1] * this.y + v[2] * this.z;
        return dot / magn;
    }

    public double[][] getPoints(double[][] field) {
        double[][] p = new double[field.length][2];
        int i = 0;
        while (i < field.length) {
            double[] v = new double[]{field[i][0], field[i][1], field[i][2]};
            p[i][0] = field[i][3];
            p[i][1] = this.resolve(v);
            ++i;
        }
        return p;
    }
}

