/*
 * Decompiled with CFR 0.152.
 */
package phic.drug;

import java.util.HashMap;
import java.util.Map;
import phic.common.Container;
import phic.common.IniReader;
import phic.doctor.DrugParser;
import phic.drug.Drug;
import phic.drug.DrugContainer;
import phic.drug.DrugQuantity;
import phic.drug.NoSuchDrugException;

public class Pharmacy {
    protected static IniReader drugFile = new IniReader("Pharmacy.txt");
    static Map userDefinedDrugs = new HashMap();

    public static DrugContainer dispenseDrug(String drugName, double volume, double concentration) throws NoSuchDrugException {
        DrugContainer c = new DrugContainer();
        c.volume.set(volume);
        DrugQuantity d = new DrugQuantity(c);
        Pharmacy.setDrugFromFile(drugName, d);
        d.setC(concentration);
        c.drugqs.add(d);
        return c;
    }

    public static DrugContainer dispenseAmpoule(String drugName, double quantity) throws NoSuchDrugException {
        DrugContainer ampoule = new DrugContainer();
        ampoule.volume.set(0.005);
        DrugQuantity drugq = new DrugQuantity(ampoule);
        Pharmacy.setDrugFromFile(drugName, drugq);
        drugq.setQ(quantity);
        ampoule.drugqs.add(drugq);
        return ampoule;
    }

    public static Container dispenseSubstance(String substanceToParse) throws NoSuchDrugException {
        return DrugParser.createSubstance(substanceToParse);
    }

    public static Container dispense(String substanceToParse) throws NoSuchDrugException {
        return DrugParser.createSubstance(substanceToParse);
    }

    public static Container get(String substanceToParse) throws NoSuchDrugException {
        return Pharmacy.dispenseSubstance(substanceToParse);
    }

    public static DrugContainer addDrugToContainer(String drugName, double quantity, Container container) throws NoSuchDrugException {
        DrugContainer c;
        if (container instanceof DrugContainer) {
            c = (DrugContainer)container;
        } else {
            c = new DrugContainer();
            c.add(container);
        }
        DrugQuantity drugq = new DrugQuantity(c);
        Pharmacy.setDrugFromFile(drugName, drugq);
        drugq.setQ(quantity);
        c.drugqs.add(drugq);
        return c;
    }

    protected static void setDrugFromFile(String drugName, DrugQuantity drug) throws NoSuchDrugException {
        Map map;
        if (Pharmacy.setDrugFromDefinitions(drugName, drug)) {
            return;
        }
        try {
            map = drugFile.getSectionMap(drugName);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchDrugException("Can't find drug " + drugName);
        }
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            if (!(value instanceof Double)) continue;
            drug.setProperty(key, (Double)value);
        }
        drug.setName(drugName.intern());
        String u = (String)map.get("Unit");
        if (u != null) {
            if (u.equals("g")) {
                drug.setUnit(21);
            } else if (u.equals("mol")) {
                drug.setUnit(14);
            } else if (u.equals("U")) {
                drug.setUnit(24);
            }
        }
    }

    public static void defineDrug(String name, Drug drug) {
        userDefinedDrugs.put(name, drug);
    }

    public static boolean setDrugFromDefinitions(String drugName, DrugQuantity drug) {
        boolean found = false;
        for (String dname : userDefinedDrugs.keySet()) {
            Drug d = (Drug)userDefinedDrugs.get(dname);
            if (!dname.toString().equalsIgnoreCase(drugName)) continue;
            found = true;
            for (Object key : d.getKnownProperties()) {
                drug.setProperty(key, d.getProperty(key));
            }
            drug.setName(drugName.intern());
            drug.setUnit(24);
            break;
        }
        return found;
    }

    public static Map getMapFromDefinitions(String drugName) {
        boolean found = false;
        Drug d = (Drug)userDefinedDrugs.get(drugName);
        if (d == null) {
            return null;
        }
        HashMap<String, Double> m = new HashMap<String, Double>();
        for (String prop : d.getKnownProperties()) {
            m.put(prop, new Double(d.getProperty(prop)));
        }
        return m;
    }

    public static Map getDrugMap(String drugName) throws NoSuchDrugException {
        Map map = Pharmacy.getMapFromDefinitions(drugName);
        if (map != null) {
            return map;
        }
        try {
            map = drugFile.getSectionMap(drugName);
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchDrugException("Can't find drug " + drugName);
        }
        return map;
    }

    public static String[] getDrugList() {
        String[] s = drugFile.getSectionHeaders();
        int n = userDefinedDrugs.size();
        if (n == 0) {
            return s;
        }
        String[] s2 = new String[s.length + n];
        int i = 0;
        while (i < s.length) {
            s2[i] = s[i];
            ++i;
        }
        int j = 0;
        for (String name : userDefinedDrugs.keySet()) {
            s2[j++ + s.length] = ((Drug)userDefinedDrugs.get(name)).toString();
        }
        return s2;
    }

    public static String getDrugDescription(String drugName) throws NoSuchDrugException {
        Map map = Pharmacy.getDrugMap(drugName);
        Object o = map.get("Description");
        String d = o != null ? o.toString() : "No description";
        return d;
    }

    public static int getDrugUnit(String drugName) throws NoSuchDrugException {
        Map map = Pharmacy.getDrugMap(drugName);
        Object o = map.get("Unit");
        if (o != null) {
            if (o.equals("g")) {
                return 3;
            }
            if (o.equals("U")) {
                return 25;
            }
            if (o.equals("mol")) {
                return 22;
            }
            throw new RuntimeException("Bad unit '" + o.toString() + "' for drug " + drugName);
        }
        return 3;
    }

    public static double getSingleDrugDose(String drugName) throws NoSuchDrugException {
        Map map = Pharmacy.getDrugMap(drugName);
        Object o = map.get("SINGLE_DOSE");
        if (o instanceof Double) {
            return (Double)o;
        }
        return 0.001;
    }
}

