/*
 * Decompiled with CFR 0.152.
 */
package phic.drug;

import java.util.Collection;
import java.util.HashMap;
import phic.common.Quantity;
import phic.common.UnitConstants;
import phic.drug.Drug;
import phic.drug.DrugContainer;

public class DrugQuantity
extends Quantity
implements Drug,
Cloneable {
    protected String name;
    protected HashMap properties = new HashMap();

    public DrugQuantity(DrugContainer c) {
        super(c);
        this.unit = 21;
    }

    public DrugQuantity(DrugContainer c, DrugQuantity typeOfDrug) {
        super(c);
        this.unit = 21;
        this.properties = typeOfDrug.properties;
        this.name = typeOfDrug.name;
        this.maximum = typeOfDrug.getProperty("SINGLE_DOSE") / 15.0;
    }

    public String getName() {
        return this.name;
    }

    void setName(String s) {
        this.name = s;
    }

    public boolean isSameDrug(DrugQuantity q) {
        return q.name == this.name;
    }

    public double getProperty(Object key) {
        Object value = this.properties.get(key);
        if (value != null) {
            return (Double)value;
        }
        return 0.0;
    }

    public Collection getKnownProperties() {
        return this.properties.keySet();
    }

    void setProperty(Object key, double value) {
        this.properties.put(key, new Double(value));
    }

    public String toString() {
        return String.valueOf(this.name) + " " + UnitConstants.formatValue(this.get(), this.unit, false);
    }

    public void setUnit(int unit) {
        this.unit = unit;
    }
}

