/*
 * Decompiled with CFR 0.152.
 */
package phic.drug;

import java.util.Vector;
import phic.common.Container;
import phic.drug.DrugQuantity;

public class DrugContainer
extends Container {
    public Vector drugqs = new Vector();

    protected final DrugQuantity dq(int i) {
        return (DrugQuantity)this.drugqs.get(i);
    }

    public final double getDrugBinding(Object property) {
        double activity = 0.0;
        int i = 0;
        while (i < this.drugqs.size()) {
            DrugQuantity d = this.dq(i);
            activity += d.getProperty(property) * d.get();
            ++i;
        }
        return activity;
    }

    public Container withdrawVol(double volume) {
        DrugContainer c = new DrugContainer();
        c.add(super.withdrawVol(volume));
        int i = 0;
        while (i < this.drugqs.size()) {
            c.addDrug(this.dq(i), this.dq(i).getC());
            ++i;
        }
        return c;
    }

    public void withdrawVol_overwrite(double volume, Container into) {
        super.withdrawVol_overwrite(volume, into);
        if (into instanceof DrugContainer) {
            DrugContainer dinto = (DrugContainer)into;
            dinto.drugqs.removeAllElements();
            int i = 0;
            while (i < this.drugqs.size()) {
                dinto.addDrug(this.dq(i), this.dq(i).getC());
                ++i;
            }
        }
    }

    public void withdrawFrac_overwrite(double fraction, DrugContainer into) {
        double frac = Math.max(Math.min(fraction, 1.0), 0.0);
        this.withdrawVol_overwrite(this.vol * frac, into);
    }

    public void ultraFiltrate_overwrite(double volume, DrugContainer into) {
        this.withdrawVol_overwrite(volume, into);
        into.filterSolidsInto(this);
        into.prot.moveTo(this.prot);
    }

    protected DrugQuantity addDrug(DrugQuantity typeOfDrug, double concentration) {
        DrugQuantity d = new DrugQuantity(this, typeOfDrug);
        d.setC(concentration);
        this.drugqs.add(d);
        return d;
    }

    public synchronized void increaseVolume(double volume) {
        double cfrac = (volume = Math.max(volume, -this.vol)) + this.vol <= 0.0 ? 0.0 : this.vol / (this.vol + volume);
        super.increaseVolume(volume);
        int i = 0;
        while (i < this.drugqs.size()) {
            this.dq(i).multiplyC(cfrac);
            ++i;
        }
    }

    public final DrugQuantity findMatchingDrug(DrugQuantity toMatch) {
        int j = 0;
        while (j < this.drugqs.size()) {
            if (toMatch.isSameDrug(this.dq(j))) {
                return this.dq(j);
            }
            ++j;
        }
        return null;
    }

    public final DrugQuantity findOrCreateMatchingDrug(DrugQuantity toMatch) {
        DrugQuantity t = this.findMatchingDrug(toMatch);
        if (t != null) {
            return t;
        }
        return this.addDrug(toMatch, 0.0);
    }

    public void add(DrugContainer from) {
        DrugContainer lock1 = this;
        DrugContainer lock2 = from;
        if (this.hashCode() > from.hashCode()) {
            lock1 = from;
        }
        lock2 = this;
        this.increaseVolume(from.vol);
        int n = this.compatibleQSize(from);
        int i = 0;
        while (i < n) {
            this.substance(i).addQ(from.substance(i).getQ());
            from.substance(i).setQ(0.0);
            ++i;
        }
        i = 0;
        while (i < from.drugqs.size()) {
            boolean found = false;
            int j = 0;
            while (j < this.drugqs.size()) {
                if (from.dq(i).isSameDrug(this.dq(j))) {
                    this.dq(j).addQ(from.dq(i).getQ());
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                this.addDrug(from.dq(i), from.dq(i).getQ() / this.volume.get());
            }
            from.dq(i).setQ(0.0);
            ++i;
        }
        from.vol = 0.0;
    }

    public void add(Container from) {
        if (from instanceof DrugContainer) {
            this.add((DrugContainer)from);
        } else {
            super.add(from);
        }
    }

    public void add(Container from, double volume) {
        if (volume < 0.0 && this.solids.getC() > Math.abs(volume)) {
            throw new RuntimeException("Withdrawal of " + Math.abs(volume) + "L from " + this.vol + "L, " + this.solids.getQ() + " of which is solids.");
        }
        boolean fromDrug = from instanceof DrugContainer;
        if (fromDrug) {
            throw new RuntimeException("A DrugContainer has called add(DrugContainer,volume). Please use withdrawVol() then add() instead.");
        }
        Container lock1 = this;
        Container lock2 = from;
        if (this.hashCode() > from.hashCode()) {
            lock1 = from;
        }
        lock2 = this;
        double fromvol = from.volume.get();
        volume = Math.min(volume, fromvol);
        double p = volume / fromvol;
        int i = 0;
        while (i < this.qs.size()) {
            double t = p * from.substance(i).getQ();
            if (p < 0.0) {
                t = Math.max(t, -this.substance(i).getQ());
            }
            this.substance(i).setC((this.substance(i).getQ() + t) / (this.vol + volume));
            from.substance(i).setC((from.substance(i).getQ() - t) / (fromvol - volume));
            ++i;
        }
        Vector<DrugQuantity> fromFound = new Vector<DrugQuantity>();
        int i2 = 0;
        while (i2 < this.drugqs.size()) {
            DrugQuantity thisq = (DrugQuantity)this.drugqs.get(i2);
            double t = 0.0;
            if (fromDrug) {
                DrugContainer fromd = (DrugContainer)from;
                int j = 0;
                while (j < fromd.drugqs.size()) {
                    DrugQuantity fromq = (DrugQuantity)fromd.drugqs.get(j);
                    if (thisq.isSameDrug(fromq)) {
                        t = p * fromq.getQ();
                        if (p < 0.0) {
                            t = Math.max(t, -thisq.getQ());
                        }
                        fromq.setC((fromq.getQ() - t) / (fromvol - volume));
                        fromFound.add(fromq);
                        break;
                    }
                    ++j;
                }
            }
            thisq.setC((thisq.getQ() + t) / (this.vol + volume));
            ++i2;
        }
        if (fromDrug && p > 0.0) {
            DrugContainer fromd = (DrugContainer)from;
            int i3 = 0;
            while (i3 < fromd.drugqs.size()) {
                DrugQuantity fromq = (DrugQuantity)fromd.drugqs.get(i3);
                if (!fromFound.contains(fromq)) {
                    this.addDrug(fromq, p * fromq.getQ() / (this.vol + volume));
                }
                ++i3;
            }
        }
        from.volume.set(fromvol - volume);
        this.vol += volume;
    }

    public void empty() {
        super.empty();
        this.drugqs.removeAllElements();
    }

    public void set(Container from) {
        super.set(from);
        this.drugqs.removeAllElements();
        if (from instanceof DrugContainer) {
            DrugContainer d = (DrugContainer)from;
            int i = 0;
            while (i < d.drugqs.size()) {
                ++i;
            }
        }
    }

    protected double getOsmolarity() {
        return this.H.getC() + this.glucose.getC() + this.urea.getC() + this.prot.getC() + 2.0 * this.Na.getC() + 2.0 * this.K.getC() + this.getDrugBinding("OSMOTIC_EFFECT");
    }
}

