/*
 * Decompiled with CFR 0.152.
 */
package phic.drug;

import phic.drug.ContainerInterface;

public abstract class AbstractContainer
implements ContainerInterface {
    public abstract void set(ContainerInterface var1);

    public abstract ContainerInterface withdrawVol(double var1);

    public ContainerInterface withdrawFrac(double fraction) {
        double frac = Math.max(Math.min(fraction, 1.0), 0.0);
        return this.withdrawVol(this.getVolume() * frac);
    }

    public void add(ContainerInterface from) {
    }

    public void add(ContainerInterface from, double volume) {
        this.add(from.withdrawVol(volume));
    }

    public abstract ContainerInterface withdrawVol(ContainerInterface var1);

    public abstract ContainerInterface withdrawFrac(ContainerInterface var1, double var2);

    public abstract ContainerInterface filterSolids();

    public abstract ContainerInterface ultraFiltrate(double var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void osmose(ContainerInterface to, double osmolarity, double frac) {
        ContainerInterface lock1 = this;
        ContainerInterface lock2 = to;
        if (this.hashCode() > to.hashCode()) {
            lock1 = to;
        }
        lock2 = this;
        double transf = (osmolarity - this.getOsmolarity()) * this.getVolume() / osmolarity;
        transf *= frac;
        transf = Math.max(transf, -to.getVolume());
        ContainerInterface containerInterface = lock1;
        synchronized (containerInterface) {
            ContainerInterface containerInterface2 = lock2;
            synchronized (containerInterface2) {
                to.addWater(transf);
                this.addWater(-transf);
            }
        }
    }

    public abstract void empty();

    protected abstract void setVolume(double var1);

    public abstract double getOsmolarity();

    public abstract double pH();
}

