/*
 * Decompiled with CFR 0.152.
 */
package phic.doctor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import phic.Resource;
import phic.common.Clock;
import phic.doctor.ClockPanel;
import phic.doctor.IFrame;

public class TimeControl
extends IFrame {
    Object[] ffwdNames = new Object[]{"1 minute", "1 hour", "1 day", "1 week"};
    double[] ffwdTimes = new double[]{60.0, 3600.0, 86400.0, 0.0};
    ImageIcon iplay = new ImageIcon(Resource.loader.getImageResource("Play.gif"));
    ImageIcon iffwd = new ImageIcon(Resource.loader.getImageResource("FastForward.gif"));
    private JPanel jPanel1 = new JPanel();
    private JToggleButton jButton1 = new JToggleButton();
    private JPanel jPanel2 = new JPanel();
    private JToggleButton ffwdbutton = new JToggleButton();
    private TitledBorder titledBorder1;
    private JComboBox ffwdtime = new JComboBox();
    private DefaultComboBoxModel ffwdlistmodel = new DefaultComboBoxModel<Object>(this.ffwdNames);
    JProgressBar ffwdProgress = new JProgressBar();
    double previousSecond = 1000.0;
    long startTime;
    long maxWait;
    double fastMillisPerSecond = 1.0;
    Timer timer = new Timer(50, new ActionListener(){
        Clock c;

        public void actionPerformed(ActionEvent e) {
            if (this.c == null) {
                this.c = TimeControl.this.getClock();
            }
            long t = this.c.getTime() - TimeControl.this.startTime;
            TimeControl.this.ffwdProgress.setValue((int)(100L * t / TimeControl.this.maxWait));
            TimeControl.this.updateDisplay();
            if (t > TimeControl.this.maxWait) {
                TimeControl.this.stopFastForwarding();
            }
        }
    });
    JLabel timelabel = new JLabel();
    private ClockPanel clockPanel1 = new ClockPanel();

    public TimeControl() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.pack();
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(), "Fast forward");
        this.jButton1.setText("");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TimeControl.this.jButton1_actionPerformed(e);
            }
        });
        this.jButton1.setToolTipText("Start or stop the clock");
        this.jButton1.setIcon(this.iplay);
        this.jButton1.setSelected(true);
        this.ffwdbutton.setIcon(this.iffwd);
        this.setTitle("Time");
        this.ffwdbutton.setToolTipText("Fast forward the clock");
        this.ffwdbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TimeControl.this.ffwdbutton_actionPerformed(e);
            }
        });
        this.jPanel2.setBorder(this.titledBorder1);
        this.ffwdtime.setToolTipText("Amount of time to fast forward by");
        this.ffwdtime.setModel(this.ffwdlistmodel);
        this.ffwdProgress.setPreferredSize(new Dimension(60, 14));
        this.ffwdProgress.setToolTipText("Fast forward progress");
        this.timelabel.setToolTipText("Current time");
        this.timelabel.setText("01 Januarymmm 1980 01:01:01");
        this.clockPanel1.setPreferredSize(new Dimension(40, 40));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.timelabel, null);
        this.jPanel1.add((Component)this.jButton1, null);
        this.jPanel1.add((Component)this.jPanel2, null);
        this.jPanel2.add((Component)this.clockPanel1, null);
        this.jPanel2.add((Component)this.ffwdbutton, null);
        this.jPanel2.add((Component)this.ffwdtime, null);
        this.jPanel2.add((Component)this.ffwdProgress, null);
    }

    Clock getClock() {
        if (this.frame != null && this.frame.person != null) {
            return this.frame.person.body.getClock();
        }
        return null;
    }

    void jButton1_actionPerformed(ActionEvent e) {
        if (this.jButton1.isSelected()) {
            this.getClock().start();
        } else {
            this.getClock().stop();
        }
    }

    void ffwdbutton_actionPerformed(ActionEvent e) {
        if (this.ffwdbutton.isSelected()) {
            Clock c = this.getClock();
            this.maxWait = (long)(this.ffwdTimes[this.ffwdtime.getSelectedIndex()] * 1000.0);
            this.startTime = c.getTime();
            this.previousSecond = c.getSecond();
            c.setSecond(this.fastMillisPerSecond);
            this.timer.start();
        } else {
            this.stopFastForwarding();
        }
    }

    void stopFastForwarding() {
        this.getClock().setSecond(this.previousSecond);
        this.timer.stop();
        this.ffwdProgress.setValue(0);
        this.ffwdbutton.setSelected(false);
    }

    public void updateDisplay() {
        Clock c = this.getClock();
        if (c != null) {
            this.timelabel.setText(c.getTimeString(0));
            this.clockPanel1.updateClock(c.getTime());
        }
    }
}

