/*
 * Decompiled with CFR 0.152.
 */
package phic.doctor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import phic.Resource;
import phic.common.Container;
import phic.common.IniReader;
import phic.doctor.DrugParser;
import phic.drug.NoSuchDrugException;

public class SelectionFrame
extends JPanel {
    private BorderLayout borderLayout1 = new BorderLayout();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JPanel listpanel = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private Box listbox;
    ButtonGroup bg = new ButtonGroup();
    String[] images;
    String[] names;
    Item[] items;
    public boolean horizontal = false;
    Map[] substanceMap;

    public SelectionFrame() {
        this.init();
    }

    public SelectionFrame(boolean horizontal) {
        this.horizontal = horizontal;
        this.init();
    }

    public SelectionFrame(String[] images, String[] names) {
        this.init();
        this.setupImages(images, names);
    }

    public void setupImages(String[] images, String[] names) {
        this.images = images;
        this.names = names;
        this.items = new Item[names.length];
        this.bg = new ButtonGroup();
        this.listbox.removeAll();
        int i = 0;
        while (i < images.length) {
            Image m = null;
            try {
                m = Resource.loader.getImageResource(images[i]);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load image resource " + images[i] + ": " + e.getMessage());
            }
            this.items[i] = new Item(m, names[i]);
            this.items[i].setFont(this.items[i].getFont().deriveFont(1));
            this.bg.add(this.items[i]);
            this.listbox.add(this.items[i]);
            ++i;
        }
    }

    void init() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.listbox = this.horizontal ? Box.createHorizontalBox() : Box.createVerticalBox();
        this.setLayout(this.borderLayout1);
        if (this.horizontal) {
            this.jScrollPane1.setVerticalScrollBarPolicy(21);
        } else {
            this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        }
        this.listpanel.setLayout(this.borderLayout2);
        this.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.listpanel, null);
        this.listpanel.add((Component)this.listbox, "Center");
    }

    public void setupFromSection(IniReader ir, String section) {
        this.names = ir.getSectionStrings(section);
        String[] imageNames = new String[this.names.length];
        this.substanceMap = new Map[this.names.length];
        int i = 0;
        while (i < this.names.length) {
            this.substanceMap[i] = ir.getSectionMap(this.names[i]);
            imageNames[i] = (String)this.substanceMap[i].get("Image");
            if (imageNames[i] == null) {
                throw new NullPointerException("Cannot find image name for " + this.names[i]);
            }
            ++i;
        }
        this.setupImages(imageNames, this.names);
    }

    String[] getNames() {
        return this.names;
    }

    String getSelectedName() {
        return this.names[this.getSelectedIndex()];
    }

    int getSelectedIndex() {
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i].isSelected()) {
                return i;
            }
            ++i;
        }
        throw new IllegalStateException("No selection made");
    }

    Map getSelectedMap() {
        return this.substanceMap[this.getSelectedIndex()];
    }

    Container getSelectedSubstance() throws NoSuchDrugException {
        Map m = this.getSelectedMap();
        Container c = new Container();
        String s = (String)m.get("Fluid");
        if (s != null) {
            c.add(DrugParser.createSubstance(s));
        }
        if ((s = (String)m.get("Drug")) != null) {
            c.add(DrugParser.createSubstance(s));
        }
        return c;
    }

    Image getSelectedImage() {
        return this.items[this.getSelectedIndex()].image;
    }

    class Item
    extends JToggleButton {
        String text;
        Image image;

        Item(Image m, String s) {
            super(new ImageIcon(m));
            this.text = s;
            this.image = m;
            this.setBorder(null);
            this.setToolTipText(s);
        }

        public void paint(Graphics g) {
            g.drawImage(this.image, 0, 0, this);
            g.setColor(Color.white);
            g.drawString(this.text, 2, this.getHeight() - 9);
            g.setColor(this.getForeground());
            g.drawString(this.text, 1, this.getHeight() - 10);
            if (this.isSelected()) {
                g.setColor(Color.red);
                g.draw3DRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, true);
                g.draw3DRect(1, 1, this.getWidth() - 3, this.getHeight() - 3, false);
            }
        }
    }
}

