/*
 * Decompiled with CFR 0.152.
 */
package phic.doctor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.geom.Point2D;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import phic.Person;
import phic.doctor.IFrame;
import phic.gui.GraphPaper;

public class ObservationsChart
extends IFrame
implements Runnable {
    Person person;
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JPanel chart = new JPanel();
    private Box box1;
    private Box box2;
    private FlowLayout flowLayout1 = new FlowLayout();
    public boolean antialiasing = true;
    private GraphPaper tempchart = new GraphPaper(){

        public void paint(Graphics g) {
            super.paint(g);
            Point op = null;
            if (ObservationsChart.this.antialiasing) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            g.setColor(Color.black);
            g.drawString("T", 20, 10);
            int i = 0;
            while (i < ObservationsChart.this.observations.size()) {
                Observations o = (Observations)ObservationsChart.this.observations.get(i);
                Point p = this.toScreen(new Point2D.Double(o.time, o.temp));
                if (i > 0) {
                    g.drawLine(op.x, op.y, p.x, p.y);
                }
                op = p;
                ++i;
            }
        }
    };
    private GraphPaper rrchart = new GraphPaper(){

        public void paint(Graphics g) {
            super.paint(g);
            if (ObservationsChart.this.antialiasing) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            g.setColor(Color.black);
            g.drawString("RR", 20, 10);
            Point op = null;
            int i = 0;
            while (i < ObservationsChart.this.observations.size()) {
                Observations o = (Observations)ObservationsChart.this.observations.get(i);
                Point p = this.toScreen(new Point2D.Double(o.time, o.resp));
                if (i > 0) {
                    g.drawLine(op.x, op.y, p.x, p.y);
                }
                op = p;
                ++i;
            }
            int n = 1 + (int)((this.maxx - this.minx) / this.majorx);
            int i2 = 0;
            while (i2 < n) {
                int hour = (int)((long)(this.minx + (double)i2 * this.majorx) % 24L);
                int x = this.xS(this.minx + (double)i2 * this.majorx);
                g.drawString(String.valueOf(hour), x, this.getHeight() - 10);
                ++i2;
            }
        }
    };
    private int h = 4;
    private GraphPaper bppchart = new GraphPaper(){

        public void paint(Graphics g) {
            super.paint(g);
            if (ObservationsChart.this.antialiasing) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            g.setColor(Color.blue);
            g.drawString("BP", 20, 10);
            g.setColor(Color.black);
            g.drawString("HR", 20, 20);
            Point op = null;
            int i = 0;
            while (i < ObservationsChart.this.observations.size()) {
                Observations o = (Observations)ObservationsChart.this.observations.get(i);
                Point p = this.toScreen(new Point2D.Double(o.time, o.pulse));
                Point s = this.toScreen(new Point2D.Double(o.time, o.systolic));
                Point d = this.toScreen(new Point2D.Double(o.time, o.diastolic));
                if (i > 0) {
                    g.setColor(Color.black);
                    g.drawLine(op.x, op.y, p.x, p.y);
                }
                g.setColor(Color.blue);
                g.drawLine(s.x - ObservationsChart.this.h, s.y - ObservationsChart.this.h, s.x, s.y);
                g.drawLine(s.x + ObservationsChart.this.h, s.y - ObservationsChart.this.h, s.x, s.y);
                g.drawLine(d.x - ObservationsChart.this.h, d.y + ObservationsChart.this.h, d.x, d.y);
                g.drawLine(d.x + ObservationsChart.this.h, d.y + ObservationsChart.this.h, d.x, d.y);
                op = p;
                ++i;
            }
        }
    };
    private double startTime = 0.0;
    private double initialX;
    public Vector observations = new Vector();
    final int pixelsPerHour = 80;
    long historyLength = 24L;
    protected boolean destroy = false;
    public final int minutesBetweenObservations = 15;
    protected Thread observationThread = new Thread((Runnable)this, "Observations");

    public ObservationsChart(Person p) {
        if (p == null) {
            throw new NullPointerException("Null person supplied to observations chart");
        }
        this.person = p;
        this.init();
        this.observationThread.start();
    }

    public ObservationsChart() {
        this.init();
    }

    public final Observations observations(int n) {
        return (Observations)this.observations.get(n);
    }

    public void observe() {
        Observations now = new Observations(this.person);
        this.observations.add(now);
        Observations first = this.observations(0);
        while (now.time - first.time > (double)this.historyLength) {
            this.observations.remove(0);
            first = this.observations(0);
        }
        double min = first.time;
        double max = now.time;
        if (min == max) {
            min = max - 1.0;
        }
        this.tempchart.setXRange(min, max);
        this.bppchart.setXRange(min, max);
        this.rrchart.setXRange(min, max);
        int width = (int)((max - min) * 80.0);
        this.tempchart.setPreferredSize(new Dimension(width, this.tempchart.getPreferredSize().height));
        this.bppchart.setPreferredSize(new Dimension(width, this.bppchart.getPreferredSize().height));
        this.rrchart.setPreferredSize(new Dimension(width, this.rrchart.getPreferredSize().height));
        this.invalidate();
        this.repaint();
    }

    private void init() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tempchart.setYRange(35.0, 42.0);
        this.bppchart.setYRange(50.0, 160.0);
        this.rrchart.setYRange(8.0, 40.0);
        this.setSize(400, 400);
    }

    private void jbInit() throws Exception {
        this.box1 = Box.createVerticalBox();
        this.box2 = Box.createHorizontalBox();
        this.setTitle("Observations");
        this.chart.setLayout(this.flowLayout1);
        this.tempchart.setBackground(SystemColor.window);
        this.tempchart.setForeground(Color.red);
        this.tempchart.setDrawYLabels(true);
        this.bppchart.setBackground(SystemColor.window);
        this.bppchart.setForeground(Color.red);
        this.bppchart.setDrawYLabels(true);
        this.rrchart.setBackground(SystemColor.window);
        this.rrchart.setForeground(Color.red);
        this.rrchart.setDrawYLabels(true);
        this.jScrollPane1.setVerticalScrollBarPolicy(21);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.box2, null);
        this.box2.add((Component)this.box1, null);
        this.box1.add((Component)this.tempchart, null);
        this.box1.add((Component)this.bppchart, null);
        this.box1.add((Component)this.rrchart, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (this.person == null) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Object waiter = new Object();
        while (!this.destroy) {
            try {
                Object object = waiter;
                synchronized (object) {
                    this.person.body.getClock().requestNotifyAfter(900.0, waiter);
                    waiter.wait();
                }
                this.observe();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class Observations {
        int pulse;
        int resp;
        int systolic;
        int diastolic;
        int consc;
        double time;
        double temp;

        Observations(Person p) {
            this.temp = p.body.Temp.get();
            this.pulse = (int)p.body.CVS.heart.rate.get();
            this.resp = (int)p.body.lungs.RespR.get();
            this.systolic = (int)(1000.0 * p.body.CVS.SysBP.get());
            this.diastolic = (int)(1000.0 * p.body.CVS.DiaBP.get());
            this.consc = p.body.brain.getFeeling();
            this.time = ObservationsChart.this.person.body.getClock().getTime() / 60000L;
            this.time = (double)((int)(this.time / 15.0)) / 4.0;
        }
    }
}

