/*
 * Decompiled with CFR 0.152.
 */
package phic.doctor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import phic.IntravenousInfusion;

public class InfusionPanel
extends JPanel {
    private JPopupMenu jPopupMenu1 = new JPopupMenu();
    private JMenuItem jMenuItem1 = new JMenuItem();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel centrepanel = new JPanel();
    private JPanel sliderpanel = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JSlider rateSlider = new JSlider();
    private JPanel jPanel1 = new JPanel();
    private JLabel jLabel1 = new JLabel();
    private JSlider volumeSlider = new JSlider();
    private BorderLayout borderLayout3 = new BorderLayout();
    private JLabel jLabel2 = new JLabel();
    private BorderLayout borderLayout4 = new BorderLayout();
    public JLabel contentLabel = new JLabel();
    private Border border1;
    JPanel picturepanel = new JPanel(){

        public void paint(Graphics g) {
            super.paint(g);
            if (InfusionPanel.this.image != null) {
                g.drawImage(InfusionPanel.this.image, 0, 0, this);
            }
        }
    };
    Image image = null;
    IntravenousInfusion infusion;
    private JLabel jLabel3 = new JLabel();
    private JLabel jLabel4 = new JLabel();

    public void paint(Graphics g) {
        Color bg = this.getBackground();
        g.setColor(new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 128));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paint(g);
    }

    public InfusionPanel() {
        this.init();
    }

    public void setup(IntravenousInfusion ivi, String infusionName, Image image) {
        this.infusion = ivi;
        this.image = image;
        this.contentLabel.setText(infusionName);
        this.contentLabel.setToolTipText(infusionName);
        this.volumeSlider.setMaximum(ivi.defaultStartVolume * 1000);
        this.rateSlider.setValue((int)(1.0 / (60.0 * ivi.rate)));
        this.updateFullness();
    }

    void init() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setOpaque(false);
    }

    void updateFullness() {
        if (this.infusion != null) {
            double v = this.infusion.volume.get();
            this.volumeSlider.setValue((int)(v * 1000.0));
        }
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.jMenuItem1.setText("Stop infusion");
        this.setLayout(this.borderLayout1);
        this.sliderpanel.setLayout(this.borderLayout2);
        this.rateSlider.setOrientation(1);
        this.rateSlider.setMajorTickSpacing(6);
        this.rateSlider.setMaximum(18);
        this.rateSlider.setMinorTickSpacing(2);
        this.rateSlider.setPaintLabels(true);
        this.rateSlider.setPaintTicks(true);
        this.rateSlider.setOpaque(false);
        this.rateSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                InfusionPanel.this.rateSlider_stateChanged(e);
            }
        });
        this.jLabel1.setText("Rate");
        this.volumeSlider.setOrientation(1);
        this.volumeSlider.setMajorTickSpacing(200);
        this.volumeSlider.setMaximum(1000);
        this.volumeSlider.setMinorTickSpacing(100);
        this.volumeSlider.setPaintLabels(true);
        this.volumeSlider.setPaintTicks(true);
        this.volumeSlider.setEnabled(false);
        this.volumeSlider.setOpaque(false);
        this.jPanel1.setLayout(this.borderLayout3);
        this.jLabel2.setText("Volume");
        this.centrepanel.setLayout(this.borderLayout4);
        this.contentLabel.setBackground(SystemColor.window);
        this.contentLabel.setBorder(this.border1);
        this.contentLabel.setText("Infusion1");
        this.picturepanel.setBackground(SystemColor.window);
        this.picturepanel.setOpaque(false);
        this.setOpaque(false);
        this.sliderpanel.setOpaque(false);
        this.centrepanel.setOpaque(false);
        this.jPanel1.setOpaque(false);
        this.jLabel3.setText("Hourly");
        this.jLabel4.setText("mL");
        this.jPopupMenu1.add(this.jMenuItem1);
        this.add((Component)this.sliderpanel, "East");
        this.sliderpanel.add((Component)this.rateSlider, "Center");
        this.add((Component)this.centrepanel, "Center");
        this.add((Component)this.jPanel1, "West");
        this.jPanel1.add((Component)this.volumeSlider, "Center");
        this.jPanel1.add((Component)this.jLabel2, "North");
        this.jPanel1.add((Component)this.jLabel4, "South");
        this.sliderpanel.add((Component)this.jLabel1, "North");
        this.sliderpanel.add((Component)this.jLabel3, "South");
        this.centrepanel.add((Component)this.contentLabel, "North");
        this.centrepanel.add((Component)this.picturepanel, "Center");
    }

    void rateSlider_stateChanged(ChangeEvent e) {
        double rate = this.rateSlider.getValue();
        if (rate == 0.0) {
            rate = 0.16666666666666666;
        }
        this.infusion.rate = 1.0 / (rate * 60.0);
    }
}

