/*
 * Decompiled with CFR 0.152.
 */
package phic.doctor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import phic.Current;
import phic.IntravenousInfusion;
import phic.Resource;
import phic.common.IniReader;
import phic.doctor.IFrame;
import phic.doctor.SelectionFrame;
import phic.drug.NoSuchDrugException;

public class FluidsSelection
extends IFrame {
    private JPanel jPanel1 = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private SelectionFrame selectionFrame1 = new SelectionFrame(true);
    IniReader ir = new IniReader("doctor/Selections.txt");
    private JPanel jPanel2 = new JPanel();
    private JButton infusebutton = new JButton();

    public FluidsSelection() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setupFromSection("Fluids");
        this.setDefaultCloseOperation(2);
        this.setFrameIcon(new ImageIcon(Resource.loader.getImageResource("Container.gif")));
    }

    public void setupFromSection(String section) {
        this.selectionFrame1.setupFromSection(this.ir, section);
        this.setPreferredSize(new Dimension(260, 230));
        this.setMinimumSize(new Dimension(80, 100));
    }

    private void jbInit() throws Exception {
        this.jPanel1.setLayout(this.borderLayout1);
        this.infusebutton.setToolTipText("Begin infusing the selected fluid intravenously");
        this.infusebutton.setText("Start fluid");
        this.infusebutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FluidsSelection.this.infusebutton_actionPerformed(e);
            }
        });
        this.setTitle("Fluids");
        this.setToolTipText("The list of fluids available for intravenous infusion");
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.selectionFrame1, "Center");
        this.jPanel1.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.infusebutton, null);
    }

    void infusebutton_actionPerformed(ActionEvent e) {
        try {
            IntravenousInfusion ivi = new IntravenousInfusion(Current.person.body.blood);
            ivi.add(this.selectionFrame1.getSelectedSubstance());
            this.frame.patientFrame.setCurrentInfusion(ivi, this.selectionFrame1.getSelectedImage(), this.selectionFrame1.getSelectedName());
        }
        catch (NoSuchDrugException x) {
            JOptionPane.showInternalMessageDialog(this, x, "Cannot infuse fluid", 0);
        }
    }
}

