/*
 * Decompiled with CFR 0.152.
 */
package phic.doctor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import phic.Current;
import phic.IntravenousInfusion;
import phic.Resource;
import phic.common.IniReader;
import phic.doctor.IFrame;
import phic.doctor.InfusionPanel;
import phic.doctor.SelectionFrame;
import phic.drug.NoSuchDrugException;

public class DrugSelection
extends IFrame {
    private JPanel jPanel1 = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel jPanel2 = new JPanel();
    private JPanel jPanel3 = new JPanel();
    private JButton injectbutton = new JButton();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JPanel jPanel4 = new JPanel();
    private JComboBox catlist = new JComboBox();
    private DefaultComboBoxModel catlistmodel = new DefaultComboBoxModel();
    Image syringe = Resource.loader.getImageResource("doctor/SyringeCursor3.gif");
    ImageIcon syringeIcon = new ImageIcon(this.syringe);
    String file = "doctor/WardDrugs.txt";
    String categoryListName = "Categories";
    IniReader ir = new IniReader(this.file);
    private SelectionFrame selectionFrame1 = new SelectionFrame();
    private JButton infusebutton = new JButton();

    public DrugSelection() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.injectbutton.setIcon(this.syringeIcon);
        this.initialise();
        this.setDefaultCloseOperation(2);
        this.setFrameIcon(new ImageIcon(Resource.loader.getImageResource("Pharmacy.jpg")));
    }

    private void jbInit() throws Exception {
        this.jPanel1.setLayout(this.borderLayout1);
        this.injectbutton.setToolTipText("Inject the drug intravenously");
        this.injectbutton.setText("Inject");
        this.injectbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrugSelection.this.injectbutton_actionPerformed(e);
            }
        });
        this.jPanel2.setLayout(this.borderLayout2);
        this.catlist.setToolTipText("Select the category of drugs to display");
        this.catlist.setModel(this.catlistmodel);
        this.catlist.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrugSelection.this.catlist_actionPerformed(e);
            }
        });
        this.setTitle("Drugs");
        this.setToolTipText("List of drugs for oral or intravenous use");
        this.infusebutton.setToolTipText("Adds the drug to the current infusion");
        this.infusebutton.setText("Infuse");
        this.infusebutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DrugSelection.this.infusebutton_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.selectionFrame1, "Center");
        this.jPanel1.add((Component)this.jPanel3, "South");
        this.jPanel3.add((Component)this.injectbutton, null);
        this.jPanel3.add((Component)this.infusebutton, null);
        this.jPanel1.add((Component)this.jPanel4, "North");
        this.jPanel4.add((Component)this.catlist, null);
    }

    public void initialise() {
        this.catlistmodel = new DefaultComboBoxModel<String>(this.ir.getSectionStrings(this.categoryListName));
        this.catlist.setModel(this.catlistmodel);
        this.catlist.setSelectedIndex(0);
        this.setPreferredSize(new Dimension(230, 200));
    }

    void catlist_actionPerformed(ActionEvent e) {
        String druglist = this.catlist.getSelectedItem().toString();
        this.selectionFrame1.setupFromSection(this.ir, druglist);
        this.selectionFrame1.validate();
        this.selectionFrame1.repaint();
    }

    void injectbutton_actionPerformed(ActionEvent e) {
        try {
            Current.person.body.blood.add(this.selectionFrame1.getSelectedSubstance());
            Current.person.body.message("Injected " + this.selectionFrame1.getSelectedName());
        }
        catch (NoSuchDrugException x) {
            JOptionPane.showInternalMessageDialog(this, x, "Could not inject drug", 0);
        }
    }

    void infusebutton_actionPerformed(ActionEvent e) {
        try {
            IntravenousInfusion ivi = this.frame.patientFrame.getCurrentInfusion();
            if (ivi == null) {
                throw new Exception("Please start an infusion first, from the Fluids menu.");
            }
            ivi.add(this.selectionFrame1.getSelectedSubstance());
            InfusionPanel p = this.frame.patientFrame.infusionPanel;
            String added = this.selectionFrame1.getSelectedName();
            p.setup(ivi, String.valueOf(p.contentLabel.getText()) + "+" + added, p.image);
            Current.person.body.message(String.valueOf(added) + "Added to infusion");
        }
        catch (Exception x) {
            JOptionPane.showInternalMessageDialog(this, x, "Could not inject drug", 0);
        }
    }
}

