/*
 * Decompiled with CFR 0.152.
 */
package phic.doctor;

import java.util.StringTokenizer;
import phic.common.Container;
import phic.common.Fluids;
import phic.common.Quantity;
import phic.drug.NoSuchDrugException;
import phic.drug.Pharmacy;

public class DrugParser {
    private static String[] fluidNames = Fluids.getNames();
    private static String[] drugNames = Pharmacy.getDrugList();
    private static String delimiters = "+,";

    public static Container createSubstance(String description) throws NoSuchDrugException {
        Container substance = new Container();
        StringTokenizer st = new StringTokenizer(description);
        while (st.hasMoreTokens()) {
            double quantity;
            String name;
            String t = st.nextToken();
            if (delimiters.indexOf(t) >= 0) continue;
            if (DrugParser.isFluid(t)) {
                name = t;
                if (!st.hasMoreTokens()) {
                    throw new IllegalArgumentException("Volume expected after fluid '" + t + "'");
                }
                double volume = Double.parseDouble(st.nextToken());
                substance.add(Fluids.get(name, volume));
                continue;
            }
            if (DrugParser.isDrug(t)) {
                name = t;
                if (!st.hasMoreTokens()) {
                    throw new IllegalArgumentException("Quantity expected after drug '" + t + "'");
                }
                quantity = Double.parseDouble(st.nextToken());
                substance = Pharmacy.addDrugToContainer(name, quantity, substance);
                continue;
            }
            if (DrugParser.isConstituent(t)) {
                Quantity q = null;
                int i = 0;
                while (i < Container.quantityname.length) {
                    if (Container.quantityname[i].equalsIgnoreCase(t)) {
                        q = (Quantity)substance.qs.get(i);
                    }
                    ++i;
                }
                if (!st.hasMoreTokens()) {
                    throw new IllegalArgumentException("Quantity expected after drug '" + t + "'");
                }
                quantity = Double.parseDouble(st.nextToken());
                q.addQ(quantity);
                continue;
            }
            throw new NoSuchDrugException("'" + t + "' is not a fluid nor a drug");
        }
        return substance;
    }

    public static boolean isFluid(String name) {
        int i = 0;
        while (i < fluidNames.length) {
            if (fluidNames[i].equalsIgnoreCase(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isDrug(String name) {
        int i = 0;
        while (i < drugNames.length) {
            if (drugNames[i].equalsIgnoreCase(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isConstituent(String name) {
        int i = 0;
        while (i < Container.quantityname.length) {
            if (Container.quantityname[i].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

