/*
 * Decompiled with CFR 0.152.
 */
package phic.doctor;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import phic.Current;
import phic.IntravenousInfusion;
import phic.Person;
import phic.doctor.BloodTestResults;
import phic.doctor.Console;
import phic.doctor.DrugSelection;
import phic.doctor.FluidsSelection;
import phic.doctor.ObservationsChart;
import phic.doctor.PatientFrame;
import phic.doctor.TimeControl;
import phic.gui.FrameStub;
import phic.gui.Variables;
import sanjay.PlafMenu;

public class DoctorFrame
extends JFrame
implements FrameStub {
    private JDesktopPane desktop = new JDesktopPane();
    protected int width = 800;
    protected int height = 600;
    private JMenuBar jMenuBar1 = new JMenuBar();
    private JMenu jMenu1 = new JMenu();
    private JMenuItem jMenuItem1 = new JMenuItem();
    private JMenuItem jMenuItem2 = new JMenuItem();
    private JMenuItem jMenuItem3 = new JMenuItem();
    public JMenu windowmenu = new JMenu();
    private TimeControl timecontrol = new TimeControl();
    public PatientFrame patientFrame = new PatientFrame();
    Timer updater = new Timer(300, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            DoctorFrame.this.timecontrol.updateDisplay();
            DoctorFrame.this.patientFrame.updateDisplay();
        }
    });
    Console console = new Console();
    Person person;
    private JMenu helpmenu = new JMenu();
    private JMenu jMenu2 = new JMenu();
    private JMenuItem bloodtestsmenu = new JMenuItem();
    private JMenu jMenu3 = new JMenu();
    private JMenuItem fluidsmenu = new JMenuItem();
    private JMenuItem drugsmenu = new JMenuItem();
    private JMenuItem observationsmenu = new JMenuItem();
    ObservationsChart obsChart;
    boolean running = true;
    Alerter alerter = new Alerter();

    public static void main(String[] s) {
        DoctorFrame df = new DoctorFrame();
    }

    public DoctorFrame() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setSize(this.width, this.height);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screen.width - this.width) / 2, (screen.height - this.height) / 2);
        this.show();
        this.desktop.add(this.console);
        this.desktop.add(this.timecontrol);
        this.desktop.add(this.patientFrame);
        this.setContentPane(this.desktop);
        this.timecontrol.show();
        this.updater.start();
        this.helpmenu.add(new PlafMenu(this.desktop));
        this.initialisePhic();
        this.person.body.receiver = this.console;
        this.person.body.setRunning(true);
        this.createObservationsWindow();
    }

    private void jbInit() throws Exception {
        this.setJMenuBar(this.jMenuBar1);
        this.setTitle("Doctor window");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DoctorFrame.this.this_windowClosing(e);
            }
        });
        this.jMenu1.setText("File");
        this.jMenuItem1.setText("Open");
        this.jMenuItem2.setText("Save");
        this.jMenuItem3.setText("Exit");
        this.windowmenu.setText("Window");
        this.helpmenu.setText("Help");
        this.jMenu2.setText("Investigation");
        this.bloodtestsmenu.setText("Blood tests");
        this.bloodtestsmenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DoctorFrame.this.bloodtestsmenu_actionPerformed(e);
            }
        });
        this.jMenu3.setText("Intervention");
        this.fluidsmenu.setText("Fluids");
        this.fluidsmenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DoctorFrame.this.fluidsmenu_actionPerformed(e);
            }
        });
        this.drugsmenu.setText("Drugs");
        this.drugsmenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DoctorFrame.this.drugsmenu_actionPerformed(e);
            }
        });
        this.observationsmenu.setText("Observations");
        this.observationsmenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DoctorFrame.this.observationsmenu_actionPerformed(e);
            }
        });
        this.jMenuBar1.add(this.jMenu1);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenuBar1.add(this.jMenu3);
        this.jMenuBar1.add(this.windowmenu);
        this.jMenuBar1.add(this.helpmenu);
        this.jMenu1.add(this.jMenuItem1);
        this.jMenu1.add(this.jMenuItem2);
        this.jMenu1.addSeparator();
        this.jMenu1.add(this.jMenuItem3);
        this.jMenu2.add(this.bloodtestsmenu);
        this.jMenu2.add(this.observationsmenu);
        this.jMenu3.add(this.fluidsmenu);
        this.jMenu3.add(this.drugsmenu);
    }

    void initialisePhic() {
        Variables.initialise();
        this.person = Current.person;
        this.person.body = Current.body;
        this.person.environment = Current.environment;
    }

    void this_windowClosing(WindowEvent e) {
        System.exit(0);
    }

    void bloodtestsmenu_actionPerformed(ActionEvent e) {
        BloodTestResults b = new BloodTestResults(this.person);
        this.desktop.add(b);
        b.show();
    }

    void fluidsmenu_actionPerformed(ActionEvent e) {
        FluidsSelection f = new FluidsSelection();
        this.desktop.add(f);
        f.show();
    }

    void drugsmenu_actionPerformed(ActionEvent e) {
        DrugSelection d = new DrugSelection();
        this.desktop.add(d);
        d.show();
    }

    void observationsmenu_actionPerformed(ActionEvent e) {
        if (this.obsChart == null) {
            this.createObservationsWindow();
        }
        this.obsChart.show();
    }

    protected void createObservationsWindow() {
        this.obsChart = new ObservationsChart(this.person);
        this.desktop.add(this.obsChart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alert(Object message, Object title) {
        Alerter alerter = this.alerter;
        synchronized (alerter) {
            this.alerter.message = message;
            this.alerter.title = title;
            this.alerter.notify();
        }
    }

    public void addCloseListener(final ActionListener reshowListener) {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                reshowListener.actionPerformed(new ActionEvent(e.getSource(), e.getID(), "Close"));
            }
        });
    }

    public void doSetup(String setupFile, String setupSection) {
    }

    public void finishDrip(IntravenousInfusion ivi) {
    }

    public JFrame getJFrame() {
        return this;
    }

    public void markEvent(Object event) {
    }

    public void message(String message) {
        this.console.message(message);
    }

    public void patientWarning(int level, String message) {
    }

    class Alerter
    implements Runnable {
        Object message;
        Object title;
        Thread thread = new Thread(this);

        Alerter() {
            this.thread.start();
        }

        public synchronized void run() {
            try {
                while (DoctorFrame.this.running) {
                    this.wait();
                    JOptionPane.showInternalMessageDialog(DoctorFrame.this.desktop, this.message, this.title.toString(), 1);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

