/*
 * Decompiled with CFR 0.152.
 */
package phic.doctor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class ClockPanel
extends JPanel {
    long time;
    int ticklen = 3;

    void updateClock(long time) {
        this.time = time;
        this.repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int cx = this.getWidth() / 2;
        int cy = this.getHeight() / 2;
        int r = Math.min(cx, cy) - 1;
        g.setColor(Color.white);
        g.fillOval(cx - r, cy - r, 2 * r, 2 * r);
        g.setColor(Color.black);
        g.drawOval(cx - r, cy - r, 2 * r, 2 * r);
        int i = 0;
        while (i < 12) {
            double a = (double)i * Math.PI * 2.0 / 12.0;
            double s = Math.sin(a);
            double c = Math.cos(a);
            g.drawLine((int)((double)cx + (double)r * s), (int)((double)cy - (double)r * c), (int)((double)cx + (double)(r - this.ticklen) * s), (int)((double)cy - (double)(r - this.ticklen) * c));
            ++i;
        }
        double asec = (double)(this.time / 1000L % 60L) / 60.0 * Math.PI * 2.0;
        double rsec = (double)r * 0.8;
        g.drawLine(cx, cy, cx + (int)(rsec * Math.sin(asec)), (int)((double)cy - rsec * Math.cos(asec)));
        asec = (double)(this.time / 60000L % 60L) / 60.0 * Math.PI * 2.0;
        rsec = (double)r * 0.9;
        g2.setStroke(new BasicStroke(2.0f));
        g.drawLine(cx, cy, cx + (int)(rsec * Math.sin(asec)), (int)((double)cy - rsec * Math.cos(asec)));
        double fhrs = (double)this.time / 3600000.0;
        asec = (fhrs / 12.0 - (double)((int)(fhrs / 12.0))) * Math.PI * 2.0;
        rsec = (double)r * 0.5;
        g2.setStroke(new BasicStroke(3.0f));
        g.drawLine(cx, cy, cx + (int)(rsec * Math.sin(asec)), (int)((double)cy - rsec * Math.cos(asec)));
    }
}

