/*
 * Decompiled with CFR 0.152.
 */
package phic.common.realtime;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import phic.Current;
import phic.common.Variable;

public class MultipleMonitorsPanel
extends JPanel {
    JPopupMenu jPopupMenu1 = new JPopupMenu();
    JMenuItem zerocommand = new JMenuItem();
    Vector vars = new Vector();
    final Color[] colors = new Color[]{Color.red, Color.green, Color.magenta, Color.yellow, Color.cyan, Color.pink, Color.gray, Color.orange};
    int serial = 0;
    public int timeDelay = 100;
    Thread thread = new Thread(new Runnable(){

        /*
         * Unable to fully structure code
         */
        public void run() {
            running = true;
            ** GOTO lbl22
            {
                i = 0;
                while (i < MultipleMonitorsPanel.this.vars.size()) {
                    dv = (DisplayVariable)MultipleMonitorsPanel.this.vars.get(i);
                    dv.tick();
                    ++i;
                }
                MultipleMonitorsPanel.this.repaint();
                try {
                    Thread.sleep(MultipleMonitorsPanel.this.timeDelay);
                }
                catch (InterruptedException var2_3) {
                    // empty catch block
                }
                do {
                    if (Current.body.getClock().running) continue block4;
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException var2_4) {
                        // empty catch block
                    }
lbl22:
                    // 3 sources

                } while (running);
            }
        }
    }, "MonitoringScreen");

    public MultipleMonitorsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.thread.start();
    }

    private void jbInit() throws Exception {
        this.setBackground(Color.black);
        this.setForeground(Color.green);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                MultipleMonitorsPanel.this.this_componentResized(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                MultipleMonitorsPanel.this.this_mouseReleased(e);
            }
        });
        this.setLayout(null);
        this.zerocommand.setText("Zero");
        this.zerocommand.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultipleMonitorsPanel.this.command(e);
            }
        });
        this.jPopupMenu1.add(this.zerocommand);
    }

    public void addVariable(Variable v, String n) {
        DisplayVariable dv = new DisplayVariable(v, n);
        this.vars.add(dv);
        dv.color = this.colors[this.serial++ % this.colors.length];
        dv.label.setForeground(dv.color);
        this.rescale();
    }

    void rescale() {
        int i = 0;
        while (i < this.vars.size()) {
            DisplayVariable dv = (DisplayVariable)this.vars.get(i);
            dv.resetPoints();
            Dimension d = dv.label.getPreferredSize();
            dv.label.setBounds(0, i * this.getHeight() / this.vars.size() + 10, d.width, d.height);
            dv.baseY = (int)(((double)i + 0.5) * (double)this.getHeight() / (double)this.vars.size());
            ++i;
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int i = 0;
        while (i < this.vars.size()) {
            DisplayVariable dv = (DisplayVariable)this.vars.get(i);
            g.setColor(dv.color);
            dv.paint(g);
            ++i;
        }
    }

    void command(ActionEvent e) {
        if (e.getActionCommand().equals("Zero")) {
            int i = 0;
            while (i < this.vars.size()) {
                DisplayVariable dv = (DisplayVariable)this.vars.get(i);
                dv.zero();
                ++i;
            }
        }
    }

    void this_mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.jPopupMenu1.show(this, e.getPoint().x, e.getPoint().y);
        }
    }

    void this_componentResized(ComponentEvent e) {
        this.rescale();
    }

    class DisplayVariable {
        Variable variable;
        JLabel label;
        Color color;
        int zeroingCount = 0;
        double zeroTotal = 0.0;
        double zeroingMax = Double.MIN_VALUE;
        double zeroingMin = Double.MAX_VALUE;
        int maxZeroingCount = 180;
        boolean zeroing = true;
        int timebase = 4;
        int x;
        int baseY;
        double baseValue;
        double scaleY;
        int[] y;

        public DisplayVariable(Variable variable, String name) {
            this.variable = variable;
            this.label = new JLabel(name);
            MultipleMonitorsPanel.this.add(this.label);
            this.resetPoints();
        }

        void resetPoints() {
            this.y = new int[MultipleMonitorsPanel.this.getWidth() / this.timebase];
            int i = 0;
            while (i < this.y.length) {
                this.y[i] = this.baseY;
                ++i;
            }
        }

        public void paint(Graphics g) {
            int i = 1;
            while (i < this.y.length) {
                g.drawLine((i - 1) * this.timebase, this.y[i - 1], i * this.timebase, this.y[i]);
                ++i;
            }
            if (this.zeroing) {
                g.drawString("Zeroing...", 0, this.baseY + 10);
            }
        }

        void tick() {
            double value = this.variable.get();
            if (!Current.body.clock.isSlowMode) {
                return;
            }
            if (this.zeroing) {
                this.zeroTotal += value;
                this.zeroingMin = Math.min(this.zeroingMin, value);
                this.zeroingMax = Math.max(this.zeroingMax, value);
                ++this.zeroingCount;
                if (this.zeroingCount > this.maxZeroingCount) {
                    this.finishedZeroing();
                }
            } else {
                if (this.y.length == 0) {
                    return;
                }
                this.x += this.timebase;
                this.x %= this.y.length * this.timebase;
                this.y[this.x / this.timebase] = (int)(-(value - this.baseValue) * this.scaleY + (double)this.baseY);
            }
        }

        public void zero() {
            this.zeroing = true;
            this.zeroingCount = 0;
            this.zeroTotal = 0.0;
        }

        void finishedZeroing() {
            if (this.zeroingMax == this.zeroingMin) {
                this.zeroingMax += 1.0;
                System.out.println("Did not zero successfully");
            }
            this.zeroing = false;
            this.baseValue = this.zeroTotal / (double)this.zeroingCount;
            this.scaleY = (double)(MultipleMonitorsPanel.this.getHeight() / MultipleMonitorsPanel.this.vars.size()) / (this.zeroingMax - this.zeroingMin);
        }
    }
}

