/*
 * Decompiled with CFR 0.152.
 */
package phic.common.realtime;

import phic.Body;
import phic.Current;
import phic.common.Clock;
import phic.common.Variable;
import phic.ecg.Lead;
import phic.ecg.PhicHeart;
import phic.ecg.Trace;

public class CardiacMonitors {
    Body body;
    PhicHeart ph;
    Lead LII;
    double[][] data;
    public LeadII leadII;
    double lastPhase;
    int lastPos;
    double lastVal;

    public CardiacMonitors(Body body) {
        this.ph = new PhicHeart(this.body);
        this.LII = Trace.leads[Trace.II];
        this.leadII = new LeadII();
        this.lastPhase = 0.0;
        this.lastPos = 0;
        this.lastVal = 0.0;
        this.body = body;
        this.data = this.LII.getPoints(this.ph.createField());
    }

    class LeadII
    implements Variable {
        LeadII() {
        }

        public double get() {
            Clock c = CardiacMonitors.this.body.getClock();
            double millis = c.elapsedTime();
            c.latch();
            double phase = Current.body.CVS.heart.phase;
            if (phase < CardiacMonitors.this.lastPhase) {
                CardiacMonitors.this.data = CardiacMonitors.this.LII.getPoints(CardiacMonitors.this.ph.createField());
            }
            int pos = 0;
            double cumTime = 0.0;
            int i = 0;
            while (i < CardiacMonitors.this.data.length) {
                if ((cumTime += CardiacMonitors.this.data[i][0]) > phase) {
                    pos = i;
                    break;
                }
                ++i;
            }
            if (CardiacMonitors.this.lastPos == pos - 1) {
                return CardiacMonitors.this.lastVal;
            }
            int a = CardiacMonitors.this.lastPos;
            int b = pos;
            double peak = 0.0;
            int i2 = a;
            while (i2 != b) {
                if (peak < Math.abs(CardiacMonitors.this.data[i2][1])) {
                    peak = CardiacMonitors.this.data[i2][1];
                }
                i2 = (i2 + 1) % CardiacMonitors.this.data.length;
            }
            CardiacMonitors.this.lastPos = pos - 1;
            if (CardiacMonitors.this.lastPos < 0) {
                CardiacMonitors.this.lastPos += CardiacMonitors.this.data.length;
            }
            CardiacMonitors.this.lastVal = peak;
            return CardiacMonitors.this.lastVal;
        }

        public void set(double d) {
        }
    }
}

