/*
 * Decompiled with CFR 0.152.
 */
package phic.common;

import phic.common.Quantity;
import phic.common.UnitConstants;
import phic.common.Variable;
import phic.gui.Variables;
import phic.modifiable.Range;

public class VDouble
implements Variable {
    public double initialValue = 0.0;
    public double minimum = 0.0;
    public double maximum = 1.0;
    protected Object lock = null;
    private double value;
    protected int unit;
    private Range range = null;

    public final void setRanges(double initialValue, double minimum, double maximum) {
        this.initialValue = initialValue;
        this.minimum = minimum;
        this.maximum = maximum;
    }

    public VDouble() {
    }

    public VDouble(Object lock) {
        this.lock = lock;
    }

    public VDouble(int unit) {
        this.unit = unit;
    }

    public double get() {
        return this.value;
    }

    public void set(double v) {
        this.value = v;
    }

    protected void throwSettingError() {
        String err = null;
        try {
            err = "Error setting " + Variables.forVDouble((VDouble)this).longName;
        }
        catch (IllegalArgumentException ex) {
            err = "Error setting VDouble " + this.formatValue(true, false);
        }
        Thread.currentThread();
        Thread.dumpStack();
        throw new ArithmeticException(err);
    }

    public void add(double amount) {
        if (this.lock == null) {
            this.set(this.get() + amount);
        } else {
            this.set(this.get() + amount);
        }
    }

    public void addQuantity(double amount) {
        this.set(Math.max(0.0, this.get() + amount));
    }

    public final void addLimited(double amount) {
        this.set(Math.max(Math.min(this.get() + amount, this.maximum), this.minimum));
    }

    public void multiplyBy(double ratio) {
        this.set(ratio * this.get());
    }

    public final void initialise() {
        this.set(this.initialValue);
    }

    public final double getError() {
        return this.get() - this.initialValue;
    }

    public final double getErrorRatio() {
        return this.get() / this.initialValue;
    }

    public void regulate(VDouble controller, double gradient, double lowPassRate) {
        this.lowPass(this.initialValue + gradient * controller.getError(), lowPassRate);
    }

    public void regulate(VDouble controller, double gradient, double lowPassRate, double constant) {
        this.lowPass(this.initialValue + gradient * controller.getError() + constant, lowPassRate);
    }

    public void regulateQuantity(VDouble controller, double gradient, double lowPassRate) {
        double target = this.initialValue + gradient * controller.getError();
        target = Math.min(Math.max(target, this.minimum), this.maximum);
        this.lowPass(target, lowPassRate);
    }

    public void regulateQuantity(VDouble controller, double gradient, double lowPassRate, double constant) {
        double target = this.initialValue + gradient * controller.getError();
        target = Math.min(Math.max(target, this.minimum), this.maximum) + constant;
        this.lowPass(target, lowPassRate);
    }

    public void regulateAboveZero(VDouble controller, double gradient, double lowPassRate) {
        double target = this.initialValue + gradient * controller.getError();
        target = Math.max(target, 0.0);
        this.lowPass(target, lowPassRate);
    }

    public final void lowPass(double desiredValue, double lowPassRate) {
        this.set(this.get() * (1.0 - lowPassRate) + desiredValue * lowPassRate);
    }

    public final void lowPassQuantity(double desiredValue, double lowPassRate) {
        double target = Math.min(Math.max(desiredValue, this.minimum), this.maximum);
        this.set(this.get() * (1.0 - lowPassRate) + target * lowPassRate);
    }

    protected void cannotSet() {
    }

    public boolean isSettable() {
        return true;
    }

    public String toString() {
        return Quantity.toString(this.get());
    }

    public void setUnit(int u) {
        this.unit = u;
    }

    public int getUnit() {
        return this.unit;
    }

    public String formatValue(double v, boolean showUnit, boolean fixed) {
        return UnitConstants.formatValue(v, this.unit, showUnit, fixed);
    }

    public final String formatValue(boolean showUnit, boolean fixed) {
        return this.formatValue(this.get(), showUnit, fixed);
    }

    public final double limitValue(double target) {
        return Math.max(Math.min(target, this.maximum), this.minimum);
    }

    public Range getRange() {
        if (this.range == null) {
            this.range = new Range(this.minimum, this.maximum);
        }
        return this.range;
    }
}

