/*
 * Decompiled with CFR 0.152.
 */
package phic.common;

import java.util.Map;
import phic.common.IniReader;
import phic.gui.Variables;

public class UnitConstants {
    public static final int PER_MIN = 15;
    public static final int LITRES = 4;
    public static final int LITRES_PER_MIN = 12;
    public static final int METRES_HG = 6;
    public static final int PRU = 16;
    public static final int OSMOLES = 11;
    public static final int PERCENT = 17;
    public static final int NUMBER = 0;
    public static final int MOLAR = 14;
    public static final int DEGREES = 8;
    public static final int GRAMS = 3;
    public static final int GRAMS_PER_ML = 20;
    public static final int JOULES_PER_MIN = 18;
    public static final int LITRES_PER_ML = 19;
    public static final int GRAMS_PER_LITRE = 21;
    public static final int CAL_PER_DAY = 23;
    public static final int MOLES = 22;
    public static final int UNITS_PER_LITRE = 24;
    public static final int UNITS = 25;
    public static final int SQUARE_METRES = 26;
    public static final int JOULES = 27;
    public static final int LITRES_PER_MHG = 28;
    public static final String[] ustring = new String[]{"", "1", "2", "g", "L", "5", "mHg", "7", "\u00b0C", "9", "10", "Osm", "L/min", "13", "M", "/min", "PRU", "%", "J/min", "L/L", "g/mL", "g/L", "mol", "cal/d", "U/L", "U", "sq m", "J", "L/mHg"};
    public static final String[] uprefix = new String[]{"p", "n", "\u00b5", "m", "", "k", "M"};
    public static int significantFigures = 4;
    public static final double Pa_per_mHg = 133322.36841;
    public static final double mH2O_per_mHg = 13.595098;
    public static final double g_per_lb = 453.59237;
    public static final double J_per_cal = 4.1868;
    public static final double L_per_gal = 3.78541178;
    public static final double pints_per_L = 2.1133764;
    private static IniReader overrides = new IniReader("UnitOverrides.txt");
    private static boolean useUnitOverrides = false;

    public static final String formatValue(double v, int units, boolean addUnitSuffix, boolean fixed) {
        if (Double.isNaN(v)) {
            return "[Error]";
        }
        String prefix = "";
        boolean neg = v < 0.0;
        v = Math.abs(v);
        if (units == 17) {
            v *= 100.0;
        }
        if (UnitConstants.canPrefix(units) && v != 0.0) {
            int i = 0;
            while (i < uprefix.length) {
                double j = Math.pow(10.0, (i - 4) * 3);
                if (v < j * 1000.0 || i == uprefix.length - 1) {
                    prefix = uprefix[i];
                    v /= j;
                    break;
                }
                ++i;
            }
        }
        String s = null;
        if (fixed) {
            s = Double.toString(v = v >= 100.0 ? (double)Math.round(v * 10.0) / 10.0 : (v >= 10.0 ? (double)Math.round(100.0 * v) / 100.0 : Math.rint(1000.0 * v) / 1000.0));
            if (s.length() < 5 && s.indexOf(46) > 0) {
                s = String.valueOf(s) + '0';
                while (s.length() < 5) {
                    s = String.valueOf(s) + '0';
                }
            }
        } else {
            s = Double.toString(v = (double)Math.round(v * 1000.0) / 1000.0);
            if (s.endsWith(".0")) {
                s = s.substring(0, s.length() - 2);
            }
        }
        if (addUnitSuffix) {
            return String.valueOf(neg ? "-" : "") + s + " " + prefix + ustring[units];
        }
        return String.valueOf(neg ? "-" : "") + s;
    }

    public static final double getUnitMultiplier(double value, int unit) {
        if (UnitConstants.canPrefix(unit)) {
            int i = 0;
            while (i < uprefix.length) {
                double j = Math.pow(10.0, (i - 4) * 3);
                if (value < j * 1000.0 || i == uprefix.length - 1) {
                    return j;
                }
                ++i;
            }
            return 1.0;
        }
        if (unit == 17) {
            return 0.01;
        }
        return 1.0;
    }

    public static String formatValue(double v, int units, boolean fixed) {
        return UnitConstants.formatValue(v, units, true, fixed);
    }

    public static boolean canPrefix(int u) {
        return u != 8 && u != 17 && u != 15 && u != 0 && u != 26;
    }

    public static void setUseUnitOverrides(boolean b) {
        useUnitOverrides = b;
        Variables.recheckOverridden();
    }

    public static boolean getUseUnitOverrides() {
        return useUnitOverrides;
    }

    public static boolean canVariableBeOverridden(String variableName) {
        String[] s = overrides.getSectionHeaders();
        int i = 0;
        while (i < s.length) {
            if (s[i].equalsIgnoreCase(variableName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getOverriddenUnit(String variableName) {
        Map m = overrides.getSectionMap(variableName);
        return m.get("Unit").toString();
    }

    public static double getOverridenConversion(String variableName) {
        Map m = overrides.getSectionMap(variableName);
        return (Double)m.get("Conversion");
    }

    public static double roundSigFigs(double value, int sf) {
        int ord = (int)(Math.log(value) / Math.log(10.0));
        double msk = Math.pow(10.0, ord + sf);
        return (double)((int)(value * msk)) / msk;
    }
}

