/*
 * Decompiled with CFR 0.152.
 */
package phic.common;

import phic.common.Curve;
import phic.common.Table;
import phic.common.VDouble;

public class TwoVarTable
extends Table {
    double[][] values;
    protected TableCurve curveX;
    protected TableCurve curveY;

    public TwoVarTable(String file, int width) {
        super(file, width);
        this.initValues();
    }

    protected void initValues() {
        this.values = new double[this.nRows][this.nCols];
        int i = 0;
        while (i < this.nRows) {
            int j = 0;
            while (j < this.nCols) {
                if (i != 0 || j != 0) {
                    this.values[i][j] = this.getDouble(i, j);
                }
                ++j;
            }
            ++i;
        }
    }

    public double lookUp(double v1, double v2) {
        int i = 1;
        while (i < this.nRows - 1) {
            if (v2 < this.values[i + 1][0]) break;
            ++i;
        }
        int j = 1;
        while (j < this.nCols - 1) {
            if (v1 < this.values[0][j + 1]) break;
            ++j;
        }
        if (i == this.nRows - 1) {
            i = this.nRows - 2;
        }
        if (j == this.nCols - 1) {
            j = this.nCols - 2;
        }
        double o = this.values[i][j];
        double tmp = this.values[i][0];
        double fraci = (v2 - tmp) / (this.values[i + 1][0] - tmp);
        tmp = this.values[0][j];
        double fracj = (v1 - tmp) / (this.values[0][j + 1] - tmp);
        double ri1 = o + (this.values[i + 1][j] - o) * fraci;
        o = this.values[i][j + 1];
        double ri2 = o + (this.values[i + 1][j + 1] - o) * fraci;
        return ri1 + (ri2 - ri1) * fracj;
    }

    public Curve getXCurve(VDouble yValue) {
        if (this.curveX == null) {
            this.curveX = new TableCurve(false, yValue);
        }
        return this.curveX;
    }

    public Curve getYCurve(VDouble xValue) {
        if (this.curveY == null) {
            this.curveY = new TableCurve(true, xValue);
        }
        return this.curveY;
    }

    class TableCurve
    extends Curve {
        boolean xaxis;
        VDouble otherValue;

        TableCurve(boolean xaxis, VDouble otherValue) {
            this.xaxis = xaxis;
            this.otherValue = otherValue;
        }

        public double getValue(double x) {
            if (this.xaxis) {
                return TwoVarTable.this.lookUp(x, this.otherValue.get());
            }
            return TwoVarTable.this.lookUp(this.otherValue.get(), x);
        }

        public double getInverse(double y) {
            throw new IllegalStateException("Noninvertible function - two-variable table.");
        }
    }
}

